/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.asm;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import logisticspipes.LPConstants;
import logisticspipes.asm.ParamProfiler;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class LogisticsClassTransformer
implements IClassTransformer {
    public List<String> interfacesToClearA = new ArrayList<String>();
    public List<String> interfacesToClearB = new ArrayList<String>();
    private final LaunchClassLoader cl = (LaunchClassLoader)LogisticsClassTransformer.class.getClassLoader();
    private Field negativeResourceCache;
    private Field invalidClasses;

    public LogisticsClassTransformer() {
        try {
            this.negativeResourceCache = LaunchClassLoader.class.getDeclaredField("negativeResourceCache");
            this.negativeResourceCache.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.invalidClasses = LaunchClassLoader.class.getDeclaredField("invalidClasses");
            this.invalidClasses.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        Thread thread = Thread.currentThread();
        if (thread.getName().equals("Minecraft main thread") || thread.getName().equals("main") || thread.getName().equals("Server thread")) {
            this.clearNegativeInterfaceCache();
        }
        if (bytes == null) {
            return null;
        }
        return ParamProfiler.handleClass(bytes);
    }

    public void clearNegativeInterfaceCache() {
        if (this.negativeResourceCache != null && !this.interfacesToClearA.isEmpty()) {
            this.handleField(this.negativeResourceCache, this.interfacesToClearA);
        }
        if (this.invalidClasses != null && !this.interfacesToClearB.isEmpty()) {
            this.handleField(this.invalidClasses, this.interfacesToClearB);
        }
    }

    private void handleField(Field field, List<String> toClear) {
        block3: {
            try {
                Set set = (Set)field.get(this.cl);
                Iterator<String> it = toClear.iterator();
                while (it.hasNext()) {
                    String content = it.next();
                    if (!set.contains(content)) continue;
                    set.remove(content);
                    it.remove();
                }
            }
            catch (Exception e) {
                if (!LPConstants.DEBUG) break block3;
                e.printStackTrace();
            }
        }
    }
}

