/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.hud;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.interfaces.IHUDButton;
import logisticspipes.interfaces.IHUDConfig;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public abstract class BasicHUDGui
implements IHeadUpDisplayRenderer {
    protected final List<IHUDButton> buttons = new ArrayList<IHUDButton>();

    protected void addButton(IHUDButton button) {
        this.buttons.add(button);
    }

    @Override
    public void renderHeadUpDisplay(double d, boolean day, boolean shifted, Minecraft mc, IHUDConfig config) {
        for (IHUDButton button : this.buttons) {
            GL11.glPushMatrix();
            button.renderAlways(shifted);
            if (button.shouldRenderButton()) {
                button.renderButton(button.isFocused(), button.isblockFocused(), shifted);
            }
            GL11.glPopMatrix();
        }
    }

    @Override
    public void handleCursor(int x, int y) {
        GL11.glPushMatrix();
        for (IHUDButton button : this.buttons) {
            if (!button.buttonEnabled() || !button.shouldRenderButton()) continue;
            if (button.getX() - 1 < x && x < button.getX() + button.sizeX() + 1 && button.getY() - 1 < y && y < button.getY() + button.sizeY() + 1) {
                if (!button.isFocused() && !button.isblockFocused()) {
                    button.setFocused();
                    continue;
                }
                if (button.focusedTime() <= 400 || button.isblockFocused()) continue;
                button.clicked();
                button.blockFocused();
                continue;
            }
            if (!button.isFocused() && !button.isblockFocused()) continue;
            button.clearFocused();
        }
        GL11.glPopMatrix();
    }
}

