/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class ModuleApiaristRefiller
extends LogisticsModule {
    private int currentTickCount = 0;
    private final int ticksToOperation = 200;

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        return null;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public final int getX() {
        return this._service.getX();
    }

    @Override
    public final int getY() {
        return this._service.getY();
    }

    @Override
    public final int getZ() {
        return this._service.getZ();
    }

    @Override
    public void tick() {
        if (++this.currentTickCount < 200) {
            return;
        }
        this.currentTickCount = 0;
        IInventory inv = this._service.getRealInventory();
        if (!(inv instanceof ISidedInventory)) {
            return;
        }
        ISidedInventory sinv = (ISidedInventory)inv;
        ForgeDirection direction = this._service.inventoryOrientation().getOpposite();
        ItemStack stack = this.extractItem(sinv, false, direction, 1);
        if (stack == null) {
            return;
        }
        if (!this._service.canUseEnergy(100)) {
            return;
        }
        this.currentTickCount = 200;
        if (this.reinsertBee(stack, sinv, direction)) {
            return;
        }
        Pair<Integer, SinkReply> reply = this._service.hasDestination(ItemIdentifier.get(stack), true, new ArrayList<Integer>());
        if (reply == null) {
            return;
        }
        this._service.useEnergy(20);
        this.extractItem(sinv, true, direction, 1);
        this._service.sendStack(stack, reply, CoreRoutedPipe.ItemSendMode.Normal);
    }

    private ItemStack extractItem(ISidedInventory inv, boolean remove, ForgeDirection dir, int amount) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null || !inv.func_102008_b(i, inv.func_70301_a(i), dir.ordinal())) continue;
            if (remove) {
                return inv.func_70298_a(i, amount);
            }
            ItemStack extracted = inv.func_70301_a(i).func_77946_l();
            extracted.field_77994_a = amount;
            return extracted;
        }
        return null;
    }

    private int addItem(ISidedInventory inv, ItemStack stack, ForgeDirection dir) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) != null || !inv.func_102007_a(i, stack, dir.ordinal())) continue;
            inv.func_70299_a(i, stack);
            return stack.field_77994_a;
        }
        return 0;
    }

    private boolean reinsertBee(ItemStack stack, ISidedInventory inv, ForgeDirection direction) {
        if (inv.func_70301_a(0) == null && SimpleServiceLocator.forestryProxy.isPrincess(stack) && SimpleServiceLocator.forestryProxy.isPurebred(stack)) {
            int inserted = this.addItem(inv, stack, direction);
            if (inserted == 0) {
                return false;
            }
            this._service.useEnergy(100);
            this.extractItem(inv, true, direction, 1);
            this._service.spawnParticle(Particles.VioletParticle, 5);
            this._service.spawnParticle(Particles.BlueParticle, 5);
            return true;
        }
        if (inv.func_70301_a(1) == null && !SimpleServiceLocator.forestryProxy.isQueen(inv.func_70301_a(0)) && SimpleServiceLocator.forestryProxy.isDrone(stack) && SimpleServiceLocator.forestryProxy.isPurebred(stack)) {
            int inserted = this.addItem(inv, stack, direction);
            if (inserted == 0) {
                return false;
            }
            this._service.useEnergy(100);
            this.extractItem(inv, true, direction, 1);
            this._service.spawnParticle(Particles.VioletParticle, 5);
            this._service.spawnParticle(Particles.BlueParticle, 5);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    public List<ItemIdentifier> getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTexture(IIconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleApiaristRefiller");
    }
}

