/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.buildcraft;

import buildcraft.core.lib.TileBuffer;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.PipeItemsDiamond;
import buildcraft.transport.pipes.PipeItemsIron;
import buildcraft.transport.pipes.PipeItemsObsidian;
import buildcraft.transport.pipes.PipeStructureCobblestone;
import java.util.List;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.buildcraft.LPRoutedBCTravelingItem;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BCPipeInformationProvider
implements IPipeInformationProvider {
    private final TileGenericPipe pipe;

    public BCPipeInformationProvider(TileGenericPipe pipe) {
        this.pipe = pipe;
    }

    @Override
    public boolean isCorrect() {
        return this.pipe != null && this.pipe.pipe != null && SimpleServiceLocator.buildCraftProxy.isActive();
    }

    @Override
    public int getX() {
        return this.pipe.field_145851_c;
    }

    @Override
    public int getY() {
        return this.pipe.field_145848_d;
    }

    @Override
    public int getZ() {
        return this.pipe.field_145849_e;
    }

    @Override
    public World getWorld() {
        return this.pipe.getWorld();
    }

    @Override
    public boolean isRouterInitialized() {
        return this.pipe.initialized;
    }

    @Override
    public boolean isRoutingPipe() {
        return false;
    }

    @Override
    public CoreRoutedPipe getRoutingPipe() {
        throw new RuntimeException("This is no routing pipe");
    }

    @Override
    public TileEntity getTile(ForgeDirection direction) {
        return this.pipe.getTile(direction);
    }

    @Override
    public boolean isFirewallPipe() {
        return false;
    }

    @Override
    public IFilter getFirewallFilter() {
        throw new RuntimeException("This is not a firewall pipe");
    }

    @Override
    public TileEntity getTile() {
        return this.pipe;
    }

    @Override
    public boolean divideNetwork() {
        if (this.pipe.pipe instanceof PipeItemsObsidian) {
            return true;
        }
        return this.pipe.pipe instanceof PipeStructureCobblestone;
    }

    @Override
    public boolean powerOnly() {
        return this.pipe.pipe instanceof PipeItemsDiamond;
    }

    @Override
    public boolean isOnewayPipe() {
        return this.pipe.pipe instanceof PipeItemsIron;
    }

    @Override
    public boolean isOutputOpen(ForgeDirection direction) {
        return this.pipe.pipe.outputOpen(direction);
    }

    @Override
    public boolean canConnect(TileEntity to, ForgeDirection direction, boolean flag) {
        return SimpleServiceLocator.buildCraftProxy.canPipeConnect((TileEntity)this.pipe, to, direction);
    }

    @Override
    public double getDistance() {
        return 1.0;
    }

    @Override
    public boolean isItemPipe() {
        return this.pipe != null && this.pipe.pipe != null && this.pipe.pipe.transport instanceof PipeTransportItems && SimpleServiceLocator.buildCraftProxy.isActive();
    }

    @Override
    public boolean isFluidPipe() {
        return this.pipe != null && this.pipe.pipe != null && this.pipe.pipe.transport instanceof PipeTransportFluids && SimpleServiceLocator.buildCraftProxy.isActive();
    }

    @Override
    public boolean isPowerPipe() {
        return this.pipe != null && this.pipe.pipe != null && this.pipe.pipe.transport instanceof PipeTransportPower && SimpleServiceLocator.buildCraftProxy.isActive();
    }

    @Override
    public double getDistanceTo(int destinationint, ForgeDirection ignore, ItemIdentifier ident, boolean isActive, double traveled, double max, List<LPPosition> visited) {
        if (traveled >= max) {
            return 2.147483647E9;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            LPPosition pos;
            IPipeInformationProvider information;
            if (ignore == dir || (information = SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(this.getTile(dir))) == null || visited.contains(pos = new LPPosition(information))) continue;
            visited.add(pos);
            double result = information.getDistanceTo(destinationint, dir.getOpposite(), ident, isActive, traveled + this.getDistance(), max, visited);
            visited.remove(pos);
            if (result == 2.147483647E9) {
                return result;
            }
            return result + (double)((int)this.getDistance());
        }
        return 2.147483647E9;
    }

    @Override
    public boolean acceptItem(LPTravelingItem item, TileEntity from) {
        if (BlockGenericPipe.isValid((Pipe)this.pipe.pipe) && this.pipe.pipe.transport instanceof PipeTransportItems) {
            LPRoutedBCTravelingItem bcItem = null;
            if (!(item instanceof LPTravelingItem.LPTravelingItemServer)) {
                return true;
            }
            LPRoutedBCTravelingItem lpBCItem = new LPRoutedBCTravelingItem();
            lpBCItem.setRoutingInformation(((LPTravelingItem.LPTravelingItemServer)item).getInfo());
            lpBCItem.saveToExtraNBTData();
            bcItem = lpBCItem;
            LPPosition p = new LPPosition((float)this.pipe.field_145851_c + 0.5f, (float)this.pipe.field_145848_d + 0.25f, (float)this.pipe.field_145849_e + 0.5f);
            if (item.output.getOpposite() == ForgeDirection.DOWN) {
                p.moveForward(item.output.getOpposite(), 0.24f);
            } else if (item.output.getOpposite() == ForgeDirection.UP) {
                p.moveForward(item.output.getOpposite(), 0.74f);
            } else {
                p.moveForward(item.output.getOpposite(), 0.49f);
            }
            bcItem.setPosition(p.getXD(), p.getYD(), p.getZD());
            bcItem.setSpeed(item.getSpeed());
            if (item.getItemIdentifierStack() != null) {
                bcItem.setItemStack(item.getItemIdentifierStack().makeNormalStack());
            }
            ((PipeTransportItems)this.pipe.pipe.transport).injectItem((TravelingItem)bcItem, item.output);
            return true;
        }
        return false;
    }

    @Override
    public void refreshTileCacheOnSide(ForgeDirection side) {
        TileBuffer[] cache = this.pipe.getTileCache();
        if (cache != null) {
            cache[side.ordinal()].refresh();
        }
    }
}

