/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.recipes;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import logisticspipes.blocks.crafting.AutoCraftingInventory;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.CraftingPermissionPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.recipes.CraftingDependency;
import logisticspipes.utils.PlayerIdentifier;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class CraftingPermissionManager {
    private final Map<PlayerIdentifier, Pair<Long, EnumSet<CraftingDependency>>> serverCache = new HashMap<PlayerIdentifier, Pair<Long, EnumSet<CraftingDependency>>>();
    private int tick = 0;
    public EnumSet<CraftingDependency> clientSidePermission = EnumSet.noneOf(CraftingDependency.class);

    public CraftingPermissionManager() {
        this.clientSidePermission.add(CraftingDependency.Basic);
    }

    public PlayerIdentifier getPlayerID(InventoryCrafting inv) {
        if (inv.field_70465_c instanceof ContainerPlayer) {
            return PlayerIdentifier.get(((ContainerPlayer)inv.field_70465_c).field_82862_h);
        }
        if (inv instanceof AutoCraftingInventory) {
            return ((AutoCraftingInventory)inv).placedByPlayer;
        }
        return null;
    }

    public boolean isAllowedFor(CraftingDependency dependent, PlayerIdentifier player) {
        if (MainProxy.isClient()) {
            return this.clientSidePermission.contains((Object)dependent);
        }
        EnumSet<CraftingDependency> set = this.getEnumSet(player);
        return set.contains((Object)dependent);
    }

    public void tick() {
        if (this.tick++ % 100 != 0) {
            return;
        }
        this.tick = 1;
        for (PlayerIdentifier player : this.serverCache.keySet()) {
            if (this.serverCache.get(player).getValue1() + 30000L >= System.currentTimeMillis()) continue;
            this.serverCache.remove(player);
            this.tick = 0;
            return;
        }
    }

    public EnumSet<CraftingDependency> getEnumSet(PlayerIdentifier player) {
        if (!this.serverCache.containsKey(player)) {
            this.load(player);
        }
        this.serverCache.get(player).setValue1(System.currentTimeMillis());
        return this.serverCache.get(player).getValue2();
    }

    public void load(PlayerIdentifier player) {
        try {
            File lpFolder = MainProxy.getLPFolder();
            File playerFile = new File(lpFolder, player.getAsString() + "_craft.dat");
            DataInputStream din = new DataInputStream(new FileInputStream(playerFile));
            NBTTagCompound nbt = CompressedStreamTools.func_74794_a((DataInputStream)din);
            din.close();
            EnumSet<CraftingDependency> enumSet = EnumSet.noneOf(CraftingDependency.class);
            for (CraftingDependency type : CraftingDependency.values()) {
                if (!nbt.func_74767_n(type.name())) continue;
                enumSet.add(type);
            }
            this.serverCache.put(player, new Pair<Long, EnumSet<CraftingDependency>>(System.currentTimeMillis(), enumSet));
        }
        catch (Exception e) {
            this.serverCache.put(player, new Pair<Long, EnumSet<CraftingDependency>>(System.currentTimeMillis(), EnumSet.of(CraftingDependency.Basic)));
        }
    }

    public void modify(PlayerIdentifier player, EnumSet<CraftingDependency> enumSet) {
        this.serverCache.get(player).setValue1(System.currentTimeMillis());
        this.serverCache.get(player).setValue2(enumSet);
        try {
            File lpFolder = MainProxy.getLPFolder();
            File playerFile = new File(lpFolder, player.getAsString() + "_craft.dat");
            DataOutputStream din = new DataOutputStream(new FileOutputStream(playerFile));
            NBTTagCompound nbt = new NBTTagCompound();
            for (CraftingDependency type : CraftingDependency.values()) {
                nbt.func_74757_a(type.name(), enumSet.contains((Object)type));
            }
            CompressedStreamTools.func_74800_a((NBTTagCompound)nbt, (DataOutput)din);
            din.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendCraftingPermissionsToPlayer(EntityPlayer player) {
        EnumSet<CraftingDependency> set = this.getEnumSet(PlayerIdentifier.get(player));
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(CraftingPermissionPacket.class).setEnumSet(set), player);
    }
}

