/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.request.ICraftingTemplate;
import logisticspipes.request.IReqCraftingTemplate;
import logisticspipes.request.resources.IResource;
import logisticspipes.utils.tuples.Pair;

public abstract class BaseCraftingTemplate
implements IReqCraftingTemplate {
    private final ArrayList<Pair<IResource, IAdditionalTargetInformation>> ingredients;
    private final int priority;

    public BaseCraftingTemplate(int ingredientDefaultCount, int priority) {
        this.ingredients = new ArrayList(ingredientDefaultCount);
        this.priority = priority;
    }

    @Override
    public void addIngredient(IResource requirement, IAdditionalTargetInformation info) {
        this.ingredients.add(new Pair<IResource, IAdditionalTargetInformation>(requirement, info));
    }

    @Override
    public List<Pair<IResource, IAdditionalTargetInformation>> getComponents(int nCraftingSetsNeeded) {
        ArrayList<Pair<IResource, IAdditionalTargetInformation>> stacks = new ArrayList<Pair<IResource, IAdditionalTargetInformation>>(this.ingredients.size());
        for (Pair<IResource, IAdditionalTargetInformation> stack : this.ingredients) {
            Pair<IResource, IAdditionalTargetInformation> pair = new Pair<IResource, IAdditionalTargetInformation>(stack.getValue1().clone(nCraftingSetsNeeded), stack.getValue2());
            stacks.add(pair);
        }
        return stacks;
    }

    @Override
    public int compareTo(ICraftingTemplate o) {
        int c = Integer.compare(this.getPriority(), o.getPriority());
        if (c != 0) {
            return c;
        }
        c = this.getResultStack().compareTo(o.getResultStack());
        if (c != 0) {
            return c;
        }
        c = this.getCrafter().compareTo(o.getCrafter());
        return c;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

