/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.item;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraftforge.oredict.OreDictionary;

public class DictIdentifier {
    private static List<DictIdentifier> identifiers = new ArrayList<DictIdentifier>();
    private final int id;
    private String name;
    private String category;

    static DictIdentifier getForId(int id) {
        DictIdentifier ident;
        if (identifiers.size() <= id) {
            ArrayList<DictIdentifier> newidentifiers = new ArrayList<DictIdentifier>(id + 1);
            while (newidentifiers.size() <= id) {
                newidentifiers.add(null);
            }
            for (int i = 0; i < identifiers.size(); ++i) {
                newidentifiers.set(i, identifiers.get(i));
            }
            identifiers = newidentifiers;
        }
        if ((ident = identifiers.get(id)) == null) {
            ident = new DictIdentifier(id);
            identifiers.set(id, ident);
        }
        return ident;
    }

    private DictIdentifier(int id) {
        this.id = id;
    }

    public String getName() {
        if (this.name == null) {
            this.name = OreDictionary.getOreName((int)this.id);
        }
        return this.name;
    }

    public String getCategory() {
        if (this.category == null) {
            this.category = Pattern.compile("[A-Z].*").matcher(this.getName()).replaceFirst("");
        }
        return this.category;
    }

    public boolean canNameMatch(DictIdentifier ident) {
        return this.getName().equals(ident.getName());
    }

    public boolean canCategoryMatch(DictIdentifier ident) {
        return this.getCategory().equals(ident.getCategory());
    }

    public void debugDumpData(boolean isClient, StringBuilder builder) {
        builder.append(this.id);
        builder.append("{");
        builder.append(this.getName());
        builder.append("}");
    }
}

