/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.config;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.kuba6000.mobsinfo.api.MobDrop;
import com.kuba6000.mobsinfo.api.MobDropSimplified;
import com.kuba6000.mobsinfo.api.MobOverride;
import com.kuba6000.mobsinfo.api.event.PostMobsOverridesLoadEvent;
import com.kuba6000.mobsinfo.api.utils.GSONUtils;
import com.kuba6000.mobsinfo.config.Config;
import cpw.mods.fml.common.eventhandler.Event;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OverridesConfig {
    private static final Logger LOG = LogManager.getLogger((String)"mobsinfo[Config-Overrides]");
    public static Map<String, MobOverride> overrides = new HashMap<String, MobOverride>();
    private static File overrideFile = null;
    private static final Gson gson = GSONUtils.GSON_BUILDER_PRETTY.create();

    public static void LoadConfig() {
        LOG.info("Loading Config");
        if (overrideFile == null) {
            overrideFile = Config.getConfigFile("MobOverrides.json");
        }
        if (!overrideFile.exists()) {
            OverridesConfig.writeExampleFile();
        }
        BufferedReader reader = null;
        try {
            reader = Files.newReader((File)overrideFile, (Charset)StandardCharsets.UTF_8);
            overrides = (Map)gson.fromJson((Reader)reader, new TypeToken<Map<String, MobOverride>>(){}.getType());
            overrides.remove("ExampleMob");
            overrides.values().forEach(o -> o.additions.forEach(MobDrop::reconstructStack));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (Exception exception) {}
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PostMobsOverridesLoadEvent(overrides));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeExampleFile() {
        LOG.info("No config has been detected, writing an example one");
        BufferedWriter writer = null;
        try {
            writer = Files.newWriter((File)overrideFile, (Charset)StandardCharsets.UTF_8);
            HashMap<String, MobOverride> example = new HashMap<String, MobOverride>(1);
            MobOverride ex1 = new MobOverride();
            ex1.removals.add(new MobDropSimplified(new ItemStack(Items.field_151078_bh, 1), MobDrop.DropType.Normal));
            HashMap<Integer, Integer> exdamages = new HashMap<Integer, Integer>(3);
            exdamages.put(1, 1);
            exdamages.put(2, 5);
            exdamages.put(3, 10);
            ex1.additions.add(new MobDrop(new ItemStack(Items.field_151048_u), MobDrop.DropType.Rare, 500, 20, exdamages, true, false));
            example.put("ExampleMob", ex1);
            gson.toJson(example, (Appendable)writer);
            ((Writer)writer).flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

