/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.screen;

import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.Cursor;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.IDraggable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import java.awt.Rectangle;
import org.jetbrains.annotations.Nullable;

public class DraggableWindowWrapper
implements IDraggable {
    private final ModularWindow window;
    private final Pos2d relativeClickPos;
    private boolean moving;
    private final Rectangle area = new Rectangle();

    public DraggableWindowWrapper(ModularWindow window, Pos2d relativeClickPos) {
        this.window = window;
        this.relativeClickPos = relativeClickPos;
        this.area.setSize(window.getSize().width, window.getSize().height);
    }

    @Override
    public void renderMovingState(float delta) {
        Cursor cursor = this.window.getContext().getCursor();
        GlStateManager.pushMatrix();
        GlStateManager.translate(-this.window.getPos().x, -this.window.getPos().y, 0.0f);
        GlStateManager.translate(cursor.getX() - this.relativeClickPos.x, cursor.getY() - this.relativeClickPos.y, 0.0f);
        this.window.drawWidgets(delta, false);
        GlStateManager.popMatrix();
    }

    @Override
    public boolean onDragStart(int button) {
        return button == 0;
    }

    @Override
    public void onDragEnd(boolean successful) {
        if (successful) {
            this.window.setPos(this.window.getContext().getCursor().getPos().subtract(this.relativeClickPos));
            this.window.markNeedsRebuild();
        }
    }

    @Override
    public void onDrag(int mouseButton, long timeSinceLastClick) {
    }

    @Override
    public boolean canDropHere(@Nullable Widget widget, boolean isInBounds) {
        return true;
    }

    @Override
    @Nullable
    public Rectangle getArea() {
        Pos2d cursor = this.window.getContext().getCursor().getPos();
        this.area.setLocation(cursor.x - this.relativeClickPos.x, cursor.y - this.relativeClickPos.y);
        return this.area;
    }

    @Override
    public boolean isMoving() {
        return this.moving;
    }

    @Override
    public void setMoving(boolean moving) {
        this.moving = moving;
        this.window.setEnabled(!moving);
    }

    public ModularWindow getWindow() {
        return this.window;
    }
}

