/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.navigator.api.model.buttons;

import com.gtnewhorizons.navigator.api.NavigatorApi;
import com.gtnewhorizons.navigator.api.model.SupportedMods;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import net.minecraft.util.ResourceLocation;

public abstract class ButtonManager {
    protected boolean isActive = false;
    protected BooleanConsumer onToggle;
    private BooleanConsumer notifyLayerToggled;

    public abstract ResourceLocation getIcon(SupportedMods var1, String var2);

    public abstract String getButtonText();

    public final void setOnToggle(BooleanConsumer onToggle) {
        this.onToggle = onToggle;
    }

    public final void setLayerNotify(BooleanConsumer layerToggled) {
        this.notifyLayerToggled = layerToggled;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void activate() {
        NavigatorApi.getDistinctButtons(this).forEach(ButtonManager::deactivate);
        this.isActive = true;
        if (this.onToggle != null) {
            this.onToggle.accept(true);
        }
        if (this.notifyLayerToggled != null) {
            this.notifyLayerToggled.accept(true);
        }
    }

    public void deactivate() {
        this.isActive = false;
        if (this.onToggle != null) {
            this.onToggle.accept(false);
        }
        if (this.notifyLayerToggled != null) {
            this.notifyLayerToggled.accept(false);
        }
    }

    public void toggle() {
        if (this.isActive) {
            this.deactivate();
        } else {
            this.activate();
        }
    }
}

