/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.utility;

import ca.wescook.nutrition.nutrients.JsonNutrient;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.utility.Config;
import ca.wescook.nutrition.utility.Log;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.math.NumberUtils;
import squeek.applecore.api.AppleCoreAPI;

public class DataParser {
    public static List<Nutrient> parseNutrients(List<JsonNutrient> jsonNutrients) {
        ArrayList<Nutrient> nutrients = new ArrayList<Nutrient>();
        for (JsonNutrient nutrientRaw : jsonNutrients) {
            if (nutrientRaw.enabled != null && !nutrientRaw.enabled.booleanValue()) continue;
            Nutrient nutrient = new Nutrient();
            try {
                nutrient.name = nutrientRaw.name;
                nutrient.icon = DataParser.getItemByName(nutrientRaw.name, nutrientRaw.icon).getItemStack();
                nutrient.color = Integer.parseUnsignedInt("ff" + nutrientRaw.color, 16);
            }
            catch (NullPointerException e) {
                Log.fatal("Missing or invalid JSON.  A name, icon, and color are required.");
                throw e;
            }
            if (nutrientRaw.decay == null) {
                nutrient.decay = Config.decayMultiplier;
            } else if (nutrientRaw.decay.floatValue() >= -100.0f && nutrientRaw.decay.floatValue() <= 100.0f) {
                nutrient.decay = nutrientRaw.decay.floatValue();
            } else {
                nutrient.decay = 0.0f;
                Log.error("Decay rate must be between -100 and 100 (" + nutrient.name + ").");
                continue;
            }
            boolean bl = nutrient.visible = nutrientRaw.visible == null || nutrientRaw.visible != false;
            if (nutrientRaw.food.oredict != null) {
                nutrient.foodOreDict = nutrientRaw.food.oredict;
            }
            if (nutrientRaw.food.items != null) {
                for (String fullName : nutrientRaw.food.items) {
                    ItemData data = DataParser.getItemByName(nutrient.name, fullName, true);
                    if (data == null) continue;
                    Item item = data.getItem();
                    if (item == null) {
                        if (!Config.logMissingFood || !Loader.isModLoaded((String)data.modid)) continue;
                        Log.warn("Food with nutrients doesn't exist: " + fullName + " (" + nutrient.name + ")");
                        continue;
                    }
                    ItemStack itemStack = new ItemStack(item, 1, data.metadata);
                    if (AppleCoreAPI.accessor.isFood(itemStack)) {
                        nutrient.foodItems.add(itemStack);
                        continue;
                    }
                    Log.warn(data.name + " is not a valid food (" + fullName + ")");
                }
            }
            nutrients.add(nutrient);
        }
        return nutrients;
    }

    private static ItemData getItemByName(String nutrientName, String fullName, boolean throwException) {
        int metadata = 0;
        if (fullName == null) {
            Log.fatal("There is a null item in the '" + nutrientName + "' JSON.  Check for a trailing comma in the file.");
            if (throwException) {
                throw new NullPointerException("There is a null item in the '" + nutrientName + "' JSON.  Check for a trailing comma in the file.");
            }
            return null;
        }
        String[] splitName = fullName.split(":");
        if (splitName.length <= 1) {
            Log.fatal("There is an item missing a modid in the '" + nutrientName + "' JSON. Ensure names are formatted like 'minecraft:golden_apple'");
            if (throwException) {
                throw new NullPointerException("There is an item missing a modid in the '" + nutrientName + "' JSON. Ensure names are formatted like 'minecraft:golden_apple'");
            }
            return null;
        }
        String modid = splitName[0];
        String name = splitName[1];
        if (splitName.length > 2) {
            if (NumberUtils.isNumber((String)splitName[2])) {
                metadata = Integer.decode(splitName[2]);
            } else {
                Log.warn(fullName + " does not contain valid metadata");
                return null;
            }
        }
        return new ItemData(modid, name, metadata);
    }

    private static ItemData getItemByName(String nutrientName, String fullName) {
        return DataParser.getItemByName(nutrientName, fullName, false);
    }

    private static class ItemData {
        private final String modid;
        private final String name;
        private final int metadata;

        private ItemData(String modid, String name, int metadata) {
            this.modid = modid;
            this.name = name;
            this.metadata = metadata;
        }

        public Item getItem() {
            return GameRegistry.findItem((String)this.modid, (String)this.name);
        }

        public ItemStack getItemStack() {
            return new ItemStack(this.getItem(), 1, this.metadata);
        }
    }
}

