/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;

public class Config {
    public List<String> alarmsConfigList = new ArrayList<String>();
    public final boolean enableplaySoundAt;
    public final boolean enableMUD;
    public final int rfidMaxRange;
    public final boolean ignoreUUIDs;
    public final boolean turretReverseRotation;
    public boolean registerBlockBreak;
    public boolean magCardDisplayName;
    public boolean biggerEEPROM;
    public boolean returnRealUUID;

    public Config(Configuration config) {
        config.load();
        this.enableMUD = config.get("options", "enableMUD", true, "Enable the Update Checker? Disabling this will remove all traces of the MUD.").getBoolean(true);
        this.rfidMaxRange = config.getInt("rfidMaxRange", "options", 16, 1, 64, "The maximum range of the RFID Reader in blocks");
        this.enableplaySoundAt = config.get("options", "playSoundAt", false, "Enable/Disable the playSoundAt feature of alarm blocks, this allows any user to play any sound at any location in a world, and is exploitable, disabled by default.").getBoolean(false);
        this.ignoreUUIDs = config.getBoolean("ignoreUUIDs", "options", false, "RFID and Mag cards will return '-1' for UUIDs.  Allows for less secure security.");
        this.registerBlockBreak = config.getBoolean("registerBlockBreak", "options", true, "If false the block break event will not be registered, which will leave Door Controllers and Security Doors able to be broken.");
        this.turretReverseRotation = config.getBoolean("turretReverseRotation", "options", true, "If true - turrets should rotate as in old versions.");
        this.magCardDisplayName = config.getBoolean("magCardDisplayName", "options", true, "If true - the Mag Card Reader will return the Minecraft Username of the player who swiped the card, false will return \"player\"");
        this.biggerEEPROM = config.getBoolean("biggerEEPROMS", "options", false, "If enabled changes EEPROMS capacity to 8096 bytes (Only when flashed with the OS CardWriter!)");
        this.returnRealUUID = config.getBoolean("returnRealUUID", "options", false, "If enabled makes the BioMetric reader return the user's REAL UUID, and not the base64'd hash");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

