/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.tileentity;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Map;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import pcl.opensecurity.OpenSecurity;
import pcl.opensecurity.networking.PacketKeypadButton;
import pcl.opensecurity.tileentity.TileEntityMachineBase;

public class TileEntityKeypadLock
extends TileEntityMachineBase
implements Environment {
    static final int MAX_LABEL_LENGTH = 3;
    static final int MAX_DISPLAY_LENGTH = 8;
    private boolean shouldBeep = true;
    public String data;
    public String eventName = "keypad";
    public String[] buttonLabels = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "*", "0", "#"};
    public byte[] buttonColors = new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    public String displayText = "";
    public byte displayColor = (byte)7;
    protected ComponentConnector node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(TileEntityKeypadLock.getComponentName()).withConnector(32.0).create();
    public ButtonState[] buttonStates = new ButtonState[]{new ButtonState(), new ButtonState(), new ButtonState(), new ButtonState(), new ButtonState(), new ButtonState(), new ButtonState(), new ButtonState(), new ButtonState(), new ButtonState(), new ButtonState(), new ButtonState()};
    public static float[] facingToAngle = new float[]{0.0f, 0.0f, 0.0f, 180.0f, 90.0f, 270.0f};

    static String trimString(String str, int len) {
        if (str == null || str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    public Node node() {
        return this.node;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.node != null) {
            this.node.remove();
        }
    }

    private static String getComponentName() {
        return "os_keypad";
    }

    public void onConnect(Node arg0) {
    }

    public void onDisconnect(Node node) {
    }

    public void onMessage(Message arg0) {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.node != null && this.node.host() == this) {
            this.node.load(nbt.func_74775_l("oc:node"));
        }
        this.eventName = nbt.func_74764_b("eventName") && !nbt.func_74779_i("eventName").isEmpty() ? nbt.func_74779_i("eventName") : "keypad";
        this.shouldBeep = nbt.func_74764_b("shouldBeep") ? nbt.func_74767_n("shouldBeep") : true;
        for (int i = 0; i < 12; ++i) {
            this.buttonLabels[i] = TileEntityKeypadLock.trimString(nbt.func_74779_i("btn:" + i), 3);
        }
        byte[] colors = nbt.func_74770_j("btn:colors");
        if (colors != null) {
            for (int i = 0; i < 12 && i < colors.length; ++i) {
                this.buttonColors[i] = colors[i];
            }
        }
        this.displayText = TileEntityKeypadLock.trimString(nbt.func_74779_i("fbText"), 8);
        this.displayColor = nbt.func_74771_c("fbColor");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.node != null && this.node.host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node.save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
        nbt.func_74778_a("eventName", this.eventName);
        for (int i = 0; i < 12; ++i) {
            nbt.func_74778_a("btn:" + i, this.buttonLabels[i]);
        }
        nbt.func_74773_a("btn:colors", this.buttonColors);
        nbt.func_74778_a("fbText", this.displayText);
        nbt.func_74768_a("fbColor", (int)this.displayColor);
        nbt.func_74757_a("shouldBeep", this.shouldBeep);
    }

    @Callback(doc="function(String:name):boolean; Sets the name of the event that gets sent when a key is pressed")
    public Object[] setEventName(Context context, Arguments args) throws Exception {
        this.eventName = args.checkString(0);
        return new Object[]{true};
    }

    @Callback(doc="function(Boolean):boolean; Sets if the keys should beep when pressed")
    public Object[] setShouldBeep(Context context, Arguments args) throws Exception {
        this.shouldBeep = args.checkBoolean(0);
        return new Object[]{true};
    }

    @Callback(doc="function(String:text[, color:number]):boolean; Sets the display string (0-8 chars), color (0-7) - 1 bit per channel")
    public Object[] setDisplay(Context context, Arguments args) throws Exception {
        String text = args.checkString(0);
        this.displayColor = (byte)(args.optInteger(1, (int)this.displayColor) & 7);
        this.displayText = TileEntityKeypadLock.trimString(text, 8);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
        return new Object[]{true};
    }

    @Callback(doc="function(idx:number, text:string, color:number):boolean; Sets the key text (1-2 chars)")
    public Object[] setKey(Context context, Arguments args) throws Exception {
        if (args.count() == 0) {
            throw new IllegalArgumentException("Not enough arguments");
        }
        if (args.isInteger(0)) {
            int idx = args.checkInteger(0);
            if (idx < 1 || idx > 12) {
                throw new IllegalArgumentException("Index " + idx + " is out of range");
            }
            this.buttonLabels[idx - 1] = TileEntityKeypadLock.trimString(args.checkString(1), 3);
            this.buttonColors[idx - 1] = (byte)(args.optInteger(2, (int)this.buttonColors[idx - 1]) & 7);
        } else if (args.isTable(0)) {
            Map labels = args.checkTable(0);
            Map colors = args.optTable(1, null);
            for (int i = 0; i < 12; ++i) {
                Integer id = i + 1;
                Object val = labels.get(id);
                if (val != null && val instanceof String) {
                    this.buttonLabels[i] = TileEntityKeypadLock.trimString((String)val, 3);
                }
                if (colors == null || (val = colors.get(id)) == null || !(val instanceof Number)) continue;
                Number color = (Number)val;
                this.buttonColors[i] = (byte)(color.intValue() & 7);
            }
        } else {
            throw new IllegalArgumentException("First argument must be index or table");
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
        return new Object[]{true};
    }

    public static String getBaseInstanceFileName() {
        return "keypad";
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.node != null && this.node.network() == null) {
            Network.joinOrCreateNetwork((TileEntity)this);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public int getFacing() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void pressedButton(EntityPlayer player, int buttonIndex) {
        if (this.shouldBeep) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "opensecurity:keypad_press", 0.4f, 1.0f);
        }
        if (!this.field_145850_b.field_72995_K) {
            PacketKeypadButton packet = new PacketKeypadButton(1, this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, buttonIndex);
            EntityPlayerMP p = (EntityPlayerMP)player;
            OpenSecurity.network.sendToAllAround((IMessage)packet, new NetworkRegistry.TargetPoint(p.field_71093_bK, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0));
            this.node.sendToReachable("computer.signal", new Object[]{this.eventName, buttonIndex + 1, buttonIndex >= 0 && buttonIndex < this.buttonLabels.length ? this.buttonLabels[buttonIndex] : ""});
        }
    }

    public float getAngle() {
        return facingToAngle[this.getFacing()];
    }

    public static class ButtonState {
        public static int pressDelay = 5;
        public long pressedTime = 0L;

        public boolean isPressed(long time) {
            return time - this.pressedTime < (long)pressDelay;
        }

        public void press(long time) {
            this.pressedTime = time;
        }
    }
}

