/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands;

import dev.rndmorris.salisarcana.SalisArcana;
import dev.rndmorris.salisarcana.common.commands.ArcanaCommandBase;
import dev.rndmorris.salisarcana.common.commands.arguments.ArgumentProcessor;
import dev.rndmorris.salisarcana.common.commands.arguments.annotations.PositionalArg;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.IArgumentHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.positional.CommandNameHandler;
import dev.rndmorris.salisarcana.config.SalisConfig;
import dev.rndmorris.salisarcana.config.settings.CommandSettings;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class HelpCommand
extends ArcanaCommandBase<Arguments> {
    public HelpCommand() {
        super(SalisConfig.commands.help);
    }

    @Override
    protected void process(ICommandSender sender, Arguments arguments, String[] args) {
        ArcanaCommandBase<?> command;
        if (arguments.forCommand == null) {
            arguments.forCommand = this.settings;
        }
        if ((command = arguments.forCommand.getCommand()) == null) {
            SalisArcana.LOG.error("HelpCommand argument \"forCommand\" was not null, but a command was not found. How?!?");
            return;
        }
        command.printHelp(sender);
    }

    @Override
    @Nonnull
    protected ArgumentProcessor<Arguments> initializeProcessor() {
        return new ArgumentProcessor<Arguments>(Arguments.class, Arguments::new, new IArgumentHandler[]{CommandNameHandler.INSTANCE});
    }

    @Override
    protected int minimumRequiredArgs() {
        return 0;
    }

    @Override
    public void printHelp(ICommandSender sender) {
        super.printHelp(sender);
        this.printAvailableCommands(sender);
    }

    private void printAvailableCommands(ICommandSender sender) {
        ChatComponentText listMessage = new ChatComponentText("");
        boolean any = false;
        Iterator settings$ = SalisConfig.commands.getCommandsSettings().iterator();
        while (settings$.hasNext()) {
            CommandSettings setting = (CommandSettings)settings$.next();
            if (!setting.isEnabled() || !sender.func_70003_b(setting.getPermissionLevel(), this.settings.getFullName())) continue;
            any = true;
            listMessage.func_150258_a(setting.getFullName());
            if (!settings$.hasNext()) continue;
            listMessage.func_150258_a(", ");
        }
        if (any) {
            sender.func_145747_a(new ChatComponentTranslation("salisarcana:command.help.available", new Object[0]).func_150255_a(this.titleStyle()));
            sender.func_145747_a((IChatComponent)listMessage);
            return;
        }
        sender.func_145747_a((IChatComponent)new ChatComponentTranslation("salisarcana:command.help.nocommands", new Object[0]));
    }

    public static class Arguments {
        @PositionalArg(index=0, handler=CommandNameHandler.class, descLangKey="cmd")
        public CommandSettings forCommand;
    }
}

