/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib;

import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.net.RegistryOrderSyncMessage;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.Spliterator;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;

public class SortedRegistry<V>
implements Iterable<V> {
    static final ConcurrentHashMap<String, WeakReference<SortedRegistry<?>>> ALL_REGISTRIES = new ConcurrentHashMap();
    private final NavigableMap<String, V> store = new TreeMap<String, V>();
    private List<V> baked = Collections.emptyList();
    private final Map<UUID, Pair<List<String>, List<String>>> playerOrdering = new HashMap<UUID, Pair<List<String>, List<String>>>();
    private final Map<UUID, List<V>> playerBaked = new HashMap<UUID, List<V>>();

    public SortedRegistry() {
    }

    public SortedRegistry(String name) {
        WeakReference<SortedRegistry> oldValue = ALL_REGISTRIES.put(name, new WeakReference<SortedRegistry>(this));
        if (oldValue != null && oldValue.get() != null) {
            throw new IllegalArgumentException("duplicate name");
        }
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public static Set<String> getRegistryNames() {
        return ALL_REGISTRIES.keySet();
    }

    public static SortedRegistry<?> getRegistry(String name) {
        WeakReference<SortedRegistry<?>> ref = ALL_REGISTRIES.get(name);
        return ref != null ? (SortedRegistry)ref.get() : null;
    }

    static void cleanup(MinecraftServer server) {
        List players = server.func_71203_ab().field_72404_b;
        Set onlinePlayerIDs = players.stream().map(Entity::func_110124_au).collect(Collectors.toSet());
        int removed = 0;
        for (WeakReference<SortedRegistry<?>> ref : ALL_REGISTRIES.values()) {
            SortedRegistry registry = (SortedRegistry)ref.get();
            if (registry == null) continue;
            Iterator<UUID> iterator = registry.playerOrdering.keySet().iterator();
            while (iterator.hasNext()) {
                UUID uuid = iterator.next();
                if (onlinePlayerIDs.contains(uuid)) continue;
                iterator.remove();
                registry.playerBaked.remove(uuid);
                ++removed;
            }
        }
        if (removed > 0) {
            StructureLib.LOGGER.debug("Removed {} registry record for logged out players", new Object[]{removed});
        }
    }

    @SubscribeEvent
    public void onPlayerLogOut(PlayerEvent.PlayerLoggedOutEvent e) {
        this.playerOrdering.remove(e.player.func_110124_au());
        this.playerBaked.remove(e.player.func_110124_au());
    }

    public void register(String key, V val) {
        if (key == null || val == null) {
            throw new NullPointerException();
        }
        V old = this.store.putIfAbsent(key, val);
        if (old != null) {
            throw new IllegalArgumentException("Duplicate key: " + key);
        }
        this.baked = new ArrayList(this.store.values());
        for (Map.Entry<UUID, Pair<List<String>, List<String>>> e : this.playerOrdering.entrySet()) {
            this.makePlayerBaked(e.getKey(), (List)e.getValue().getKey(), (List)e.getValue().getValue());
        }
    }

    public void registerOrdering(EntityPlayerMP player, List<String> ordering, List<String> disabled) {
        this.registerOrdering(player.func_110124_au(), ordering, disabled);
    }

    public void registerOrdering(UUID playerID, List<String> ordering, List<String> disabled) {
        this.playerOrdering.put(playerID, (Pair<List<String>, List<String>>)Pair.of(ordering, disabled));
        this.makePlayerBaked(playerID, ordering, disabled);
    }

    private void makePlayerBaked(UUID player, List<String> ordering, List<String> disabled) {
        TreeMap<String, V> copy = new TreeMap<String, V>(this.store);
        for (String s : disabled) {
            copy.remove(s);
        }
        ArrayList<V> b = new ArrayList<V>();
        for (String k : ordering) {
            V v = copy.remove(k);
            if (v == null) continue;
            b.add(v);
        }
        b.addAll(copy.values());
        this.playerBaked.put(player, b);
    }

    public int size() {
        return this.store.size();
    }

    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.store.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.store.containsValue(value);
    }

    public V get(String key) {
        return this.store.get(key);
    }

    public Iterable<V> getPlayerOrdering(@Nullable EntityPlayerMP player) {
        if (player == null) {
            return this.baked;
        }
        List<V> playerPreference = this.playerBaked.get(player.func_110124_au());
        if (playerPreference == null) {
            return this.baked;
        }
        return playerPreference;
    }

    public Stream<String> getPlayerOrderingKeys(@Nullable EntityPlayerMP player) {
        if (player == null) {
            return this.store.keySet().stream();
        }
        List<V> playerOrder = this.playerBaked.get(player.func_110124_au());
        if (playerOrder == null) {
            return this.store.keySet().stream();
        }
        IdentityHashMap reverseMap = new IdentityHashMap();
        this.store.forEach((? super K k, ? super V v) -> reverseMap.put(v, k));
        return playerOrder.stream().map(reverseMap::get);
    }

    Iterable<String> getCurrentOrdering() {
        return this.store.keySet();
    }

    @Override
    public Iterator<V> iterator() {
        return this.baked.iterator();
    }

    @Override
    public void forEach(Consumer<? super V> action) {
        this.baked.forEach(action);
    }

    @Override
    public Spliterator<V> spliterator() {
        return this.baked.spliterator();
    }

    static {
        RegistryOrderSyncMessage.Handler.setAllRegistries(ALL_REGISTRIES);
    }
}

