/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui.buttons;

import appeng.api.config.ViewItems;
import appeng.core.localization.ButtonToolTips;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;
import thaumicenergistics.client.gui.buttons.ThEStateButton;
import thaumicenergistics.client.textures.AEStateIconsEnum;

@SideOnly(value=Side.CLIENT)
public class GuiButtonViewType
extends ThEStateButton {
    private String tooltipViewType = "";

    public GuiButtonViewType(int ID, int xPosition, int yPosition, int width, int height) {
        super(ID, xPosition, yPosition, width, height, AEStateIconsEnum.VIEW_TYPE_ALL, 0, 0, AEStateIconsEnum.REGULAR_BUTTON);
        this.setViewMode(ViewItems.ALL);
    }

    @Override
    public void getTooltip(List<String> tooltip) {
        this.addAboutToTooltip(tooltip, ButtonToolTips.View.getLocal(), EnumChatFormatting.GRAY + this.tooltipViewType);
    }

    public void setViewMode(ViewItems mode) {
        switch (mode) {
            case ALL: {
                this.tooltipViewType = ButtonToolTips.StoredCraftable.getLocal();
                this.stateIcon = AEStateIconsEnum.VIEW_TYPE_ALL;
                break;
            }
            case CRAFTABLE: {
                this.tooltipViewType = ButtonToolTips.Craftable.getLocal();
                this.stateIcon = AEStateIconsEnum.VIEW_TYPE_CRAFT;
                break;
            }
            case STORED: {
                this.tooltipViewType = ButtonToolTips.StoredItems.getLocal();
                this.stateIcon = AEStateIconsEnum.VIEW_TYPE_STORED;
            }
        }
    }
}

