/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import thaumicenergistics.common.network.HandlerClient;
import thaumicenergistics.common.network.HandlerServer;
import thaumicenergistics.common.network.ThEBasePacket;
import thaumicenergistics.common.network.packet.client.Packet_C_ArcaneCraftingTerminal;
import thaumicenergistics.common.network.packet.client.Packet_C_AspectSlot;
import thaumicenergistics.common.network.packet.client.Packet_C_EssentiaCellTerminal;
import thaumicenergistics.common.network.packet.client.Packet_C_EssentiaEmitter;
import thaumicenergistics.common.network.packet.client.Packet_C_EssentiaIOBus;
import thaumicenergistics.common.network.packet.client.Packet_C_EssentiaStorageBus;
import thaumicenergistics.common.network.packet.client.Packet_C_EssentiaVibrationChamber;
import thaumicenergistics.common.network.packet.client.Packet_C_KnowledgeInscriber;
import thaumicenergistics.common.network.packet.client.Packet_C_Priority;
import thaumicenergistics.common.network.packet.client.Packet_C_Sync;
import thaumicenergistics.common.network.packet.client.Packet_R_ParticleFX;
import thaumicenergistics.common.network.packet.client.ThEAreaPacket;
import thaumicenergistics.common.network.packet.client.ThEClientPacket;
import thaumicenergistics.common.network.packet.client.WrapperPacket_C;
import thaumicenergistics.common.network.packet.server.Packet_S_ArcaneCraftingTerminal;
import thaumicenergistics.common.network.packet.server.Packet_S_AspectSlot;
import thaumicenergistics.common.network.packet.server.Packet_S_ChangeGui;
import thaumicenergistics.common.network.packet.server.Packet_S_ConfirmCraftingJob;
import thaumicenergistics.common.network.packet.server.Packet_S_DistillationEncoder;
import thaumicenergistics.common.network.packet.server.Packet_S_EssentiaCellTerminal;
import thaumicenergistics.common.network.packet.server.Packet_S_EssentiaCellWorkbench;
import thaumicenergistics.common.network.packet.server.Packet_S_EssentiaEmitter;
import thaumicenergistics.common.network.packet.server.Packet_S_EssentiaIOBus;
import thaumicenergistics.common.network.packet.server.Packet_S_EssentiaStorageBus;
import thaumicenergistics.common.network.packet.server.Packet_S_KnowledgeInscriber;
import thaumicenergistics.common.network.packet.server.Packet_S_NEIRecipe;
import thaumicenergistics.common.network.packet.server.Packet_S_Priority;
import thaumicenergistics.common.network.packet.server.Packet_S_WrenchFocus;
import thaumicenergistics.common.network.packet.server.ThEServerPacket;
import thaumicenergistics.common.network.packet.server.WrapperPacket_S;

public class NetworkHandler {
    private static SimpleNetworkWrapper channel = NetworkRegistry.INSTANCE.newSimpleChannel("thaumicenergistics");
    private static short nextID = 0;
    private static HashMap<Class<?>, Short> ClassToID = new HashMap();
    private static HashMap<Short, Class<?>> IDToClass = new HashMap();

    private static void registerPacket(Class<? extends ThEBasePacket> packetClass) {
        ClassToID.put(packetClass, nextID);
        IDToClass.put(nextID, packetClass);
        nextID = (short)(nextID + 1);
    }

    public static Class<?> getPacketClassFromID(Short id) {
        return IDToClass.getOrDefault(id, null);
    }

    public static short getPacketID(ThEBasePacket packet) {
        return ClassToID.getOrDefault(packet.getClass(), (short)-1);
    }

    public static void registerPackets() {
        channel.registerMessage(HandlerClient.class, WrapperPacket_C.class, 1, Side.CLIENT);
        channel.registerMessage(HandlerServer.class, WrapperPacket_S.class, 2, Side.SERVER);
        NetworkHandler.registerPacket(Packet_C_AspectSlot.class);
        NetworkHandler.registerPacket(Packet_S_AspectSlot.class);
        NetworkHandler.registerPacket(Packet_C_EssentiaIOBus.class);
        NetworkHandler.registerPacket(Packet_S_EssentiaIOBus.class);
        NetworkHandler.registerPacket(Packet_C_EssentiaStorageBus.class);
        NetworkHandler.registerPacket(Packet_S_EssentiaStorageBus.class);
        NetworkHandler.registerPacket(Packet_C_EssentiaEmitter.class);
        NetworkHandler.registerPacket(Packet_S_EssentiaEmitter.class);
        NetworkHandler.registerPacket(Packet_C_EssentiaCellTerminal.class);
        NetworkHandler.registerPacket(Packet_S_EssentiaCellTerminal.class);
        NetworkHandler.registerPacket(Packet_C_ArcaneCraftingTerminal.class);
        NetworkHandler.registerPacket(Packet_S_ArcaneCraftingTerminal.class);
        NetworkHandler.registerPacket(Packet_S_ChangeGui.class);
        NetworkHandler.registerPacket(Packet_C_Priority.class);
        NetworkHandler.registerPacket(Packet_S_Priority.class);
        NetworkHandler.registerPacket(Packet_S_EssentiaCellWorkbench.class);
        NetworkHandler.registerPacket(Packet_C_KnowledgeInscriber.class);
        NetworkHandler.registerPacket(Packet_S_KnowledgeInscriber.class);
        NetworkHandler.registerPacket(Packet_R_ParticleFX.class);
        NetworkHandler.registerPacket(Packet_S_WrenchFocus.class);
        NetworkHandler.registerPacket(Packet_C_EssentiaVibrationChamber.class);
        NetworkHandler.registerPacket(Packet_S_ConfirmCraftingJob.class);
        NetworkHandler.registerPacket(Packet_S_DistillationEncoder.class);
        NetworkHandler.registerPacket(Packet_C_Sync.class);
        NetworkHandler.registerPacket(Packet_S_NEIRecipe.class);
    }

    public static void sendAreaPacketToClients(ThEAreaPacket areaPacket, float range) {
        WrapperPacket_C wrapper = new WrapperPacket_C(areaPacket);
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(areaPacket.getDimension(), (double)areaPacket.getX(), (double)areaPacket.getY(), (double)areaPacket.getZ(), (double)range);
        channel.sendToAllAround((IMessage)wrapper, targetPoint);
    }

    public static void sendPacketToClient(ThEClientPacket clientPacket) {
        WrapperPacket_C wrapper = new WrapperPacket_C(clientPacket);
        channel.sendTo((IMessage)wrapper, (EntityPlayerMP)clientPacket.player);
    }

    public static void sendPacketToServer(ThEServerPacket serverPacket) {
        WrapperPacket_S wrapper = new WrapperPacket_S(serverPacket);
        channel.sendToServer((IMessage)wrapper);
    }
}

