/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.parts;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.ViewItems;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AEColor;
import appeng.api.util.IConfigManager;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.grid.ICraftingIssuerHost;
import thaumicenergistics.client.gui.GuiEssentiaCellTerminal;
import thaumicenergistics.client.textures.BlockTextureManager;
import thaumicenergistics.common.ThEGuiHandler;
import thaumicenergistics.common.container.ContainerEssentiaCellTerminalBase;
import thaumicenergistics.common.container.ContainerEssentiaTerminal;
import thaumicenergistics.common.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.common.inventory.TheInternalInventory;
import thaumicenergistics.common.network.packet.server.Packet_S_ChangeGui;
import thaumicenergistics.common.parts.AEPartsEnum;
import thaumicenergistics.common.parts.ThERotateablePart;
import thaumicenergistics.common.registries.EnumCache;
import thaumicenergistics.common.storage.AspectStackComparator;
import thaumicenergistics.common.utils.EffectiveSide;

public class PartEssentiaTerminal
extends ThERotateablePart
implements ICraftingIssuerHost {
    private static final double IDLE_POWER_DRAIN = 0.5;
    private static final String NBT_KEY_SORT_MODE = "sortMode";
    private static final String NBT_KEY_INVENTORY = "slots";
    private static final String NBT_KEY_VIEW_MODE = "ViewMode";
    private static final AspectStackComparator.AspectStackComparatorMode DEFAULT_SORT_MODE = AspectStackComparator.AspectStackComparatorMode.MODE_ALPHABETIC;
    private static final ViewItems DEFAULT_VIEW_MODE = ViewItems.ALL;
    private List<ContainerEssentiaTerminal> listeners = new ArrayList<ContainerEssentiaTerminal>();
    private AspectStackComparator.AspectStackComparatorMode sortMode = DEFAULT_SORT_MODE;
    private ViewItems viewMode = DEFAULT_VIEW_MODE;
    public Aspect selectedAspect = null;
    private TheInternalInventory inventory = new TheInternalInventory("thaumicenergistics.part.aspect.terminal", 2, 64){

        @Override
        public boolean func_94041_b(int slotId, ItemStack itemStack) {
            EssentiaItemContainerHelper.AspectItemType iType = EssentiaItemContainerHelper.INSTANCE.getItemType(itemStack);
            return iType == EssentiaItemContainerHelper.AspectItemType.EssentiaContainer || iType == EssentiaItemContainerHelper.AspectItemType.JarLabel;
        }
    };

    public PartEssentiaTerminal() {
        super(AEPartsEnum.EssentiaTerminal, new SecurityPermissions[0]);
    }

    private void notifyListenersOfModeChanged() {
        for (ContainerEssentiaTerminal listener : this.listeners) {
            listener.onModeChanged(this.sortMode, this.viewMode);
        }
    }

    public void addListener(ContainerEssentiaCellTerminalBase container) {
        if (container instanceof ContainerEssentiaTerminal) {
            this.listeners.add((ContainerEssentiaTerminal)container);
        }
    }

    @Override
    public int cableConnectionRenderTo() {
        return 1;
    }

    @Override
    public void getBoxes(IPartCollisionHelper helper) {
        helper.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        helper.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
        helper.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
    }

    @Override
    public IIcon getBreakingTexture() {
        return BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[3];
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return GuiEssentiaCellTerminal.NewEssentiaTerminalGui(this, player);
    }

    public IConfigManager getConfigManager() {
        return null;
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        if (wrenched) {
            return;
        }
        for (int slotIndex = 0; slotIndex < 2; ++slotIndex) {
            ItemStack slotStack = this.inventory.func_70301_a(slotIndex);
            if (slotStack == null) continue;
            drops.add(slotStack);
        }
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        return null;
    }

    @Override
    public ItemStack getIcon() {
        return this.associatedItem;
    }

    @Override
    public double getIdlePowerUsage() {
        return 0.5;
    }

    public TheInternalInventory getInventory() {
        return this.inventory;
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        return this.getGridBlock().getItemMonitor();
    }

    @Override
    public int getLightLevel() {
        return this.isActive() ? 9 : 0;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerEssentiaTerminal(this, player);
    }

    public AspectStackComparator.AspectStackComparatorMode getSortingMode() {
        return this.sortMode;
    }

    public ViewItems getViewMode() {
        return this.viewMode;
    }

    @Override
    public void launchGUI(EntityPlayer player) {
        TileEntity host = this.getHostTile();
        if (EffectiveSide.isServerSide()) {
            ThEGuiHandler.launchGui(this, player, host.func_145831_w(), host.field_145851_c, host.field_145848_d, host.field_145849_e);
        } else {
            Packet_S_ChangeGui.sendGuiChangeToPart(this, player, host.func_145831_w(), host.field_145851_c, host.field_145848_d, host.field_145849_e);
        }
    }

    public void onClientRequestSortingModeChange(boolean backwards) {
        this.sortMode = backwards ? this.sortMode.previousMode() : this.sortMode.nextMode();
        this.notifyListenersOfModeChanged();
        this.markForSave();
    }

    public void onClientRequestViewModeChange(boolean backwards) {
        this.viewMode = (ViewItems)Platform.rotateEnum((Enum)this.viewMode, (boolean)backwards, (EnumSet)Settings.VIEW_MODE.getPossibleValues());
        this.notifyListenersOfModeChanged();
        this.markForSave();
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(NBT_KEY_SORT_MODE)) {
            this.sortMode = AspectStackComparator.AspectStackComparatorMode.VALUES[data.func_74762_e(NBT_KEY_SORT_MODE)];
        }
        if (data.func_74764_b(NBT_KEY_INVENTORY)) {
            this.inventory.readFromNBT(data, NBT_KEY_INVENTORY);
        }
        if (data.func_74764_b(NBT_KEY_VIEW_MODE)) {
            this.viewMode = EnumCache.AE_VIEW_ITEMS[data.func_74762_e(NBT_KEY_VIEW_MODE)];
        }
    }

    public void removeListener(ContainerEssentiaTerminal containerAspectTerminal) {
        this.listeners.remove(containerAspectTerminal);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper helper, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[3];
        helper.setTexture(side);
        helper.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        helper.renderInventoryBox(renderer);
        helper.setTexture(side, side, side, BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[4], side, side);
        helper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        helper.renderInventoryBox(renderer);
        ts.func_78380_c(0xD000D0);
        helper.setInvColor(0xFFFFFF);
        helper.renderInventoryFace(BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[4], ForgeDirection.SOUTH, renderer);
        helper.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        helper.setInvColor(AEColor.Transparent.blackVariant);
        helper.renderInventoryFace(BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[0], ForgeDirection.SOUTH, renderer);
        helper.setInvColor(AEColor.Transparent.mediumVariant);
        helper.renderInventoryFace(BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[1], ForgeDirection.SOUTH, renderer);
        helper.setInvColor(AEColor.Transparent.whiteVariant);
        helper.renderInventoryFace(BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[2], ForgeDirection.SOUTH, renderer);
        helper.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        this.renderInventoryBusLights(helper, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper helper, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[3];
        helper.setTexture(side);
        helper.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        helper.renderBlock(x, y, z, renderer);
        helper.setTexture(side, side, side, BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[4], side, side);
        helper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        helper.renderBlock(x, y, z, renderer);
        if (this.isActive()) {
            Tessellator.field_78398_a.func_78380_c(0xD000D0);
        }
        this.rotateRenderer(renderer, false);
        ts.func_78378_d(0xFFFFFF);
        helper.renderFace(x, y, z, BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[4], ForgeDirection.SOUTH, renderer);
        helper.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        ts.func_78378_d(this.getHost().getColor().blackVariant);
        helper.renderFace(x, y, z, BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[0], ForgeDirection.SOUTH, renderer);
        ts.func_78378_d(this.getHost().getColor().mediumVariant);
        helper.renderFace(x, y, z, BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[1], ForgeDirection.SOUTH, renderer);
        ts.func_78378_d(this.getHost().getColor().whiteVariant);
        helper.renderFace(x, y, z, BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[2], ForgeDirection.SOUTH, renderer);
        this.rotateRenderer(renderer, true);
        helper.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        this.renderStaticBusLights(x, y, z, helper, renderer);
    }

    @Override
    public void writeToNBT(NBTTagCompound data, PartItemStack saveType) {
        super.writeToNBT(data, saveType);
        if (saveType != PartItemStack.World && saveType != PartItemStack.Wrench) {
            return;
        }
        if (this.sortMode != DEFAULT_SORT_MODE) {
            data.func_74768_a(NBT_KEY_SORT_MODE, this.sortMode.ordinal());
        }
        if (!this.inventory.isEmpty()) {
            this.inventory.writeToNBT(data, NBT_KEY_INVENTORY);
        }
        if (this.viewMode != DEFAULT_VIEW_MODE) {
            data.func_74768_a(NBT_KEY_VIEW_MODE, this.viewMode.ordinal());
        }
    }
}

