/*
 * Decompiled with CFR 0.152.
 */
package glowredman.txloader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import glowredman.txloader.Asset;
import glowredman.txloader.AssetBuilder;
import glowredman.txloader.ConfigHandler;
import glowredman.txloader.JarHandler;
import glowredman.txloader.MinecraftClassTransformer;
import glowredman.txloader.RemoteHandler;
import glowredman.txloader.ServerLangHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@IFMLLoadingPlugin.Name(value="TX Loader Core")
@IFMLLoadingPlugin.TransformerExclusions(value={"glowredman.txloader.TXLoaderCore", "glowredman.txloader.MinecraftClassTransformer"})
@IFMLLoadingPlugin.SortingIndex(value=1001)
@IFMLLoadingPlugin.MCVersion(value="1.7.10")
public class TXLoaderCore
implements IFMLLoadingPlugin {
    static final Logger LOGGER = LogManager.getLogger((String)"TX Loader");
    static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    static final List<Asset> REMOTE_ASSETS = new ArrayList<Asset>();
    static File modFile;
    static File mcLocation;
    static File configDir;
    static File resourcesDir;
    static File forceResourcesDir;
    static boolean isRemoteReachable;

    public String[] getASMTransformerClass() {
        if (FMLLaunchHandler.side().isClient()) {
            return new String[]{MinecraftClassTransformer.class.getName()};
        }
        return null;
    }

    public String getModContainerClass() {
        if (FMLLaunchHandler.side().isClient()) {
            return "glowredman.txloader.TXLoaderModContainer";
        }
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        modFile = (File)data.get("coremodLocation");
        mcLocation = (File)data.get("mcLocation");
        configDir = new File(mcLocation, "config" + File.separator + "txloader");
        resourcesDir = new File(configDir, "load");
        resourcesDir.mkdirs();
        forceResourcesDir = new File(configDir, "forceload");
        forceResourcesDir.mkdirs();
        if (FMLLaunchHandler.side().isServer()) {
            ServerLangHelper.load();
            return;
        }
        isRemoteReachable = RemoteHandler.getVersions();
        JarHandler.indexJars();
        ConfigHandler.load();
        ConfigHandler.moveRLAssets();
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public static AssetBuilder getAssetBuilder(String resourceLocation) {
        return new AssetBuilder(resourceLocation);
    }
}

