/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NamedTag;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.registry.WorldData;
import com.sk89q.worldedit.world.storage.NBTConversions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class SchematicReader
implements ClipboardReader {
    private static final Logger log = Logger.getLogger(SchematicReader.class.getCanonicalName());
    private final NBTInputStream inputStream;

    public SchematicReader(NBTInputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream);
        this.inputStream = inputStream;
    }

    @Override
    public Clipboard read(WorldData data) throws IOException {
        int index;
        CuboidRegion region;
        Vector origin;
        NamedTag rootTag = this.inputStream.readNamedTag();
        if (!rootTag.getName().equals("Schematic")) {
            throw new IOException("Tag 'Schematic' does not exist or is not first");
        }
        CompoundTag schematicTag = (CompoundTag)rootTag.getTag();
        Object schematic = schematicTag.getValue();
        if (!schematic.containsKey("Blocks")) {
            throw new IOException("Schematic file is missing a 'Blocks' tag");
        }
        String materials = SchematicReader.requireTag((Map<String, Tag>)schematic, "Materials", StringTag.class).getValue();
        if (!materials.equals("Alpha")) {
            throw new IOException("Schematic file is not an Alpha schematic");
        }
        int width = SchematicReader.requireTag((Map<String, Tag>)schematic, "Width", ShortTag.class).getValue().shortValue();
        int height = SchematicReader.requireTag((Map<String, Tag>)schematic, "Height", ShortTag.class).getValue().shortValue();
        int length = SchematicReader.requireTag((Map<String, Tag>)schematic, "Length", ShortTag.class).getValue().shortValue();
        try {
            int originX = SchematicReader.requireTag((Map<String, Tag>)schematic, "WEOriginX", IntTag.class).getValue();
            int originY = SchematicReader.requireTag((Map<String, Tag>)schematic, "WEOriginY", IntTag.class).getValue();
            int originZ = SchematicReader.requireTag((Map<String, Tag>)schematic, "WEOriginZ", IntTag.class).getValue();
            Vector min = new Vector(originX, originY, originZ);
            int offsetX = SchematicReader.requireTag((Map<String, Tag>)schematic, "WEOffsetX", IntTag.class).getValue();
            int offsetY = SchematicReader.requireTag((Map<String, Tag>)schematic, "WEOffsetY", IntTag.class).getValue();
            int offsetZ = SchematicReader.requireTag((Map<String, Tag>)schematic, "WEOffsetZ", IntTag.class).getValue();
            Vector offset = new Vector(offsetX, offsetY, offsetZ);
            origin = min.subtract(offset);
            region = new CuboidRegion(min, min.add(width, height, length).subtract(Vector.ONE));
        }
        catch (IOException ignored) {
            origin = new Vector(0, 0, 0);
            region = new CuboidRegion(origin, origin.add(width, height, length).subtract(Vector.ONE));
        }
        final HashMap<Short, Short> blockConversionMap = new HashMap<Short, Short>();
        if (schematic.containsKey("BlockMapping")) {
            Object mapping = SchematicReader.requireTag((Map<String, Tag>)schematic, "BlockMapping", CompoundTag.class).getValue();
            for (Object key : mapping.keySet()) {
                short sourceId = SchematicReader.requireTag((Map<String, Tag>)mapping, (String)key, ShortTag.class).getValue();
                Block block = Block.func_149684_b((String)key);
                blockConversionMap.put(sourceId, (short)Block.func_149682_b((Block)block));
            }
        }
        final HashMap<Short, Short> itemConversionMap = new HashMap<Short, Short>();
        if (schematic.containsKey("ItemMapping")) {
            Object mapping = SchematicReader.requireTag((Map<String, Tag>)schematic, "ItemMapping", CompoundTag.class).getValue();
            for (String key : mapping.keySet()) {
                short sourceId = SchematicReader.requireTag((Map<String, Tag>)mapping, key, ShortTag.class).getValue();
                Item item = (Item)Item.field_150901_e.func_82594_a(key);
                itemConversionMap.put(sourceId, (short)Item.func_150891_b((Item)item));
            }
        }
        byte[] blockId = SchematicReader.requireTag((Map<String, Tag>)schematic, "Blocks", ByteArrayTag.class).getValue();
        byte[] blockData = SchematicReader.requireTag((Map<String, Tag>)schematic, "Data", ByteArrayTag.class).getValue();
        byte[] addData = null;
        if (schematic.containsKey("AddData")) {
            addData = SchematicReader.requireTag((Map<String, Tag>)schematic, "AddData", ByteArrayTag.class).getValue();
        }
        byte[] addId = new byte[]{};
        byte[] addId2 = new byte[]{};
        short[] blocks = new short[blockId.length];
        if (schematic.containsKey("AddBlocks")) {
            addId = SchematicReader.requireTag((Map<String, Tag>)schematic, "AddBlocks", ByteArrayTag.class).getValue();
        }
        if (schematic.containsKey("AddBlocks2")) {
            addId2 = SchematicReader.requireTag((Map<String, Tag>)schematic, "AddBlocks2", ByteArrayTag.class).getValue();
        }
        for (index = 0; index < blockId.length; ++index) {
            blocks[index] = index >> 1 >= addId.length ? (short)(blockId[index] & 0xFF) : ((index & 1) == 0 ? (short)(((addId[index >> 1] & 0xF) << 8) + (blockId[index] & 0xFF)) : (short)(((addId[index >> 1] & 0xF0) << 4) + (blockId[index] & 0xFF)));
        }
        for (index = 0; index < blockId.length; ++index) {
            if (index >> 1 >= addId2.length) continue;
            blocks[index] = (index & 1) == 0 ? (short)(((addId2[index >> 1] & 0xF) << 8) + (blocks[index] & 0xFFF)) : (short)(((addId2[index >> 1] & 0xF0) << 4) + (blocks[index] & 0xFFF));
        }
        Object tileEntities = SchematicReader.requireTag((Map<String, Tag>)schematic, "TileEntities", ListTag.class).getValue();
        HashMap tileEntitiesMap = new HashMap();
        Iterator iterator = tileEntities.iterator();
        while (iterator.hasNext()) {
            Tag tag = (Tag)iterator.next();
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag t = (CompoundTag)tag;
            int x = 0;
            int y = 0;
            int z = 0;
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            for (Map.Entry entry : t.getValue().entrySet()) {
                if (((String)entry.getKey()).equals("x")) {
                    if (entry.getValue() instanceof IntTag) {
                        x = ((IntTag)entry.getValue()).getValue();
                    }
                } else if (((String)entry.getKey()).equals("y")) {
                    if (entry.getValue() instanceof IntTag) {
                        y = ((IntTag)entry.getValue()).getValue();
                    }
                } else if (((String)entry.getKey()).equals("z") && entry.getValue() instanceof IntTag) {
                    z = ((IntTag)entry.getValue()).getValue();
                }
                values.put((String)entry.getKey(), (Tag)entry.getValue());
            }
            BlockVector vec = new BlockVector(x, y, z);
            tileEntitiesMap.put(vec, values);
        }
        BlockArrayClipboard clipboard = new BlockArrayClipboard(region);
        clipboard.setOrigin(origin);
        int failedBlockSets = 0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    int index2 = y * width * length + z * width + x;
                    BlockVector pt = new BlockVector(x, y, z);
                    if (!blockConversionMap.isEmpty()) {
                        blocks[index2] = blockConversionMap.getOrDefault(blocks[index2], blocks[index2]);
                    }
                    BaseBlock block = new BaseBlock(blocks[index2] & 0xFFFF, (blockData[index2] & 0xFF) + (addData != null ? addData[index2] & 0xFF00 : 0));
                    if (tileEntitiesMap.containsKey(pt)) {
                        final BiPredicate<CompoundTag, String[]> isItem = (itemTag, idPtr) -> {
                            idPtr[0] = "id";
                            if ("id" != null && itemTag.containsKey("id") && itemTag.containsKey("Count")) {
                                if (itemTag.containsKey("Damage")) return true;
                            }
                            idPtr[0] = "Item";
                            if ("Item" != null && itemTag.containsKey("Item") && itemTag.containsKey("Count")) {
                                if (itemTag.containsKey("Meta")) return true;
                            }
                            idPtr[0] = "id";
                            if ("id" == null) return false;
                            if (!itemTag.containsKey("id")) return false;
                            if (!(itemTag.getValue().get("id") instanceof IntTag)) return false;
                            return true;
                        };
                        Function<CompoundTag, CompoundTag> convertItems = new Function<CompoundTag, CompoundTag>(){

                            @Override
                            public CompoundTag apply(CompoundTag nbtData) {
                                StringTag str;
                                Object itemMap2;
                                String[] idPtr = new String[1];
                                if (isItem.test(nbtData, idPtr)) {
                                    Object v;
                                    short id;
                                    Integer id_data = null;
                                    if (nbtData.getValue().get(idPtr[0]) instanceof IntTag) {
                                        id_data = nbtData.getInt(idPtr[0]);
                                        id = id_data.shortValue();
                                    } else {
                                        id = nbtData.getShort(idPtr[0]);
                                    }
                                    HashMap<String, Tag> itemMap2 = new HashMap<String, Tag>((Map<String, Tag>)nbtData.getValue());
                                    short newId = itemConversionMap.getOrDefault(id, id);
                                    if (id_data != null) {
                                        itemMap2.put(idPtr[0], new IntTag(newId + (id_data & 0xFFFF0000)));
                                    } else {
                                        itemMap2.put(idPtr[0], new ShortTag(newId));
                                    }
                                    if (nbtData.containsKey("tag") && (v = itemMap2.get("tag")) instanceof CompoundTag) {
                                        CompoundTag nbt = (CompoundTag)v;
                                        itemMap2.put("tag", this.apply(nbt));
                                    }
                                    if (nbtData.containsKey("d") && (v = itemMap2.get("d")) instanceof CompoundTag) {
                                        CompoundTag d = (CompoundTag)v;
                                        itemMap2.put("d", this.apply(d));
                                    }
                                    return nbtData.setValue(itemMap2);
                                }
                                HashMap<String, Tag> nbtMap = new HashMap<String, Tag>((Map<String, Tag>)nbtData.getValue());
                                if (nbtData.containsKey("id") && (itemMap2 = nbtData.getValue().get("id")) instanceof StringTag && "customDoorTileEntity".equals((str = (StringTag)itemMap2).getValue())) {
                                    Object _id5;
                                    Object _id22;
                                    Object _id32;
                                    Object _id42;
                                    IntTag itag;
                                    Object d;
                                    String key = "bottomMaterial";
                                    if (nbtData.containsKey("bottomMaterial") && (d = nbtData.getValue().get(key)) instanceof IntTag) {
                                        itag = (IntTag)d;
                                        int _id42 = itag.getValue();
                                        nbtMap.put(key, new IntTag(itemConversionMap.getOrDefault((short)_id42, (short)_id42).shortValue()));
                                    }
                                    key = "topMaterial";
                                    if (nbtData.containsKey("topMaterial") && (_id42 = nbtData.getValue().get(key)) instanceof IntTag) {
                                        itag = (IntTag)_id42;
                                        int _id32 = itag.getValue();
                                        nbtMap.put(key, new IntTag(itemConversionMap.getOrDefault((short)_id32, (short)_id32).shortValue()));
                                    }
                                    key = "frame";
                                    if (nbtData.containsKey("frame") && (_id32 = nbtData.getValue().get(key)) instanceof IntTag) {
                                        itag = (IntTag)_id32;
                                        int _id22 = itag.getValue();
                                        nbtMap.put(key, new IntTag(itemConversionMap.getOrDefault((short)_id22, (short)_id22).shortValue()));
                                    }
                                    key = "block";
                                    if (nbtData.containsKey("block") && (_id22 = nbtData.getValue().get(key)) instanceof IntTag) {
                                        itag = (IntTag)_id22;
                                        int _id5 = itag.getValue();
                                        nbtMap.put(key, new IntTag(blockConversionMap.getOrDefault((short)_id5, (short)_id5).shortValue()));
                                    }
                                    key = "item";
                                    if (nbtData.containsKey("item") && (_id5 = nbtData.getValue().get(key)) instanceof IntTag) {
                                        itag = (IntTag)_id5;
                                        int _id6 = itag.getValue();
                                        nbtMap.put(key, new IntTag(itemConversionMap.getOrDefault((short)_id6, (short)_id6).shortValue()));
                                    }
                                }
                                for (String key : nbtMap.keySet()) {
                                    Tag tag = nbtMap.get(key);
                                    if (tag instanceof ListTag) {
                                        ListTag inventoryTag = (ListTag)tag;
                                        ArrayList<Tag> inventoryList = new ArrayList<Tag>((Collection<Tag>)inventoryTag.getValue());
                                        for (int i = 0; i < inventoryList.size(); ++i) {
                                            Object e = inventoryList.get(i);
                                            if (!(e instanceof CompoundTag)) continue;
                                            CompoundTag itemTag = (CompoundTag)e;
                                            inventoryList.set(i, this.apply(itemTag));
                                        }
                                        nbtMap.put(key, inventoryTag.setValue(inventoryList));
                                        continue;
                                    }
                                    tag = nbtMap.get(key);
                                    if (!(tag instanceof CompoundTag)) continue;
                                    CompoundTag itemTag = (CompoundTag)tag;
                                    nbtMap.put(key, this.apply(itemTag));
                                }
                                return nbtData.setValue(nbtMap);
                            }
                        };
                        CompoundTag nbtData = new CompoundTag((Map)tileEntitiesMap.get(pt));
                        if (!itemConversionMap.isEmpty()) {
                            nbtData = (CompoundTag)convertItems.apply(nbtData);
                        }
                        block.setNbtData(nbtData);
                    }
                    try {
                        clipboard.setBlock(region.getMinimumPoint().add((Vector)pt), block);
                        continue;
                    }
                    catch (WorldEditException e) {
                        switch (failedBlockSets) {
                            case 0: {
                                log.log(Level.WARNING, "Failed to set block on a Clipboard", e);
                                break;
                            }
                            case 1: {
                                log.log(Level.WARNING, "Failed to set block on a Clipboard (again) -- no more messages will be logged", e);
                                break;
                            }
                        }
                        ++failedBlockSets;
                    }
                }
            }
        }
        try {
            Object entityTags = SchematicReader.requireTag((Map<String, Tag>)schematic, "Entities", ListTag.class).getValue();
            Iterator iterator2 = entityTags.iterator();
            while (iterator2.hasNext()) {
                Tag tag = (Tag)iterator2.next();
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag compound = (CompoundTag)tag;
                String id = compound.getString("id");
                Location location = NBTConversions.toLocation(clipboard, compound.getListTag("Pos"), compound.getListTag("Rotation"));
                if (id.isEmpty()) continue;
                BaseEntity state = new BaseEntity(id, compound);
                clipboard.createEntity(location, state);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return clipboard;
    }

    private static <T extends Tag> T requireTag(Map<String, Tag> items, String key, Class<T> expected) throws IOException {
        if (!items.containsKey(key)) {
            throw new IOException("Schematic file is missing a \"" + key + "\" tag");
        }
        Tag tag = items.get(key);
        if (!expected.isInstance(tag)) {
            throw new IOException(key + " tag is not of tag type " + expected.getName());
        }
        return (T)((Tag)expected.cast(tag));
    }

    @Nullable
    private static <T extends Tag> T getTag(CompoundTag tag, Class<T> expected, String key) {
        Object items = tag.getValue();
        if (!items.containsKey(key)) {
            return null;
        }
        Tag test = (Tag)items.get(key);
        if (!expected.isInstance(test)) {
            return null;
        }
        return (T)((Tag)expected.cast(test));
    }
}

