/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.forge.ForgeWorldEdit;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

final class TileEntityUtils {
    private TileEntityUtils() {
    }

    private static NBTTagCompound updateForSet(NBTTagCompound tag, Vector position) {
        tag.func_74782_a("x", (NBTBase)new NBTTagInt(position.getBlockX()));
        tag.func_74782_a("y", (NBTBase)new NBTTagInt(position.getBlockY()));
        tag.func_74782_a("z", (NBTBase)new NBTTagInt(position.getBlockZ()));
        return tag;
    }

    static void setTileEntity(World world, Vector position, @Nullable NBTTagCompound tag) {
        if (tag != null) {
            TileEntityUtils.updateForSet(tag, position);
            TileEntity tileEntity = TileEntityUtils.makeTileEntity(world, position, tag);
            if (tileEntity != null) {
                TileEntityUtils.setTileEntity(world, position, tileEntity);
            }
        }
    }

    private static TileEntity makeTileEntity(World world, Vector position, NBTTagCompound tag) {
        TileEntity normal = TileEntity.func_145827_c((NBTTagCompound)tag);
        return ForgeWorldEdit.inst.getFMPCompat().overrideTileEntity(world, tag, normal);
    }

    private static void setTileEntity(World world, Vector position, TileEntity tileEntity) {
        world.func_147455_a(position.getBlockX(), position.getBlockY(), position.getBlockZ(), tileEntity);
        ForgeWorldEdit.inst.getFMPCompat().sendDescPacket(world, tileEntity);
    }
}

