/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge.compat;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.CompoundTagBuilder;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.extent.transform.BlockTransformHook;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;

public class CarpentersBlocksBlockTransformHook
implements BlockTransformHook {
    private int[][] rotationGroups = new int[][]{{0, 2, 1, 3}, {4, 6, 5, 7}, {8, 10, 9, 11}, {12, 14, 13, 15}, {16, 18, 17, 19}, {20, 22, 21, 23}, {24, 26, 25, 27}, {28, 30, 29, 31}, {32, 34, 33, 35}, {36, 38, 37, 39}, {40, 42, 41, 43}, {44, 45}, {46, 48, 47, 49}, {52, 54, 53, 55}, {56, 58, 57, 59}, {60}, {61, 63, 62, 64}};

    private int rotateSlot(int slot, int ticks) {
        for (int type = 0; type < this.rotationGroups.length; ++type) {
            int[] rotations = this.rotationGroups[type];
            for (int i = 0; i < rotations.length; ++i) {
                if (rotations[i] != slot) continue;
                ticks = ticks % rotations.length + rotations.length;
                slot = rotations[(i + ticks) % rotations.length];
                return slot;
            }
        }
        return -1;
    }

    @Override
    public BaseBlock transformBlock(BaseBlock block, Transform transform) {
        CompoundTag nbt = block.getNbtData();
        if (nbt == null) {
            return block;
        }
        if (!"TileEntityCarpentersBlock".equals(nbt.getString("id"))) {
            return block;
        }
        if (!(transform instanceof AffineTransform)) {
            return block;
        }
        AffineTransform affine = (AffineTransform)transform;
        Vector rot = affine.getRotations();
        if (rot.getX() > 0.0) {
            System.out.println("X rotation is currently unsupported");
            rot = rot.setX(0);
        }
        if (rot.getZ() > 0.0) {
            System.out.println("Z rotation is currently unsupported");
            rot = rot.setZ(0);
        }
        if (rot.lengthSq() == 0.0) {
            return block;
        }
        CompoundTagBuilder builder = nbt.createBuilder();
        int md = nbt.asInt("cbMetadata");
        if (rot.getY() > 0.0) {
            int ticks = (int)Math.round(rot.getY() / 90.0);
            md = this.rotateSlot(md, ticks);
        }
        builder.putInt("cbMetadata", md);
        return new BaseBlock(block.getId(), block.getData(), builder.build());
    }
}

