/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips;

import com.slprime.chromatictooltips.ChromaticTooltips;
import com.slprime.chromatictooltips.TooltipRegistry;
import com.slprime.chromatictooltips.TooltipRenderer;
import com.slprime.chromatictooltips.api.EnricherPlace;
import com.slprime.chromatictooltips.api.ITooltipComponent;
import com.slprime.chromatictooltips.api.ITooltipEnricher;
import com.slprime.chromatictooltips.api.ITooltipRenderer;
import com.slprime.chromatictooltips.api.TooltipBuilder;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.api.TooltipLines;
import com.slprime.chromatictooltips.api.TooltipModifier;
import com.slprime.chromatictooltips.api.TooltipRequest;
import com.slprime.chromatictooltips.api.TooltipStyle;
import com.slprime.chromatictooltips.api.TooltipTarget;
import com.slprime.chromatictooltips.component.SectionComponent;
import com.slprime.chromatictooltips.config.EnricherConfig;
import com.slprime.chromatictooltips.config.GeneralConfig;
import com.slprime.chromatictooltips.event.TooltipEnricherEvent;
import com.slprime.chromatictooltips.util.ComponentRegistry;
import com.slprime.chromatictooltips.util.Parser;
import com.slprime.chromatictooltips.util.TooltipUtils;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.resources.IResource;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TooltipHandler {
    protected static final int MIN_FPS = 8;
    protected static final int MAX_FPS = 60;
    protected static final ComponentRegistry componentRegistry = new ComponentRegistry();
    protected static final String CONFIG_FILE = "tooltip.json";
    protected static final String COMPONENT_PREFIX = "\u00a7z";
    protected static ITooltipRenderer defaultTooltipRenderer = null;
    protected static Map<String, List<ITooltipRenderer>> otherTooltipRenderers = new HashMap<String, List<ITooltipRenderer>>();
    protected static final Parser parser = new Parser();
    protected static Class<? extends ITooltipRenderer> rendererClass = null;
    protected static final TooltipCache tooltipCache = new TooltipCache();
    protected static final ShowDelayTracker showDelayTracker = new ShowDelayTracker();
    protected static Point lastMousePosition = null;
    protected static boolean renderLastTooltip = false;

    public static void reload() {
        otherTooltipRenderers.clear();
        defaultTooltipRenderer = null;
        TooltipHandler.loadTooltipResource();
        if (defaultTooltipRenderer == null) {
            defaultTooltipRenderer = TooltipHandler.createRenderer(new TooltipStyle());
        }
    }

    protected static void parseStyle(String json) {
        List<TooltipStyle> scopes = parser.parse(json);
        for (TooltipStyle style : scopes) {
            String context = style.getAsString("context", null);
            if (context == null && style.containsKey("filter")) {
                context = "item";
            }
            if (context == null || "default".equals(context)) {
                defaultTooltipRenderer = TooltipHandler.createRenderer(style);
                continue;
            }
            otherTooltipRenderers.computeIfAbsent(context, k -> new ArrayList()).add(TooltipHandler.createRenderer(style));
        }
    }

    protected static void loadTooltipResource() {
        ResourceLocation location = new ResourceLocation("chromatictooltips", CONFIG_FILE);
        try {
            IResource res = TooltipUtils.mc().func_110442_L().func_110536_a(location);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(res.func_110527_b(), StandardCharsets.UTF_8));){
                ChromaticTooltips.LOG.info("Loading '{}' from resourcepack {}", new Object[]{CONFIG_FILE, location});
                TooltipHandler.parseStyle(reader.lines().collect(Collectors.joining("\n")));
            }
        }
        catch (Exception io) {
            ChromaticTooltips.LOG.error("Failed to load '{}' resourcepack {}", new Object[]{CONFIG_FILE, location});
            io.printStackTrace();
        }
    }

    protected static ITooltipRenderer createRenderer(TooltipStyle style) {
        try {
            return rendererClass.getConstructor(TooltipStyle.class).newInstance(style);
        }
        catch (Exception e1) {
            return new TooltipRenderer(style);
        }
    }

    public static String getComponentId(ITooltipComponent component) {
        return COMPONENT_PREFIX + componentRegistry.add(component);
    }

    public static ITooltipComponent getTooltipComponent(String line) {
        if (!line.startsWith(COMPONENT_PREFIX)) {
            return null;
        }
        try {
            int token = Integer.parseInt(line.substring(COMPONENT_PREFIX.length()));
            return componentRegistry.get(token);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static void setRendererClass(Class<? extends ITooltipRenderer> rendererClass) {
        TooltipHandler.rendererClass = rendererClass;
        TooltipHandler.reload();
    }

    public static TooltipBuilder builder() {
        return new TooltipBuilder();
    }

    public static void drawHoveringText(ItemStack stack, List<?> textLines) {
        TooltipHandler.drawHoveringText(new TooltipRequest(null, TooltipTarget.ofItem(stack), new TooltipLines(textLines), null));
    }

    public static void drawHoveringText(List<?> textLines) {
        TooltipHandler.drawHoveringText(new TooltipRequest(null, TooltipTarget.ofItem(null), new TooltipLines(textLines), null));
    }

    public static void drawHoveringText(TooltipRequest request) {
        if (request == null || !request.target.isItem() && !request.target.isFluid() && request.tooltip.isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (GeneralConfig.tooltipShowUpDelay > 0 && !TooltipHandler.handleTooltipShowDelay(request, currentTime)) {
            return;
        }
        if (currentTime - TooltipHandler.tooltipCache.lastFrameTime > 16L) {
            int currentHash = TooltipUtils.getMetaHash();
            if (TooltipHandler.tooltipCache.context == null || !request.sameSubjectAs(TooltipHandler.tooltipCache.request)) {
                TooltipHandler.tooltipCache.lastUpdateTime = currentTime;
                TooltipHandler.tooltipCache.request = request.copy();
                TooltipHandler.tooltipCache.context = TooltipHandler.createTooltipContext(request, null);
            } else if (TooltipHandler.tooltipCache.hashCode != currentHash || currentTime - TooltipHandler.tooltipCache.lastUpdateTime > 125L || !request.equivalentTo(TooltipHandler.tooltipCache.request)) {
                TooltipHandler.tooltipCache.request = request.copy();
                TooltipHandler.tooltipCache.lastUpdateTime = currentTime;
                TooltipHandler.tooltipCache.context = TooltipHandler.createTooltipContext(request, TooltipHandler.tooltipCache.context);
            }
            TooltipHandler.tooltipCache.hashCode = currentHash;
            TooltipHandler.tooltipCache.lastFrameTime = currentTime;
        }
        lastMousePosition = request.mouse != null ? request.mouse : TooltipUtils.getMousePosition();
        renderLastTooltip = true;
    }

    protected static boolean handleTooltipShowDelay(TooltipRequest request, long currentTime) {
        if (TooltipHandler.showDelayTracker.hoverStartTime == -1L) {
            TooltipHandler.showDelayTracker.hoverStartTime = currentTime;
        }
        if (currentTime - TooltipHandler.showDelayTracker.hoverStartTime < (long)GeneralConfig.tooltipShowUpDelay) {
            Point mouse;
            Point point = mouse = request.mouse != null ? request.mouse : TooltipUtils.getMousePosition();
            if (lastMousePosition != null && (mouse.x != TooltipHandler.lastMousePosition.x || mouse.y != TooltipHandler.lastMousePosition.y)) {
                TooltipHandler.showDelayTracker.hoverStartTime = -1L;
            }
            lastMousePosition = mouse;
            TooltipHandler.showDelayTracker.track = true;
            return false;
        }
        return true;
    }

    public static TooltipContext createTooltipContext(TooltipRequest request, TooltipContext previousContext) {
        request = TooltipRegistry.resolveRequest(request);
        TooltipContext context = previousContext != null ? new TooltipContext(request, previousContext) : new TooltipContext(request, TooltipHandler.getRendererFor(request));
        if (EnricherConfig.keyboardModifiersEnabled) {
            TooltipHandler.updateSupportedModifiers(context);
        }
        TooltipHandler.enrichTooltip(context);
        return context;
    }

    protected static void enrichTooltip(TooltipContext context) {
        TooltipModifier activeModifier = TooltipUtils.getActiveModifier();
        TooltipStyle style = context.getRenderer().getStyle();
        ITooltipRenderer renderer = context.getRenderer();
        ArrayList<SectionComponent> headerSections = new ArrayList<SectionComponent>();
        ArrayList<SectionComponent> bodySections = new ArrayList<SectionComponent>();
        ArrayList<SectionComponent> footerSections = new ArrayList<SectionComponent>();
        Comparator<SectionComponent> byOrder = Comparator.comparingInt(s -> style.getAsInt("sections." + s.getSectionId() + ".order", 0));
        context.setActiveModifier(activeModifier);
        for (ITooltipEnricher enricher : TooltipRegistry.getEnrichers()) {
            TooltipLines result;
            EnumSet<TooltipModifier> modes = renderer.getEnricherModes(enricher.sectionId(), enricher.mode());
            EnricherPlace place = renderer.getEnricherPlace(enricher.sectionId(), enricher.place());
            if ((!modes.contains((Object)TooltipModifier.NONE) || place != EnricherPlace.HEADER && place != EnricherPlace.FOOTER) && !modes.contains((Object)activeModifier) || (result = enricher.build(context)) == null || result.isEmpty()) continue;
            String sectionId = enricher.sectionId();
            SectionComponent section = new SectionComponent(sectionId, renderer.getSectionBox("sections." + sectionId), result.build(context));
            if (place == EnricherPlace.HEADER) {
                headerSections.add(section);
                continue;
            }
            if (place == EnricherPlace.BODY) {
                bodySections.add(section);
                continue;
            }
            if (place != EnricherPlace.FOOTER) continue;
            footerSections.add(section);
        }
        if (bodySections.isEmpty() && activeModifier != TooltipModifier.NONE) {
            bodySections.addAll(TooltipHandler.fallbackBuildBodyList(context));
        }
        headerSections.sort(byOrder);
        bodySections.sort(byOrder);
        footerSections.sort(byOrder);
        context.addSection("header", new ArrayList<ITooltipComponent>(headerSections));
        context.addSection("body", new ArrayList<ITooltipComponent>(bodySections));
        context.addSection("footer", new ArrayList<ITooltipComponent>(footerSections));
        TooltipUtils.postEvent(new TooltipEnricherEvent(context));
    }

    public static void updateSupportedModifiers(TooltipContext context) {
        ITooltipRenderer renderer = context.getRenderer();
        for (ITooltipEnricher enricher : TooltipRegistry.getEnrichers()) {
            EnricherPlace place = renderer.getEnricherPlace(enricher.sectionId(), enricher.place());
            if ("itemInfo".equals(enricher.sectionId()) || place != EnricherPlace.BODY) continue;
            EnumSet<TooltipModifier> modes = renderer.getEnricherModes(enricher.sectionId(), enricher.mode());
            TooltipLines noneComponents = null;
            if (modes.contains((Object)TooltipModifier.NONE)) {
                context.setActiveModifier(TooltipModifier.NONE);
                noneComponents = enricher.build(context);
            }
            for (TooltipModifier modifier : modes) {
                if (modifier == TooltipModifier.NONE || context.getSupportedModifiers().contains((Object)modifier)) continue;
                context.setActiveModifier(modifier);
                TooltipLines result = enricher.build(context);
                if (result == null || result.isEmpty() || noneComponents != null && result.equals(noneComponents)) continue;
                context.supportModifiers(modifier);
            }
        }
    }

    protected static List<SectionComponent> fallbackBuildBodyList(TooltipContext context) {
        ArrayList<SectionComponent> bodySections = new ArrayList<SectionComponent>();
        ITooltipRenderer renderer = context.getRenderer();
        context.setActiveModifier(TooltipModifier.NONE);
        for (ITooltipEnricher enricher : TooltipRegistry.getEnrichers()) {
            TooltipLines result;
            EnumSet<TooltipModifier> modes = renderer.getEnricherModes(enricher.sectionId(), enricher.mode());
            EnricherPlace place = renderer.getEnricherPlace(enricher.sectionId(), enricher.place());
            if (place != EnricherPlace.BODY || !modes.contains((Object)TooltipModifier.NONE) || (result = enricher.build(context)) == null || result.isEmpty()) continue;
            String sectionId = enricher.sectionId();
            SectionComponent section = new SectionComponent(sectionId, renderer.getSectionBox("sections." + sectionId), result.build(context));
            bodySections.add(section);
        }
        return bodySections;
    }

    public static boolean hasTooltipRendererFor(TooltipRequest request) {
        return TooltipHandler.getRendererFor(request) != defaultTooltipRenderer;
    }

    public static ITooltipRenderer getRendererFor(TooltipRequest request) {
        String context;
        String fallbackContext = request.target.isItem() ? "item" : (request.target.isFluid() ? "fluid" : "default");
        String string = context = request.context != null ? request.context : fallbackContext;
        if ("default".equals(context)) {
            return defaultTooltipRenderer;
        }
        ITooltipRenderer renderer = TooltipHandler.findRenderer(context, request.target);
        if (renderer == null && (request.target.isItem() || request.target.isFluid()) && !fallbackContext.equals(context)) {
            renderer = TooltipHandler.findRenderer(fallbackContext, request.target);
        }
        if (renderer == null && request.target.isFluid()) {
            renderer = TooltipHandler.findRenderer("item", null);
        }
        return renderer != null ? renderer : defaultTooltipRenderer;
    }

    private static ITooltipRenderer findRenderer(String context, TooltipTarget target) {
        for (ITooltipRenderer renderer : otherTooltipRenderers.getOrDefault(context, Collections.emptyList())) {
            if (!renderer.matches(target)) continue;
            return renderer;
        }
        return null;
    }

    public static TooltipContext getLastTooltipContext() {
        return TooltipHandler.tooltipCache.context;
    }

    public static void drawLastTooltip() {
        if (TooltipHandler.tooltipCache.context == null) {
            if (TooltipHandler.showDelayTracker.track) {
                TooltipHandler.showDelayTracker.track = false;
            } else {
                TooltipHandler.showDelayTracker.hoverStartTime = -1L;
            }
        } else if (renderLastTooltip) {
            TooltipHandler.tooltipCache.context.drawAtMousePosition(TooltipHandler.lastMousePosition.x, TooltipHandler.lastMousePosition.y);
            renderLastTooltip = false;
        } else {
            tooltipCache.reset();
            showDelayTracker.reset();
        }
    }

    public static boolean nextTooltipPage() {
        if (TooltipHandler.tooltipCache.context != null) {
            return TooltipHandler.tooltipCache.context.nextTooltipPage();
        }
        return false;
    }

    public static boolean previousTooltipPage() {
        if (TooltipHandler.tooltipCache.context != null) {
            return TooltipHandler.tooltipCache.context.previousTooltipPage();
        }
        return false;
    }

    private static class TooltipCache {
        public long lastFrameTime = -1L;
        public long lastUpdateTime = -1L;
        public TooltipContext context = null;
        public TooltipRequest request = null;
        public int hashCode = -1;

        private TooltipCache() {
        }

        public void reset() {
            this.lastFrameTime = -1L;
            this.lastUpdateTime = -1L;
            this.context = null;
            this.request = null;
            this.hashCode = -1;
        }
    }

    private static class ShowDelayTracker {
        public long hoverStartTime = -1L;
        public boolean track = false;

        private ShowDelayTracker() {
        }

        public void reset() {
            this.hoverStartTime = -1L;
            this.track = false;
        }
    }
}

