/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips;

import com.slprime.chromatictooltips.api.ITargetSanitizer;
import com.slprime.chromatictooltips.api.ITooltipEnricher;
import com.slprime.chromatictooltips.api.ITooltipLineConverter;
import com.slprime.chromatictooltips.api.ITooltipRequestResolver;
import com.slprime.chromatictooltips.api.TooltipRequest;
import com.slprime.chromatictooltips.api.TooltipTarget;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;

public class TooltipRegistry {
    protected static final List<ITooltipEnricher> tooltipEnrichers = new ArrayList<ITooltipEnricher>();
    protected static final List<ITooltipRequestResolver> requestResolvers = new ArrayList<ITooltipRequestResolver>();
    protected static final List<ITargetSanitizer> targetSanitizers = new ArrayList<ITargetSanitizer>();
    protected static final List<Map.Entry<Pattern, ITooltipLineConverter>> lineConverters = new ArrayList<Map.Entry<Pattern, ITooltipLineConverter>>();

    private TooltipRegistry() {
    }

    public static void addRequestResolver(ITooltipRequestResolver resolver) {
        requestResolvers.add(resolver);
    }

    public static TooltipRequest resolveRequest(TooltipRequest request) {
        request = new TooltipRequest(request, TooltipRegistry.sanitizeTarget(request.target));
        for (ITooltipRequestResolver resolver : requestResolvers) {
            if (resolver.resolve(request)) break;
        }
        return request;
    }

    public static void addLineConverter(Pattern regexp, ITooltipLineConverter converter) {
        lineConverters.add(new AbstractMap.SimpleEntry<Pattern, ITooltipLineConverter>(regexp, converter));
    }

    public static Map.Entry<Matcher, ITooltipLineConverter> getLineConverter(String line) {
        for (Map.Entry<Pattern, ITooltipLineConverter> entry : lineConverters) {
            Matcher matcher = entry.getKey().matcher(line);
            if (!matcher.matches()) continue;
            return new AbstractMap.SimpleEntry<Matcher, ITooltipLineConverter>(matcher, entry.getValue());
        }
        return null;
    }

    public static void addTargetSanitizer(ITargetSanitizer sanitizer) {
        targetSanitizers.add(sanitizer);
    }

    public static TooltipTarget sanitizeTarget(TooltipTarget target) {
        if (target == null) {
            return null;
        }
        for (ITargetSanitizer sanitizer : targetSanitizers) {
            target = sanitizer.sanitize(target);
        }
        return target;
    }

    public static TooltipTarget createTargetFromItemStack(ItemStack stack) {
        return TooltipRegistry.sanitizeTarget(TooltipTarget.ofItem(stack));
    }

    public static void addEnricher(ITooltipEnricher enricher) {
        tooltipEnrichers.add(enricher);
    }

    public static void addEnricherAfter(String sectionId, ITooltipEnricher enricher) {
        int index = -1;
        for (int i = 0; i < tooltipEnrichers.size(); ++i) {
            if (!tooltipEnrichers.get(i).sectionId().equalsIgnoreCase(sectionId)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            tooltipEnrichers.add(index + 1, enricher);
        } else {
            tooltipEnrichers.add(enricher);
        }
    }

    public static List<ITooltipEnricher> getEnrichers() {
        return Collections.unmodifiableList(tooltipEnrichers);
    }
}

