/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.api;

import com.slprime.chromatictooltips.TooltipHandler;
import com.slprime.chromatictooltips.TooltipRegistry;
import com.slprime.chromatictooltips.api.ITooltipComponent;
import com.slprime.chromatictooltips.api.ITooltipLineConverter;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.api.TooltipModifier;
import com.slprime.chromatictooltips.component.ParagraphComponent;
import com.slprime.chromatictooltips.component.SpaceComponent;
import com.slprime.chromatictooltips.component.TextComponent;
import com.slprime.chromatictooltips.event.TextLinesConverterEvent;
import com.slprime.chromatictooltips.util.TooltipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import net.minecraft.util.EnumChatFormatting;

public class TooltipLines {
    public static final String ALT_MODIFIER = "\u00a7!alt";
    public static final String CTRL_MODIFIER = "\u00a7!ctrl";
    public static final String SHIFT_MODIFIER = "\u00a7!shift";
    public static final EnumChatFormatting BASE_COLOR = EnumChatFormatting.GRAY;
    protected static final String HEADER_SUFFIX = "\u00a7h";
    protected static final int HEADER_SPACING = 4;
    protected final List<Object> textLines = new ArrayList<Object>();
    protected EnumSet<TooltipModifier> supportedModifiers = EnumSet.noneOf(TooltipModifier.class);

    public TooltipLines() {
    }

    public TooltipLines(Object ... components) {
        this.lines(Arrays.asList(components));
    }

    public TooltipLines(List<?> lines) {
        this.lines(lines);
    }

    public TooltipLines header(String line) {
        this.textLines.add(line + HEADER_SUFFIX);
        return this;
    }

    public TooltipLines line(ITooltipComponent line) {
        this.textLines.add(line);
        return this;
    }

    public TooltipLines line(String line) {
        this.textLines.add(line);
        return this;
    }

    public TooltipLines lines(String ... lines) {
        return this.lines(Arrays.asList(lines));
    }

    public TooltipLines lines(List<?> lines) {
        if (lines == null) {
            return this;
        }
        for (Object line : lines) {
            if (line instanceof TooltipLines) {
                TooltipLines tl = (TooltipLines)line;
                this.textLines.addAll(tl.textLines);
                this.supportedModifiers.addAll(tl.supportedModifiers);
                continue;
            }
            if (line instanceof String) {
                String str = (String)line;
                this.textLines.addAll(Arrays.asList(str.split("\n")));
                continue;
            }
            if (line == null) continue;
            this.textLines.add(line);
        }
        return this;
    }

    public TooltipLines supports(TooltipModifier ... modifiers) {
        this.supportedModifiers.addAll(Arrays.asList(modifiers));
        return this;
    }

    EnumSet<TooltipModifier> getSupportedModifiers() {
        return this.supportedModifiers;
    }

    public TooltipLines paragraph() {
        this.textLines.add("");
        return this;
    }

    public TooltipLines divider() {
        return this.divider(EnumChatFormatting.GRAY);
    }

    public TooltipLines divider(EnumChatFormatting color) {
        this.textLines.add(color + "---" + EnumChatFormatting.RESET);
        return this;
    }

    public List<ITooltipComponent> build(TooltipContext context) {
        ArrayList<ITooltipComponent> results = new ArrayList<ITooltipComponent>();
        TextLinesConverterEvent event = new TextLinesConverterEvent(context.getTarget(), this.textLines);
        TooltipUtils.postEvent(event);
        for (Object line : event.list) {
            String str;
            if (line instanceof ITooltipComponent) {
                ITooltipComponent component = (ITooltipComponent)line;
                results.add(component);
                continue;
            }
            if ("".equals(line)) {
                results.add(new ParagraphComponent());
                continue;
            }
            if (!(line instanceof String) || TooltipUtils.isBlacklistedLine(str = (String)line)) continue;
            Map.Entry<Matcher, ITooltipLineConverter> lineConverterEntry = TooltipRegistry.getLineConverter(str);
            if (lineConverterEntry != null) {
                Matcher matcher;
                ITooltipLineConverter converter = lineConverterEntry.getValue();
                ITooltipComponent convertedComponent = converter.convert(matcher = lineConverterEntry.getKey(), context);
                if (convertedComponent == null) continue;
                results.add(convertedComponent);
                continue;
            }
            if (str.endsWith(HEADER_SUFFIX)) {
                results.add(new TextComponent(TooltipUtils.applyBaseColorIfAbsent(str.substring(0, str.length() - HEADER_SUFFIX.length()), BASE_COLOR), 4));
                continue;
            }
            ITooltipComponent component = TooltipHandler.getTooltipComponent(str);
            if (component == null) {
                component = new TextComponent(TooltipUtils.applyBaseColorIfAbsent(str, BASE_COLOR));
            }
            results.add(component);
        }
        while (!results.isEmpty() && results.get(0) instanceof SpaceComponent) {
            results.remove(0);
        }
        while (!results.isEmpty() && results.get(results.size() - 1) instanceof SpaceComponent) {
            results.remove(results.size() - 1);
        }
        for (TooltipModifier modifier : this.supportedModifiers) {
            context.supportModifiers(modifier);
        }
        return results;
    }

    public boolean isEmpty() {
        return this.textLines.isEmpty();
    }

    public void clear() {
        this.textLines.clear();
    }

    public int size() {
        return this.textLines.size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TooltipLines) {
            TooltipLines other = (TooltipLines)obj;
            return TooltipLines.equalsLines(this.textLines, other.textLines);
        }
        return false;
    }

    protected static boolean equalsLines(List<?> a, List<?> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            Object bObject;
            Object aObject = a.get(i);
            if (Objects.equals(aObject, bObject = b.get(i)) || String.valueOf(aObject).equals(String.valueOf(bObject))) continue;
            return false;
        }
        return true;
    }
}

