/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.slprime.chromatictooltips.util.TooltipDecorator;
import com.slprime.chromatictooltips.util.TooltipDecoratorCollection;
import com.slprime.chromatictooltips.util.TooltipSpacing;
import java.util.ArrayList;
import java.util.function.Function;

public class TooltipStyle {
    protected static final String[][] SPACE_PROPERTY = new String[][]{{"block", "top"}, {"inline", "right"}, {"block", "bottom"}, {"inline", "left"}};
    protected JsonObject map = new JsonObject();

    public TooltipStyle() {
        this(new JsonObject());
    }

    public TooltipStyle(JsonObject map) {
        this.map = map;
    }

    public JsonElement get(String path) {
        JsonObject obj = this.map;
        for (String key : path.split("\\.")) {
            if (obj == null || !obj.isJsonObject()) {
                return null;
            }
            obj = obj.get(key);
        }
        return obj;
    }

    public boolean containsKey(String path) {
        return this.get(path) != null;
    }

    public TooltipStyle getAsStyle(String path) {
        return new TooltipStyle(this.getAsJsonObject(path, new JsonObject()));
    }

    public <T> T getAs(JsonElement element, T defaultValue, Function<JsonElement, T> parser) {
        if (element != null) {
            try {
                return parser.apply(element);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public <T> T getAs(String path, T defaultValue, Function<JsonElement, T> parser) {
        return this.getAs(this.get(path), defaultValue, parser);
    }

    public int getAsColor(String path, int defaultValue) {
        return this.getAs(path, Integer.valueOf(defaultValue), TooltipStyle::parseInt);
    }

    public int getAsInt(String path, int defaultValue) {
        return this.getAs(path, Integer.valueOf(defaultValue), (JsonElement el) -> el.getAsInt());
    }

    public boolean getAsBoolean(String path, boolean defaultValue) {
        return this.getAs(path, Boolean.valueOf(defaultValue), (JsonElement el) -> el.getAsBoolean());
    }

    public float getAsFloat(String path, float defaultValue) {
        return this.getAs(path, Float.valueOf(defaultValue), (JsonElement el) -> Float.valueOf(el.getAsFloat())).floatValue();
    }

    public long getAsLong(String path, long defaultValue) {
        return this.getAs(path, Long.valueOf(defaultValue), (JsonElement el) -> el.getAsLong());
    }

    public String getAsString(String path, String defaultValue) {
        return this.getAs(path, defaultValue, (JsonElement el) -> el.getAsString());
    }

    public String[] getAsStringArray(String path, String[] defaultValue) {
        JsonElement element = this.get(path);
        if (element != null && element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            String[] values = new String[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                values[i] = this.getAs(array.get(i), "", (JsonElement el) -> el.getAsString());
            }
            return values;
        }
        return defaultValue;
    }

    public double getAsDouble(String path, double defaultValue) {
        return this.getAs(path, Double.valueOf(defaultValue), (JsonElement el) -> el.getAsDouble());
    }

    public JsonObject getAsJsonObject(String path, JsonObject defaultValue) {
        return this.getAs(path, defaultValue, (JsonElement el) -> el.getAsJsonObject());
    }

    public JsonArray getAsJsonArray(String path, JsonArray defaultValue) {
        return this.getAs(path, defaultValue, (JsonElement el) -> el.getAsJsonArray());
    }

    public int[] getAsColors(String path, int[] defaultValue) {
        JsonElement element = this.get(path);
        if (element != null && element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            int[] values = new int[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                values[i] = this.getAs(array.get(i), Integer.valueOf(0), TooltipStyle::parseInt);
            }
            return values;
        }
        return defaultValue;
    }

    public TooltipDecoratorCollection getDecoratorCollection() {
        if (this.containsKey("decorators")) {
            JsonArray decoratorsStyle = this.getAsJsonArray("decorators", new JsonArray());
            ArrayList<TooltipDecorator> decorators = new ArrayList<TooltipDecorator>();
            for (JsonElement element : decoratorsStyle) {
                if (element == null || !element.isJsonObject()) continue;
                decorators.add(new TooltipDecorator(new TooltipStyle(element.getAsJsonObject())));
            }
            return new TooltipDecoratorCollection(decorators.toArray(new TooltipDecorator[0]));
        }
        if (this.containsKey("decorator")) {
            return new TooltipDecoratorCollection(new TooltipDecorator[]{new TooltipDecorator(this.getAsStyle("decorator"))});
        }
        return new TooltipDecoratorCollection(new TooltipDecorator[0]);
    }

    public TooltipSpacing getAsTooltipSpacing(String path, int[] defaultValue) {
        return new TooltipSpacing(this.getAsProperty(path, SPACE_PROPERTY, defaultValue));
    }

    public int[] getAsProperty(String path, String[][] keys, int[] result) {
        block8: {
            JsonElement element;
            block9: {
                block7: {
                    element = this.get(path);
                    if (element != null) break block7;
                    block0: for (int i = 0; i < keys.length; ++i) {
                        for (String key : keys[i]) {
                            key = path + key.substring(0, 1).toUpperCase() + key.substring(1);
                            if (!this.containsKey(key)) continue;
                            result[i] = this.getAsInt(key, result[i]);
                            continue block0;
                        }
                    }
                    break block8;
                }
                if (element.isJsonPrimitive()) {
                    int value = this.getAs(element, Integer.valueOf(result[0]), (JsonElement el) -> el.getAsInt());
                    for (int i = 0; i < result.length; ++i) {
                        result[i] = value;
                    }
                    return result;
                }
                if (!element.isJsonObject()) break block9;
                JsonObject obj = element.getAsJsonObject();
                block3: for (int i = 0; i < keys.length; ++i) {
                    for (String key : keys[i]) {
                        if (!obj.has(key)) continue;
                        result[i] = this.getAs(obj.get(key), Integer.valueOf(result[i]), (JsonElement el) -> el.getAsInt());
                        continue block3;
                    }
                }
                break block8;
            }
            if (!element.isJsonArray()) break block8;
            JsonArray array = element.getAsJsonArray();
            for (int i = 0; i < keys.length && i < array.size(); ++i) {
                result[i] = this.getAs(array.get(i), Integer.valueOf(result[i]), (JsonElement el) -> el.getAsInt());
            }
        }
        return result;
    }

    private static int parseInt(JsonElement element) {
        String str = element.getAsString();
        if (str.startsWith("0x")) {
            return (int)Long.parseUnsignedLong(str.substring(2), 16);
        }
        return Integer.parseInt(str);
    }

    public String toString() {
        return this.map.toString();
    }
}

