/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.component;

import com.slprime.chromatictooltips.api.ITooltipComponent;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.api.TooltipLines;
import com.slprime.chromatictooltips.util.TooltipFontContext;
import com.slprime.chromatictooltips.util.TooltipUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.EnumChatFormatting;

public class DyncamicTextComponent
implements ITooltipComponent {
    protected final Supplier<String> handler;
    protected int maxWidth = Integer.MAX_VALUE;
    protected int lineIndex = 0;
    protected int spacing = 2;

    protected DyncamicTextComponent(Supplier<String> handler, int lineIndex, int maxWidth, int spacing) {
        this.handler = handler;
        this.maxWidth = maxWidth;
        this.lineIndex = lineIndex;
        this.spacing = spacing;
    }

    public DyncamicTextComponent(Supplier<String> handler, int spacing) {
        this(handler, 0, Integer.MAX_VALUE, spacing);
    }

    public DyncamicTextComponent(Supplier<String> handler) {
        this(handler, 2);
    }

    @Override
    public int getWidth() {
        int width = 0;
        for (String line : this.generateLines(this.maxWidth)) {
            width = Math.max(width, TooltipFontContext.getStringWidth(line));
        }
        return width;
    }

    @Override
    public int getHeight() {
        return this.generateLines(this.maxWidth).size() * TooltipFontContext.getFontHeight() - this.spacing;
    }

    @Override
    public int getSpacing() {
        return this.spacing;
    }

    public Supplier<String> getHandler() {
        return this.handler;
    }

    protected List<String> generateLines(int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : this.handler.get().split("\n")) {
            lines.addAll(TooltipFontContext.listFormattedStringToWidth(line, maxWidth));
        }
        return lines;
    }

    @Override
    public ITooltipComponent[] paginate(TooltipContext context, int maxWidth, int maxHeight) {
        List<String> lines;
        int linesPerPage = Math.max(1, maxHeight / TooltipFontContext.getFontHeight());
        if (linesPerPage >= (lines = this.generateLines(maxWidth)).size()) {
            return new ITooltipComponent[]{new DyncamicTextComponent(this.handler, 0, maxWidth, this.spacing)};
        }
        return new ITooltipComponent[]{new DyncamicTextComponent(this.handler, 0, maxWidth, this.spacing), new DyncamicTextComponent(this.handler, linesPerPage, maxWidth, this.spacing)};
    }

    @Override
    public void draw(int x, int y, int availableWidth, TooltipContext context) {
        int lineHeight = TooltipFontContext.getFontHeight();
        List<String> lines = this.generateLines(this.maxWidth);
        for (int i = this.lineIndex; i < lines.size(); ++i) {
            TooltipFontContext.drawString(TooltipUtils.applyBaseColorIfAbsent(lines.get(i), TooltipLines.BASE_COLOR), x, y);
            y += lineHeight;
        }
    }

    public int hashCode() {
        return EnumChatFormatting.func_110646_a((String)this.handler.get()).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DyncamicTextComponent) {
            DyncamicTextComponent other = (DyncamicTextComponent)obj;
            return EnumChatFormatting.func_110646_a((String)this.handler.get()).equals(EnumChatFormatting.func_110646_a((String)other.handler.get()));
        }
        return false;
    }
}

