/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.component;

import com.slprime.chromatictooltips.api.ITooltipComponent;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.config.EnricherConfig;
import com.slprime.chromatictooltips.util.TooltipFontContext;
import com.slprime.chromatictooltips.util.TooltipUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class EnchantmentComponent
implements ITooltipComponent {
    private static final int ICON_SIZE = 8;
    private static final int SPACE = 3;
    private final ResourceLocation resourceLocation;
    private final int marginLeft;
    private final String title;
    private final List<String> hint;
    private int colorCodeIndex = 15;

    public EnchantmentComponent(String path, String title, List<String> hint) {
        this(new ResourceLocation(path.contains(":") ? path : "chromatictooltips:" + path), title, hint);
    }

    protected EnchantmentComponent(ResourceLocation resourceLocation, String title, List<String> hint) {
        this.hint = EnricherConfig.enchantmentHintEnabled ? hint : Collections.emptyList();
        this.colorCodeIndex = TooltipUtils.getColorCodeIndex(title);
        this.resourceLocation = resourceLocation;
        this.title = title;
        this.marginLeft = EnricherConfig.enchantmentIconsEnabled ? 11 : 0;
    }

    @Override
    public int getWidth() {
        int width = TooltipFontContext.getStringWidth(this.title);
        for (String line : this.hint) {
            width = Math.max(width, TooltipFontContext.getStringWidth(line));
        }
        return width + this.marginLeft;
    }

    @Override
    public int getHeight() {
        return (this.hint.size() + 1) * TooltipFontContext.getFontHeight() - this.getSpacing();
    }

    @Override
    public int getSpacing() {
        return 2;
    }

    @Override
    public ITooltipComponent[] paginate(TooltipContext context, int maxWidth, int maxHeight) {
        if (this.hint.isEmpty()) {
            return new ITooltipComponent[]{this};
        }
        ArrayList<String> lines = new ArrayList<String>();
        maxWidth -= this.marginLeft + TooltipFontContext.getStringWidth("  ");
        for (String line : this.hint) {
            boolean firstLine = true;
            for (String wrappedLine : TooltipFontContext.listFormattedStringToWidth(line, maxWidth)) {
                lines.add(EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC.toString() + (firstLine ? "- " : "  ") + wrappedLine);
                firstLine = false;
            }
        }
        return new ITooltipComponent[]{new EnchantmentComponent(this.resourceLocation, this.title, lines)};
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getHint() {
        return this.hint;
    }

    @Override
    public void draw(int x, int y, int availableWidth, TooltipContext context) {
        int lineHeight = TooltipFontContext.getFontHeight();
        if (EnricherConfig.enchantmentIconsEnabled) {
            this.drawIcon(x, (float)y - 0.8f);
            x += this.marginLeft;
        }
        TooltipFontContext.drawString(this.title, x, y);
        y += lineHeight;
        for (String line : this.hint) {
            TooltipFontContext.drawString(line, x, y);
            y += lineHeight;
        }
    }

    private void drawIcon(double x, double y) {
        int color = TooltipFontContext.getColor(this.colorCodeIndex);
        int shadow = TooltipFontContext.getColorShadow(this.colorCodeIndex);
        boolean hasBlend = GL11.glGetBoolean((int)3042);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        TooltipUtils.bindTexture(this.resourceLocation);
        GL11.glColor4f((float)((float)(shadow >> 16) / 255.0f), (float)((float)(shadow >> 8 & 0xFF) / 255.0f), (float)((float)(shadow & 0xFF) / 255.0f), (float)1.0f);
        this.drawQuad(x + 1.0, y + 1.0, 8.0, 8.0);
        GL11.glColor4f((float)((float)(color >> 16) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
        this.drawQuad(x, y, 8.0, 8.0);
        if (!hasBlend) {
            GL11.glDisable((int)3042);
        }
    }

    protected void drawQuad(double x, double y, double width, double height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tessellator.func_78374_a(x, y + height, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(x + width, y + height, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(x + width, y, 0.0, 1.0, 0.0);
        tessellator.func_78381_a();
    }

    public int hashCode() {
        return Objects.hash(this.title, this.hint, this.resourceLocation.func_110623_a());
    }

    public boolean equals(Object obj) {
        if (obj instanceof EnchantmentComponent) {
            EnchantmentComponent other = (EnchantmentComponent)obj;
            return this.title.equals(other.title) && this.hint.equals(other.hint) && this.resourceLocation.func_110623_a().equals(other.resourceLocation.func_110623_a());
        }
        return false;
    }
}

