/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.component;

import com.slprime.chromatictooltips.api.ITooltipComponent;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.util.TooltipFontContext;
import com.slprime.chromatictooltips.util.TooltipUtils;
import java.util.Objects;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ItemAttributeComponent
implements ITooltipComponent {
    private static final int ICON_SIZE = 8;
    private static final int SPACE = 3;
    private final ResourceLocation resourceLocation;
    private final int marginLeft = 11;
    private final String title;

    public ItemAttributeComponent(String path, String title) {
        this(new ResourceLocation(path.contains(":") ? path : "chromatictooltips:" + path), title);
    }

    protected ItemAttributeComponent(ResourceLocation resourceLocation, String title) {
        this.resourceLocation = resourceLocation;
        this.title = title;
    }

    @Override
    public int getWidth() {
        return TooltipFontContext.getStringWidth(this.title) + this.marginLeft;
    }

    @Override
    public int getHeight() {
        return TooltipFontContext.getFontHeight() - this.getSpacing();
    }

    @Override
    public int getSpacing() {
        return 2;
    }

    @Override
    public void draw(int x, int y, int availableWidth, TooltipContext context) {
        this.drawIcon(x, (float)y - 0.8f);
        TooltipFontContext.drawString(this.title, x + this.marginLeft, y);
    }

    private void drawIcon(double x, double y) {
        boolean hasBlend = GL11.glGetBoolean((int)3042);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TooltipUtils.bindTexture(this.resourceLocation);
        this.drawQuad(x, y, 8.0, 8.0);
        if (!hasBlend) {
            GL11.glDisable((int)3042);
        }
    }

    protected void drawQuad(double x, double y, double width, double height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tessellator.func_78374_a(x, y + height, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(x + width, y + height, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(x + width, y, 0.0, 1.0, 0.0);
        tessellator.func_78381_a();
    }

    public int hashCode() {
        return Objects.hash(this.title, this.resourceLocation.func_110623_a());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ItemAttributeComponent) {
            ItemAttributeComponent other = (ItemAttributeComponent)obj;
            return this.title.equals(other.title) && this.resourceLocation.func_110623_a().equals(other.resourceLocation.func_110623_a());
        }
        return false;
    }
}

