/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.component;

import com.slprime.chromatictooltips.api.ITooltipComponent;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.api.TooltipStyle;
import com.slprime.chromatictooltips.component.SpaceComponent;
import com.slprime.chromatictooltips.util.SectionBox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SectionComponent
extends SectionBox {
    protected static int parentSectionSpacing = 0;
    protected List<ITooltipComponent> components = new ArrayList<ITooltipComponent>();
    protected ITooltipComponent pendingComponent = null;
    protected String sectionId = null;

    public SectionComponent(String sectionId, SectionBox box, List<ITooltipComponent> components) {
        super(box);
        this.sectionId = sectionId;
        this.addAllComponents(components);
    }

    public SectionComponent(String sectionId, TooltipStyle style, List<ITooltipComponent> components) {
        super(style);
        this.sectionId = sectionId;
        this.addAllComponents(components);
    }

    public String getSectionId() {
        return this.sectionId;
    }

    public void clearPendingComponent() {
        this.pendingComponent = null;
    }

    public void addAllComponents(List<ITooltipComponent> components) {
        for (ITooltipComponent component : components) {
            this.addComponent(component);
        }
    }

    public void addComponent(ITooltipComponent component) {
        if (component == null) {
            return;
        }
        if (component instanceof SpaceComponent) {
            this.pendingComponent = component;
            return;
        }
        if (!this.components.isEmpty()) {
            if (this.pendingComponent != null) {
                this.components.add(this.pendingComponent);
                this.contentSize.width = Math.max(this.contentSize.width, this.pendingComponent.getWidth());
                this.contentSize.height += this.pendingComponent.getHeight();
            } else {
                this.contentSize.height += this.getEffectiveMarginAfter(this.components.get(this.components.size() - 1), component);
            }
        }
        this.components.add(component);
        this.contentSize.width = Math.max(this.contentSize.width, component.getWidth());
        this.contentSize.height += component.getHeight();
        this.pendingComponent = null;
    }

    protected int getEffectiveMarginAfter(ITooltipComponent curr, ITooltipComponent next) {
        return next == null || next instanceof SpaceComponent ? 0 : curr.getSpacing();
    }

    public List<ITooltipComponent> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    public boolean isEmpty() {
        return this.components.isEmpty();
    }

    @Override
    public ITooltipComponent[] paginate(TooltipContext context, int maxWidth, int maxHeight) {
        int parentSectionSpacing = SectionComponent.parentSectionSpacing;
        ArrayList<ITooltipComponent> firstPage = new ArrayList<ITooltipComponent>();
        ArrayList<ITooltipComponent> secondPage = new ArrayList<ITooltipComponent>();
        int componentSpacing = 0;
        int currentHeight = 0;
        maxHeight = Math.max(0, maxHeight - this.getBlock());
        maxWidth = Math.max(0, maxWidth - this.getInline());
        this.fontContext.pushContext();
        if (this.sectionSpacing >= 0) {
            SectionComponent.parentSectionSpacing = this.sectionSpacing;
        }
        for (ITooltipComponent component : this.components) {
            int remainingHeight = maxHeight - currentHeight;
            if (secondPage.isEmpty() && component instanceof SpaceComponent) {
                componentSpacing = 0;
                if (firstPage.isEmpty() || firstPage.get(firstPage.size() - 1) instanceof SpaceComponent) continue;
            }
            if (secondPage.isEmpty() && (remainingHeight > componentSpacing || firstPage.isEmpty())) {
                ITooltipComponent[] split = component.paginate(context, maxWidth, remainingHeight - componentSpacing);
                ITooltipComponent firstComponent = split[0];
                if (!this.isEmptyComponent(firstComponent)) {
                    int compHeight = firstComponent.getHeight();
                    if (firstPage.isEmpty() || remainingHeight >= compHeight + componentSpacing) {
                        currentHeight += compHeight + componentSpacing;
                        componentSpacing = firstComponent.getSpacing();
                        firstPage.add(firstComponent);
                    } else {
                        secondPage.add(firstComponent);
                    }
                }
                if (split.length <= 1 || this.isEmptyComponent(split[1])) continue;
                secondPage.add(split[1]);
                continue;
            }
            if (secondPage.isEmpty() && component instanceof SpaceComponent || this.isEmptyComponent(component)) continue;
            secondPage.add(component);
        }
        this.fontContext.popContext();
        SectionComponent.parentSectionSpacing = parentSectionSpacing;
        if (secondPage.isEmpty()) {
            return new ITooltipComponent[]{this.createInstance(context, firstPage)};
        }
        return new ITooltipComponent[]{this.createInstance(context, firstPage), this.createInstance(context, secondPage)};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isEmptyComponent(ITooltipComponent component) {
        int n;
        if (component == null) return true;
        int n2 = component.getHeight();
        if (component instanceof SectionBox) {
            SectionBox box = (SectionBox)component;
            n = box.getBlock();
        } else {
            n = 0;
        }
        if (n2 > n) return false;
        return true;
    }

    protected ITooltipComponent createInstance(TooltipContext context, List<ITooltipComponent> components) {
        SectionComponent section = new SectionComponent(this.sectionId, this, components);
        if (section.spacing < 0) {
            section.spacing = parentSectionSpacing;
        }
        return section;
    }

    @Override
    public void drawContent(int x, int y, int width, int height, TooltipContext context) {
        int size = this.components.size();
        int offsetY = 0;
        for (int i = 0; i < size; ++i) {
            ITooltipComponent component = this.components.get(i);
            component.draw(x, y + offsetY, width, context);
            offsetY += component.getHeight() + this.getEffectiveMarginAfter(component, i + 1 < size ? this.components.get(i + 1) : null);
        }
    }
}

