/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.component;

import com.slprime.chromatictooltips.api.ITooltipComponent;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.util.TooltipFontContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TextComponent
implements ITooltipComponent {
    protected List<String> textLines = new ArrayList<String>();
    protected int spacing = 2;

    public TextComponent(List<String> textLines, int spacing) {
        this.spacing = spacing;
        for (String line : textLines) {
            this.textLines.addAll(Arrays.asList(line.split("\n")));
        }
    }

    public TextComponent(List<String> textLines) {
        this(textLines, 2);
    }

    public TextComponent(String text, int spacing) {
        this(Arrays.asList(text), spacing);
    }

    public TextComponent(String text) {
        this(Arrays.asList(text));
    }

    public List<String> getLines() {
        return new ArrayList<String>(this.textLines);
    }

    @Override
    public ITooltipComponent[] paginate(TooltipContext context, int maxWidth, int maxHeight) {
        int linesPerPage = Math.max(1, maxHeight / TooltipFontContext.getFontHeight());
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : this.textLines) {
            lines.addAll(TooltipFontContext.listFormattedStringToWidth(line, maxWidth));
        }
        if (lines.size() == this.textLines.size()) {
            return new ITooltipComponent[]{this};
        }
        if (linesPerPage >= lines.size()) {
            return new ITooltipComponent[]{this.createInstance(lines)};
        }
        return new ITooltipComponent[]{this.createInstance(lines.subList(0, linesPerPage)), this.createInstance(lines.subList(linesPerPage, lines.size()))};
    }

    protected ITooltipComponent createInstance(List<String> lines) {
        return new TextComponent(lines, this.spacing);
    }

    @Override
    public int getWidth() {
        int width = 0;
        for (String line : this.textLines) {
            width = Math.max(width, TooltipFontContext.getStringWidth(line));
        }
        return width;
    }

    @Override
    public int getHeight() {
        return this.textLines.size() * TooltipFontContext.getFontHeight() - this.spacing;
    }

    @Override
    public int getSpacing() {
        return this.spacing;
    }

    @Override
    public void draw(int x, int y, int availableWidth, TooltipContext context) {
        int lineHeight = TooltipFontContext.getFontHeight();
        for (String line : this.textLines) {
            TooltipFontContext.drawString(line, x, y);
            y += lineHeight;
        }
    }

    public int hashCode() {
        return this.textLines.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TextComponent) {
            TextComponent other = (TextComponent)obj;
            return this.textLines.equals(other.textLines);
        }
        return false;
    }
}

