/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.enricher;

import com.slprime.chromatictooltips.api.EnchantmentData;
import com.slprime.chromatictooltips.api.EnricherPlace;
import com.slprime.chromatictooltips.api.ITooltipEnricher;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.api.TooltipLines;
import com.slprime.chromatictooltips.api.TooltipModifier;
import com.slprime.chromatictooltips.api.TooltipTarget;
import com.slprime.chromatictooltips.component.EnchantmentComponent;
import com.slprime.chromatictooltips.config.EnricherConfig;
import com.slprime.chromatictooltips.event.EnchantmentEnricherEvent;
import com.slprime.chromatictooltips.util.TooltipUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class EnchantmentEnricher
implements ITooltipEnricher {
    protected static final Map<EnumEnchantmentType, EnumChatFormatting> enchantmentColors = new HashMap<EnumEnchantmentType, EnumChatFormatting>();
    protected static final Map<EnumEnchantmentType, String> enchantmentIcons = new HashMap<EnumEnchantmentType, String>();

    @Override
    public String sectionId() {
        return "enchantments";
    }

    @Override
    public EnricherPlace place() {
        return EnricherPlace.BODY;
    }

    @Override
    public EnumSet<TooltipModifier> mode() {
        return EnumSet.of(TooltipModifier.NONE);
    }

    @Override
    public TooltipLines build(TooltipContext context) {
        if (!context.getTarget().isItem()) {
            return null;
        }
        List<EnchantmentData> enchantments = EnchantmentEnricher.getEnchantments(context.getTarget());
        TooltipLines enchantmentsList = new TooltipLines();
        for (EnchantmentData enchantmentData : enchantments) {
            enchantmentsList.line(this.createEnchantmentComponent(enchantmentData));
        }
        return enchantmentsList;
    }

    public static List<EnchantmentData> getEnchantments(TooltipTarget target) {
        ArrayList<EnchantmentData> enchantmentList = new ArrayList<EnchantmentData>();
        for (Map.Entry entry : EnchantmentHelper.func_82781_a((ItemStack)target.getItem()).entrySet()) {
            if (Enchantment.field_77331_b[(Integer)entry.getKey()] == null) continue;
            enchantmentList.add(new EnchantmentData((Integer)entry.getKey(), (int)((Integer)entry.getValue())));
        }
        EnchantmentEnricherEvent event = new EnchantmentEnricherEvent(target, enchantmentList);
        TooltipUtils.postEvent(event);
        Collections.sort(event.enchantments, (a, b) -> a.enchantment.field_77351_y.compareTo((Enum)b.enchantment.field_77351_y));
        for (EnchantmentData enchantmentData : event.enchantments) {
            String hintKey;
            if (!enchantmentData.hint.isEmpty() || (hintKey = enchantmentData.enchantment.func_77320_a() + ".hint").equals(StatCollector.func_74838_a((String)hintKey))) continue;
            enchantmentData.hint.add(StatCollector.func_74838_a((String)hintKey));
        }
        return event.enchantments;
    }

    protected EnchantmentComponent createEnchantmentComponent(EnchantmentData enchantmentData) {
        String icon = enchantmentIcons.getOrDefault(enchantmentData.enchantment.field_77351_y, "star");
        EnumChatFormatting color = enchantmentColors.getOrDefault(enchantmentData.enchantment.field_77351_y, EnumChatFormatting.YELLOW);
        List<String> hint = EnricherConfig.enchantmentHintEnabled ? enchantmentData.hint : Collections.emptyList();
        return new EnchantmentComponent("enchantments/" + icon + ".png", TooltipUtils.applyBaseColorIfAbsent(enchantmentData.enchantment.func_77316_c(enchantmentData.level), color), hint);
    }

    static {
        enchantmentColors.put(EnumEnchantmentType.armor, EnumChatFormatting.GOLD);
        enchantmentColors.put(EnumEnchantmentType.armor_feet, EnumChatFormatting.DARK_GREEN);
        enchantmentColors.put(EnumEnchantmentType.armor_legs, EnumChatFormatting.DARK_PURPLE);
        enchantmentColors.put(EnumEnchantmentType.armor_torso, EnumChatFormatting.LIGHT_PURPLE);
        enchantmentColors.put(EnumEnchantmentType.armor_head, EnumChatFormatting.AQUA);
        enchantmentColors.put(EnumEnchantmentType.bow, EnumChatFormatting.BLUE);
        enchantmentColors.put(EnumEnchantmentType.weapon, EnumChatFormatting.DARK_RED);
        enchantmentColors.put(EnumEnchantmentType.fishing_rod, EnumChatFormatting.DARK_AQUA);
        enchantmentColors.put(EnumEnchantmentType.digger, EnumChatFormatting.GREEN);
        enchantmentIcons.put(EnumEnchantmentType.armor, "chestplate");
        enchantmentIcons.put(EnumEnchantmentType.armor_feet, "boots");
        enchantmentIcons.put(EnumEnchantmentType.armor_legs, "leggings");
        enchantmentIcons.put(EnumEnchantmentType.armor_torso, "chestplate");
        enchantmentIcons.put(EnumEnchantmentType.armor_head, "helmet");
        enchantmentIcons.put(EnumEnchantmentType.bow, "bow");
        enchantmentIcons.put(EnumEnchantmentType.weapon, "sword");
        enchantmentIcons.put(EnumEnchantmentType.fishing_rod, "fishing");
        enchantmentIcons.put(EnumEnchantmentType.digger, "pickaxe");
    }
}

