/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.util;

import com.slprime.chromatictooltips.api.ITooltipComponent;
import java.util.IdentityHashMap;
import java.util.Map;

public class ComponentRegistry {
    private static final int ID_BITS = 12;
    private static final int ID_MASK = 4095;
    private static final int GEN_BITS = 20;
    private static final int GEN_MASK = 1048575;
    private static final int CAPACITY = 4096;
    private final ITooltipComponent[] values = new ITooltipComponent[4096];
    private final Map<ITooltipComponent, Integer> reverse = new IdentityHashMap<ITooltipComponent, Integer>(4096);
    private final int[] generation = new int[4096];
    private int cursor = 0;

    public int add(ITooltipComponent value) {
        Integer existing = this.reverse.get(value);
        if (existing != null) {
            return this.makeToken(existing);
        }
        int id = this.cursor;
        if (this.values[id] != null) {
            this.reverse.remove(this.values[id]);
            this.generation[id] = this.generation[id] + 1 & 0xFFFFF;
        }
        this.values[id] = value;
        this.reverse.put(value, id);
        this.cursor = (this.cursor + 1) % this.values.length;
        return this.makeToken(id);
    }

    public ITooltipComponent get(int token) {
        int id = token & 0xFFF;
        int gen = token >>> 12;
        if (id >= this.values.length) {
            return null;
        }
        if (this.generation[id] != gen) {
            return null;
        }
        return this.values[id];
    }

    public int getId(ITooltipComponent value) {
        Integer id = this.reverse.get(value);
        return id != null ? this.makeToken(id) : -1;
    }

    private int makeToken(int id) {
        return (this.generation[id] & 0xFFFFF) << 12 | id;
    }
}

