/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.util;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum NumberFormat {
    SI,
    E,
    POWER;

    private static final int SIGNIFICANT_DIGITS = 3;
    private static final int DIVISION_BASE = 1000;
    private static final char[] SI_POSTFIXES;
    private static final Map<Locale, DecimalFormat> decimalFormatters;
    private static final DecimalFormat SI_FORMAT;

    private static DecimalFormat getDecimalFormat() {
        return decimalFormatters.computeIfAbsent(Locale.getDefault(Locale.Category.FORMAT), locale -> {
            DecimalFormat numberFormat = new DecimalFormat();
            numberFormat.setGroupingUsed(true);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setRoundingMode(RoundingMode.HALF_UP);
            DecimalFormatSymbols decimalFormatSymbols = numberFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setGroupingSeparator(',');
            numberFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            return numberFormat;
        });
    }

    public static String formatWithCommas(double number) {
        return NumberFormat.getDecimalFormat().format(number);
    }

    public static String formatWithCommas(long number) {
        return NumberFormat.getDecimalFormat().format(number);
    }

    public String format(long number) {
        switch (this) {
            case SI: {
                return NumberFormat.toSI(number, 4);
            }
            case E: {
                return NumberFormat.toE(number);
            }
            case POWER: {
                return NumberFormat.toPower(number);
            }
        }
        return NumberFormat.getDecimalFormat().format(number);
    }

    public String format(long number, int detailCutoffPower) {
        if (number < NumberFormat.pow10(detailCutoffPower)) {
            return NumberFormat.getDecimalFormat().format(number);
        }
        return this.format(number);
    }

    private static String toE(long number) {
        if (number == 0L) {
            return "0";
        }
        int exponent = (int)Math.log10(number);
        int scale = 2;
        long divisor = NumberFormat.pow10(exponent - scale);
        long mantissaInt = number / divisor;
        long intPart = mantissaInt / NumberFormat.pow10(scale);
        long fracPart = mantissaInt % NumberFormat.pow10(scale);
        return intPart + "." + NumberFormat.padZeros(fracPart, scale) + "e" + exponent;
    }

    private static String toPower(long number) {
        if (number == 0L) {
            return "0";
        }
        int exponent = (int)Math.log10(number);
        int scale = 2;
        long divisor = NumberFormat.pow10(exponent - scale);
        long mantissaInt = number / divisor;
        long intPart = mantissaInt / NumberFormat.pow10(scale);
        long fracPart = mantissaInt % NumberFormat.pow10(scale);
        return intPart + "." + NumberFormat.padZeros(fracPart, scale) + " x 10^" + exponent;
    }

    private static long pow10(int exp) {
        long r = 1L;
        for (int i = 0; i < exp; ++i) {
            r *= 10L;
        }
        return r;
    }

    private static String padZeros(long value, int width) {
        String s = Long.toString(value);
        int missing = width - s.length();
        return missing <= 0 ? s : "000000000000000000".substring(0, missing) + s;
    }

    private static String toSI(long number, int width) {
        String numberString = Long.toString(number);
        int size = numberString.length();
        if (size <= width) {
            return numberString;
        }
        long base = number;
        double last = base * 1000L;
        int exponent = -1;
        char postfix = '\u0000';
        while (size > width && exponent + 1 < SI_POSTFIXES.length) {
            last = base;
            postfix = SI_POSTFIXES[++exponent];
            size = Long.toString(base /= 1000L).length() + 1;
        }
        String withPrecision = SI_FORMAT.format(last / 1000.0) + postfix;
        String withoutPrecision = base + String.valueOf(postfix);
        return withPrecision.length() <= width ? withPrecision : withoutPrecision;
    }

    static {
        SI_POSTFIXES = "kMGTPE".toCharArray();
        decimalFormatters = new HashMap<Locale, DecimalFormat>();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator(',');
        SI_FORMAT = new DecimalFormat(".#;0.#");
        SI_FORMAT.setDecimalFormatSymbols(symbols);
        SI_FORMAT.setRoundingMode(RoundingMode.DOWN);
    }
}

