/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.slprime.chromatictooltips.ChromaticTooltips;
import com.slprime.chromatictooltips.api.TooltipStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Parser {
    protected static final JsonParser parser = new JsonParser();
    protected JsonObject root;

    public List<TooltipStyle> parse(String json) {
        ArrayList<TooltipStyle> scopes = new ArrayList<TooltipStyle>();
        try {
            this.root = parser.parse(json).getAsJsonObject();
            if (!this.root.has("styles")) {
                JsonArray styles = new JsonArray();
                styles.add((JsonElement)(this.root.has("style") ? this.root.get("style").getAsJsonObject() : new JsonObject()));
                this.root.add("styles", (JsonElement)styles);
            }
            for (JsonElement styleElement : this.prepareJsonObject(this.root.get("styles"), new JsonObject()).getAsJsonArray()) {
                if (!styleElement.isJsonObject()) continue;
                scopes.add(new TooltipStyle(styleElement.getAsJsonObject()));
            }
        }
        catch (JsonParseException e) {
            ChromaticTooltips.LOG.error("JSON parsing error: " + e.getMessage());
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            ChromaticTooltips.LOG.error("Invalid JSON structure: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            ChromaticTooltips.LOG.error("Unexpected error during JSON parsing: " + e.getMessage());
            e.printStackTrace();
        }
        return scopes;
    }

    protected JsonElement getPath(String path, JsonElement obj) {
        for (String key : path.split("\\.")) {
            if (obj == null || !obj.isJsonObject()) {
                return JsonNull.INSTANCE;
            }
            obj = ((JsonObject)obj).get(key);
        }
        return obj == null ? JsonNull.INSTANCE : obj;
    }

    protected JsonElement prepareJsonObject(JsonElement element, JsonObject params) {
        if (element.isJsonObject()) {
            JsonElement ref;
            JsonObject object = element.getAsJsonObject();
            JsonObject result = new JsonObject();
            if (object.has("$ref") && object.get("$ref").isJsonPrimitive() && object.get("$ref").getAsJsonPrimitive().isString() && !(ref = this.getPath(object.get("$ref").getAsString(), (JsonElement)this.root)).isJsonNull()) {
                JsonObject prm = object.has("$params") ? this.prepareJsonObject((JsonElement)object.get("$params").getAsJsonObject(), params).getAsJsonObject() : new JsonObject();
                result = Parser.clone(this.prepareJsonObject(ref, prm)).getAsJsonObject();
            }
            for (Map.Entry entry : object.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                if (key.startsWith("$ref:")) {
                    String refKey = key.substring(5);
                    JsonElement refResult = null;
                    for (String ref2 : this.getRefs(value)) {
                        refResult = Parser.join(refResult, Parser.clone(this.prepareJsonObject(this.getPath(ref2, (JsonElement)this.root), params)));
                    }
                    result.add(refKey, refResult);
                    continue;
                }
                if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isString() && value.getAsString().startsWith("$param:")) {
                    String ref3 = value.getAsString().substring(7);
                    result.add(key, this.prepareJsonObject(this.getPath(ref3, (JsonElement)params), params));
                    continue;
                }
                if (key.startsWith("$")) continue;
                result.add(key, this.prepareJsonObject(value, params));
            }
            return result;
        }
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            JsonArray newArray = new JsonArray();
            for (int i = 0; i < array.size(); ++i) {
                newArray.add(this.prepareJsonObject(array.get(i), params));
            }
            return newArray;
        }
        return element;
    }

    protected String[] getRefs(JsonElement element) {
        if (element != null && element.isJsonPrimitive() && element.getAsJsonPrimitive().isString() && element.getAsString().startsWith("$")) {
            return new String[]{element.getAsString()};
        }
        if (element != null && element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            String[] refs = new String[array.size()];
            int index = 0;
            for (int i = 0; i < array.size(); ++i) {
                JsonElement e = array.get(i);
                if (e == null || !e.isJsonPrimitive() || !e.getAsJsonPrimitive().isString() || !e.getAsString().startsWith("$")) continue;
                refs[index++] = e.getAsString();
            }
            return Arrays.copyOf(refs, index);
        }
        return new String[0];
    }

    protected static JsonElement join(JsonElement a, JsonElement b) {
        if (a == null || a.isJsonNull()) {
            return b;
        }
        if (b == null || b.isJsonNull()) {
            return a;
        }
        if (a.isJsonObject() && b.isJsonObject()) {
            JsonObject result = a.getAsJsonObject();
            b.getAsJsonObject().entrySet().forEach(entry -> result.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            return result;
        }
        if (a.isJsonArray() && b.isJsonArray()) {
            JsonArray result = a.getAsJsonArray();
            result.addAll(b.getAsJsonArray());
            return result;
        }
        return b;
    }

    protected static JsonElement clone(JsonElement element) {
        return element == null ? JsonNull.INSTANCE : parser.parse(element.toString());
    }
}

