/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.slprime.chromatictooltips.api.TooltipStyle;
import com.slprime.chromatictooltips.util.TooltipAlign;
import com.slprime.chromatictooltips.util.TooltipUtils;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TooltipTexture {
    private final ResourceLocation resourceLocation;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int textureWidth;
    private final int textureHeight;
    protected Animation animation;
    protected double[][] screenTexCoords = null;
    protected int[][] inlineSlices = null;
    protected int[][] blockSlices = null;
    protected double[][] calculatedInlineSizes = null;
    protected double[][] calculatedBlockSizes = null;
    protected double lastInlineWidth;
    protected double lastBlockWidth;
    protected Repeat repeatInline;
    protected Repeat repeatBlock;

    public TooltipTexture(TooltipStyle style) {
        String path = style.getAsString("path", "textures/tooltip.png");
        this.resourceLocation = new ResourceLocation(path.contains(":") ? path : "chromatictooltips:" + path);
        TooltipUtils.bindTexture(this.resourceLocation);
        this.textureWidth = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        this.textureHeight = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        int[] region = style.getAsProperty("region", new String[][]{{"x"}, {"y"}, {"width"}, {"height"}}, new int[]{0, 0, this.textureWidth, this.textureHeight});
        this.x = region[0];
        this.y = region[1];
        this.width = region[2];
        this.height = region[3];
        if (style.containsKey("repeat") && style.get("repeat").isJsonPrimitive()) {
            this.repeatInline = this.repeatBlock = this.prepareRepeat(style.get("repeat"));
            int[][] nArrayArray = new int[][]{{this.height, 0}};
            this.blockSlices = nArrayArray;
            this.inlineSlices = nArrayArray;
        } else {
            if (style.containsKey("repeatInline")) {
                this.repeatInline = this.prepareRepeat(style.get("repeatInline"));
                this.inlineSlices = new int[][]{{this.width, 0}};
            } else if (style.containsKey("repeat.inline")) {
                this.repeatInline = this.prepareRepeat(style.get("repeat.inline"));
                this.inlineSlices = new int[][]{{this.width, 0}};
            } else {
                this.inlineSlices = style.get("slice") != null && style.get("slice").isJsonArray() ? this.prepareTextureSlice(style.getAsJsonArray("slice", new JsonArray()), this.width) : (style.get("sliceInline") != null && style.get("sliceInline").isJsonArray() ? this.prepareTextureSlice(style.getAsJsonArray("sliceInline", new JsonArray()), this.width) : this.prepareTextureSlice(style.getAsJsonArray("slice.inline", new JsonArray()), this.width));
            }
            if (style.containsKey("repeatBlock")) {
                this.repeatBlock = this.prepareRepeat(style.get("repeatBlock"));
                this.blockSlices = new int[][]{{this.height, 0}};
            } else if (style.containsKey("repeat.block")) {
                this.repeatBlock = this.prepareRepeat(style.get("repeat.block"));
                this.blockSlices = new int[][]{{this.height, 0}};
            } else {
                this.blockSlices = style.get("slice") != null && style.get("slice").isJsonArray() ? this.prepareTextureSlice(style.getAsJsonArray("slice", new JsonArray()), this.height) : (style.get("sliceBlock") != null && style.get("sliceBlock").isJsonArray() ? this.prepareTextureSlice(style.getAsJsonArray("sliceBlock", new JsonArray()), this.height) : this.prepareTextureSlice(style.getAsJsonArray("slice.block", new JsonArray()), this.height));
            }
        }
        if (style.containsKey("animation")) {
            this.prepareAnimation(style.getAsStyle("animation"));
        }
    }

    protected void prepareAnimation(TooltipStyle style) {
        this.animation = new Animation();
        int frametime = style.getAsInt("frametime", 1);
        JsonArray frames = style.getAsJsonArray("frames", new JsonArray());
        int maxFrames = this.textureHeight / this.height;
        if (frames.size() > 0) {
            this.animation.frameTimes = new int[frames.size()];
            this.animation.frameIndices = new int[frames.size()];
            for (int i = 0; i < frames.size(); ++i) {
                if (frames.get(i).isJsonObject()) {
                    this.animation.frameIndices[i] = frames.get(i).getAsJsonObject().get("index").getAsInt();
                    this.animation.frameTimes[i] = frames.get(i).getAsJsonObject().get("time").getAsInt();
                    continue;
                }
                this.animation.frameIndices[i] = frames.get(i).getAsInt();
                this.animation.frameTimes[i] = frametime;
            }
        } else if (style.getAsBoolean("framePingPong", false)) {
            this.animation.frameTimes = new int[maxFrames * 2];
            this.animation.frameIndices = new int[maxFrames * 2];
            for (int i = 0; i < maxFrames; ++i) {
                this.animation.frameTimes[i] = frametime;
                this.animation.frameIndices[i] = i;
                this.animation.frameTimes[maxFrames - 1 - i] = frametime;
                this.animation.frameIndices[maxFrames - 1 - i] = i;
            }
        } else {
            this.animation.frameTimes = new int[maxFrames];
            this.animation.frameIndices = new int[maxFrames];
            for (int i = 0; i < maxFrames; ++i) {
                this.animation.frameTimes[i] = frametime;
                this.animation.frameIndices[i] = i;
            }
        }
        if (this.animation.frameIndices.length <= 1) {
            this.animation = null;
        }
    }

    protected Repeat prepareRepeat(JsonElement props) {
        if (props.isJsonPrimitive() && props.getAsJsonPrimitive().isBoolean()) {
            if (props.getAsBoolean()) {
                return new Repeat(Integer.MAX_VALUE, 0, RepeatFit.FLOOR);
            }
            return new Repeat(1, 0, RepeatFit.FLOOR);
        }
        if (props.isJsonPrimitive() && props.getAsJsonPrimitive().isNumber()) {
            return new Repeat(props.getAsInt(), 0, RepeatFit.FLOOR);
        }
        if (props.isJsonPrimitive() && props.getAsJsonPrimitive().isString()) {
            return new Repeat(Integer.MAX_VALUE, 0, RepeatFit.fromString(props.getAsString()));
        }
        if (props.isJsonObject()) {
            JsonObject obj = props.getAsJsonObject();
            int limit = obj.has("limit") ? obj.get("limit").getAsInt() : Integer.MAX_VALUE;
            int gap = obj.has("gap") ? obj.get("gap").getAsInt() : 0;
            RepeatFit fit = obj.has("fit") ? RepeatFit.fromString(obj.get("fit").getAsString()) : RepeatFit.FLOOR;
            return new Repeat(limit, gap, fit);
        }
        return null;
    }

    protected int[][] prepareTextureSlice(JsonArray style, int defaultSize) {
        int[][] result = new int[style.size()][2];
        int resultIndex = 0;
        for (int i = 0; i < result.length; ++i) {
            JsonElement element = style.get(i);
            int base = 0;
            int grow = 0;
            if (element.isJsonObject()) {
                JsonObject slice = element.getAsJsonObject();
                if (slice.has("base")) {
                    base = slice.get("base").getAsInt();
                    grow = this.getSliceProperty(slice, "grow", 0, 1);
                }
            } else if (element.isJsonPrimitive()) {
                if (element.getAsJsonPrimitive().isNumber()) {
                    base = element.getAsInt();
                } else if (element.getAsJsonPrimitive().isBoolean()) {
                    grow = element.getAsBoolean() ? 1 : 0;
                }
            }
            result[resultIndex++] = new int[]{base, grow};
        }
        if (resultIndex == 0) {
            return new int[][]{{defaultSize, 1}};
        }
        if (resultIndex != result.length) {
            int[][] resized = new int[resultIndex][2];
            System.arraycopy(result, 0, resized, 0, resultIndex);
            return resized;
        }
        return result;
    }

    private int getSliceProperty(JsonObject slice, String key, int minValue, int boolValue) {
        if (slice.has(key) && slice.get(key).isJsonPrimitive()) {
            if (slice.get(key).getAsJsonPrimitive().isNumber()) {
                return Math.max(minValue, slice.get(key).getAsInt());
            }
            if (slice.get(key).getAsJsonPrimitive().isBoolean()) {
                return slice.get(key).getAsBoolean() ? boolValue : minValue;
            }
        }
        return minValue;
    }

    protected double[][] calculateTextureSlices(int[][] slices, double screenSize) {
        double[][] result = new double[slices.length][4];
        int resultIndex = 0;
        double fixedSize = 0.0;
        int growCount = 0;
        for (int i = 0; i < slices.length; ++i) {
            if (slices[i][1] == 0) {
                fixedSize += (double)slices[i][0];
                continue;
            }
            growCount += slices[i][1];
        }
        double growStep = growCount > 0 ? (screenSize - fixedSize) / (double)growCount : 0.0;
        double lastScreenShift = 0.0;
        double lastTexShift = 0.0;
        for (int i = 0; i < slices.length; ++i) {
            if (slices[i][1] == 0) {
                result[resultIndex][0] = lastScreenShift;
                result[resultIndex][1] = slices[i][0];
                result[resultIndex][2] = lastTexShift;
                result[resultIndex][3] = slices[i][0];
                lastScreenShift += result[resultIndex][1];
                ++resultIndex;
            } else {
                if ((double)slices[i][1] * growStep > 0.0) {
                    result[resultIndex][0] = lastScreenShift;
                    result[resultIndex][1] = (double)slices[i][1] * growStep;
                    result[resultIndex][2] = lastTexShift;
                    result[resultIndex][3] = slices[i][0];
                    ++resultIndex;
                }
                lastScreenShift += (double)slices[i][1] * growStep;
            }
            lastTexShift += (double)slices[i][0];
        }
        if (resultIndex != result.length) {
            double[][] resized = new double[resultIndex][4];
            System.arraycopy(result, 0, resized, 0, resultIndex);
            return resized;
        }
        return result;
    }

    protected int getRepeatCount(Repeat repeat, double texSize, double screenSize) {
        double repeatCount = (screenSize + (double)repeat.gap) / (texSize + (double)repeat.gap);
        if (repeat.fit == RepeatFit.FLOOR || repeat.fit == RepeatFit.STRETCH) {
            repeatCount = Math.floor(repeatCount);
        } else if (repeat.fit == RepeatFit.CEIL || repeat.fit == RepeatFit.CLIP) {
            repeatCount = Math.ceil(repeatCount);
        }
        return (int)Math.max(1.0, Math.min(repeatCount, (double)repeat.limit));
    }

    protected double[][] calculateTextureRepeat(double screenSize, double texSize, Repeat repeat, TooltipAlign align) {
        int repeatCount = this.getRepeatCount(repeat, texSize, screenSize);
        double[][] sizes = new double[repeatCount][4];
        double spaceBefore = 0.0;
        double spaceAfter = 0.0;
        if (align == TooltipAlign.START) {
            spaceAfter = Math.abs(screenSize - ((double)repeatCount * texSize + (double)((repeatCount - 1) * repeat.gap)));
        } else if (align == TooltipAlign.CENTER) {
            spaceBefore = spaceAfter = Math.abs((screenSize - ((double)repeatCount * texSize + (double)((repeatCount - 1) * repeat.gap))) / 2.0);
        } else if (align == TooltipAlign.END) {
            spaceBefore = Math.abs(screenSize - ((double)repeatCount * texSize + (double)((repeatCount - 1) * repeat.gap)));
        }
        if (repeat.fit == RepeatFit.CLIP) {
            double lastScreenShift = 0.0;
            sizes[0][0] = 0.0;
            sizes[0][1] = Math.max(0.0, texSize - spaceBefore);
            sizes[0][2] = spaceBefore;
            sizes[0][3] = sizes[0][1];
            lastScreenShift += sizes[0][1] + (double)repeat.gap;
            for (int i = 1; i < repeatCount - 1; ++i) {
                sizes[i][0] = lastScreenShift;
                sizes[i][1] = texSize;
                sizes[i][2] = 0.0;
                sizes[i][3] = texSize;
                lastScreenShift += sizes[i][1] + (double)repeat.gap;
            }
            if (repeatCount > 1) {
                sizes[repeatCount - 1][0] = lastScreenShift;
                sizes[repeatCount - 1][1] = Math.max(0.0, texSize - spaceAfter);
                sizes[repeatCount - 1][2] = 0.0;
                sizes[repeatCount - 1][3] = sizes[repeatCount - 1][1];
            }
        } else {
            double lastScreenShift = spaceBefore;
            for (int i = 0; i < repeatCount; ++i) {
                sizes[i][0] = lastScreenShift;
                sizes[i][1] = texSize;
                sizes[i][2] = 0.0;
                sizes[i][3] = texSize;
                lastScreenShift += sizes[i][1] + (double)repeat.gap;
            }
        }
        return sizes;
    }

    public double getWidth(double width) {
        if (this.repeatInline != null) {
            if (this.repeatInline.fit == RepeatFit.FLOOR) {
                return Math.floor((width + (double)this.repeatInline.gap) / (double)(this.width + this.repeatInline.gap)) * (double)this.width;
            }
            if (this.repeatInline.fit == RepeatFit.CEIL) {
                return Math.ceil((width + (double)this.repeatInline.gap) / (double)(this.width + this.repeatInline.gap)) * (double)this.width;
            }
            return width;
        }
        double fixedSize = 0.0;
        boolean hasGrow = false;
        for (int i = 0; i < this.inlineSlices.length; ++i) {
            if (this.inlineSlices[i][1] == 0) {
                fixedSize += (double)this.inlineSlices[i][0];
                continue;
            }
            hasGrow = true;
            break;
        }
        return hasGrow ? width : fixedSize;
    }

    public double getHeight(double height) {
        if (this.repeatBlock != null) {
            if (this.repeatBlock.fit == RepeatFit.FLOOR) {
                return Math.floor((height + (double)this.repeatBlock.gap) / (double)(this.height + this.repeatBlock.gap)) * (double)this.height;
            }
            if (this.repeatBlock.fit == RepeatFit.CEIL) {
                return Math.ceil((height + (double)this.repeatBlock.gap) / (double)(this.height + this.repeatBlock.gap)) * (double)this.height;
            }
            return height;
        }
        double fixedSize = 0.0;
        boolean hasGrow = false;
        for (int i = 0; i < this.blockSlices.length; ++i) {
            if (this.blockSlices[i][1] == 0) {
                fixedSize += (double)this.blockSlices[i][0];
                continue;
            }
            hasGrow = true;
            break;
        }
        return hasGrow ? height : fixedSize;
    }

    public void draw(double x, double y, double width, double height, TooltipAlign alignInline, TooltipAlign alignBlock, int mixColor) {
        boolean hasBlend = GL11.glGetBoolean((int)3042);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)(mixColor >> 16 & 0xFF), (float)(mixColor >> 8 & 0xFF), (float)(mixColor & 0xFF), (float)(mixColor >> 24 & 0xFF));
        TooltipUtils.bindTexture(this.resourceLocation);
        if (this.calculatedInlineSizes == null || this.lastInlineWidth != width) {
            this.calculatedInlineSizes = this.repeatInline != null ? this.calculateTextureRepeat(width, this.width, this.repeatInline, alignInline) : this.calculateTextureSlices(this.inlineSlices, width);
            this.lastInlineWidth = width;
        }
        if (this.calculatedBlockSizes == null || this.lastBlockWidth != height) {
            this.calculatedBlockSizes = this.repeatBlock != null ? this.calculateTextureRepeat(height, this.height, this.repeatBlock, alignBlock) : this.calculateTextureSlices(this.blockSlices, height);
            this.lastBlockWidth = height;
        }
        this.drawTexture(x, y, width, height);
        if (!hasBlend) {
            GL11.glDisable((int)3042);
        }
    }

    protected void drawTexture(double x, double y, double width, double height) {
        if (this.animation == null) {
            this.drawTextureSlice(x, y, width, height, this.x, this.y);
        } else {
            int frameIndex = this.animation.currentFrameIndex;
            if ((System.currentTimeMillis() - this.animation.lastFrameTime) / 50L > (long)this.animation.frameTimes[frameIndex]) {
                if (++frameIndex >= this.animation.frameIndices.length) {
                    frameIndex = 0;
                }
                this.animation.currentFrameIndex = frameIndex;
                this.animation.lastFrameTime = System.currentTimeMillis();
            }
            int frameY = this.animation.frameIndices[frameIndex] * this.height;
            this.drawTextureSlice(x, y, width, height, this.x, this.y + frameY);
        }
    }

    protected void drawTextureSlice(double x, double y, double width, double height, int xTexture, int yTexture) {
        for (double[] inline : this.calculatedInlineSizes) {
            if (inline[1] <= 0.0 || inline[3] <= 0.0) continue;
            for (double[] block : this.calculatedBlockSizes) {
                if (block[1] <= 0.0 || block[3] <= 0.0) continue;
                this.drawQuad(x + inline[0], y + block[0], inline[1], block[1], (double)xTexture + inline[2], (double)yTexture + block[2], (double)xTexture + inline[2] + inline[3], (double)yTexture + block[2] + block[3]);
            }
        }
    }

    protected void drawQuad(double x, double y, double width, double height, double x1Texture, double y1Texture, double x2Texture, double y2Texture) {
        double uMin = x1Texture / (double)this.textureWidth;
        double vMin = y1Texture / (double)this.textureHeight;
        double uMax = x2Texture / (double)this.textureWidth;
        double vMax = y2Texture / (double)this.textureHeight;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x, y, 0.0, uMin, vMin);
        tessellator.func_78374_a(x, y + height, 0.0, uMin, vMax);
        tessellator.func_78374_a(x + width, y + height, 0.0, uMax, vMax);
        tessellator.func_78374_a(x + width, y, 0.0, uMax, vMin);
        tessellator.func_78381_a();
    }

    protected class Repeat {
        public int limit = Integer.MAX_VALUE;
        public int gap = 0;
        public RepeatFit fit = RepeatFit.FLOOR;

        public Repeat(int limit, int gap, RepeatFit fit) {
            this.limit = limit;
            this.gap = gap;
            this.fit = fit;
        }
    }

    protected static class Animation {
        public long lastFrameTime = System.currentTimeMillis();
        public int currentFrameIndex = 0;
        public int[] frameTimes;
        public int[] frameIndices;

        protected Animation() {
        }
    }

    protected static enum RepeatFit {
        FLOOR,
        CEIL,
        CLIP,
        STRETCH;


        public static RepeatFit fromString(String str) {
            if ("floor".equalsIgnoreCase(str)) {
                return FLOOR;
            }
            if ("ceil".equalsIgnoreCase(str)) {
                return CEIL;
            }
            if ("clip".equalsIgnoreCase(str)) {
                return CLIP;
            }
            if ("stretch".equalsIgnoreCase(str)) {
                return STRETCH;
            }
            return FLOOR;
        }
    }
}

