/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.slprime.chromatictooltips.api.TooltipStyle;
import com.slprime.chromatictooltips.config.GeneralConfig;
import com.slprime.chromatictooltips.util.TransformFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.lwjgl.opengl.GL11;

public class TooltipTransform {
    protected static final Map<String, Function<Float, Float>> TIMING_FUNCTIONS = new HashMap<String, Function<Float, Float>>();
    protected float delay = 0.0f;
    protected float duration = 1000.0f;
    protected int iterationCount = 1;
    protected Function<Float, Float> timingFunction;
    protected boolean pingPong = false;
    protected List<Keyframe> keyframes = new ArrayList<Keyframe>();
    protected Origin originInline = Origin.CENTER;
    protected Origin originBlock = Origin.CENTER;

    public TooltipTransform(TooltipStyle transformStyle) {
        this.delay = transformStyle.getAsFloat("delay", 0.0f);
        this.duration = transformStyle.getAsFloat("duration", 1000.0f);
        this.iterationCount = transformStyle.getAsInt("iterationCount", 1);
        this.pingPong = transformStyle.getAsBoolean("pingPong", false);
        this.timingFunction = TIMING_FUNCTIONS.getOrDefault(transformStyle.getAsString("function", "linear"), TIMING_FUNCTIONS.get("linear"));
        for (JsonElement e : transformStyle.getAsJsonArray("keyframes", new JsonArray())) {
            if (e == null || !e.isJsonObject()) continue;
            TooltipStyle keyframeStyle = new TooltipStyle(e.getAsJsonObject());
            this.keyframes.add(new Keyframe(keyframeStyle.getAsInt("progress", 0), keyframeStyle.getAsFloat("translateX", 0.0f), keyframeStyle.getAsFloat("translateY", 0.0f), keyframeStyle.getAsFloat("scale", 1.0f), keyframeStyle.getAsFloat("rotate", 0.0f)));
        }
        this.originInline = Origin.fromString(transformStyle.getAsString("originInline", transformStyle.getAsString("origin.inline", "center")));
        this.originBlock = Origin.fromString(transformStyle.getAsString("originBlock", transformStyle.getAsString("origin.block", "center")));
        if (this.keyframes.isEmpty() || this.keyframes.get((int)(this.keyframes.size() - 1)).progress != 100) {
            this.keyframes.add(Keyframe.LAST_KEYFRAME);
        }
    }

    public boolean isAnimated() {
        return !GeneralConfig.transformDisabled && this.keyframes.size() > 1;
    }

    public void pushTransformMatrix(double x, double y, double width, double height, long lastFrameTime) {
        GL11.glPushMatrix();
        Keyframe frame = this.getCurrentKeyframe(lastFrameTime);
        double originX = width * this.originInline.value;
        double originY = height * this.originBlock.value;
        GL11.glTranslated((double)(x + (double)frame.translateX), (double)(y + (double)frame.translateY), (double)0.0);
        GL11.glTranslated((double)originX, (double)originY, (double)0.0);
        if (frame.scale != 1.0f) {
            GL11.glScalef((float)frame.scale, (float)frame.scale, (float)1.0f);
        }
        if (frame.rotate != 0.0f) {
            GL11.glRotated((double)frame.rotate, (double)0.0, (double)0.0, (double)1.0);
        }
        GL11.glTranslated((double)(-originX), (double)(-originY), (double)0.0);
    }

    public void popTransformMatrix() {
        GL11.glPopMatrix();
    }

    public Keyframe getCurrentKeyframe(long lastFrameTime) {
        float time = (float)(System.currentTimeMillis() - lastFrameTime) - this.delay;
        if (time < 0.0f) {
            return this.keyframes.get(0);
        }
        time = this.computeTimeFraction(time);
        Keyframe a = this.keyframes.get(0);
        Keyframe b = this.keyframes.get(this.keyframes.size() - 1);
        for (int i = 0; i < this.keyframes.size() - 1; ++i) {
            if (!(time >= (float)this.keyframes.get((int)i).progress) || !(time <= (float)this.keyframes.get((int)(i + 1)).progress)) continue;
            a = this.keyframes.get(i);
            b = this.keyframes.get(i + 1);
            break;
        }
        float local = (time - (float)a.progress) / (float)Math.max(1, b.progress - a.progress);
        if (this.timingFunction != null) {
            local = this.timingFunction.apply(Float.valueOf(local)).floatValue();
        }
        return new Keyframe((int)time, this.lerp(a.translateX, b.translateX, local), this.lerp(a.translateY, b.translateY, local), this.lerp(a.scale, b.scale, local), this.lerp(a.rotate, b.rotate, local));
    }

    private float computeTimeFraction(float time) {
        time /= this.duration;
        if (this.iterationCount > 0 && time >= (float)this.iterationCount) {
            return this.iterationCount % 2 == 1 ? 100.0f : 0.0f;
        }
        int intTime = (int)time;
        time = this.pingPong && intTime % 2 == 1 ? 1.0f - (time - (float)intTime) : (time -= (float)intTime);
        return time * 100.0f;
    }

    private float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    static {
        TIMING_FUNCTIONS.put("linear", TransformFunction::linear);
        TIMING_FUNCTIONS.put("easeIn", TransformFunction::ease);
        TIMING_FUNCTIONS.put("easeIn", TransformFunction::easeIn);
        TIMING_FUNCTIONS.put("easeOut", TransformFunction::easeOut);
        TIMING_FUNCTIONS.put("easeInOut", TransformFunction::easeInOut);
    }

    protected static enum Origin {
        START(0.0),
        CENTER(0.5),
        END(1.0);

        protected final double value;

        private Origin(double value) {
            this.value = value;
        }

        public static Origin fromString(String str) {
            switch (str.toLowerCase()) {
                case "start": 
                case "left": 
                case "top": {
                    return START;
                }
                case "center": {
                    return CENTER;
                }
                case "end": 
                case "right": 
                case "bottom": {
                    return END;
                }
            }
            return START;
        }
    }

    public static class Keyframe {
        public static final Keyframe LAST_KEYFRAME = new Keyframe(100, 0.0f, 0.0f, 1.0f, 0.0f);
        public final int progress;
        public final float translateX;
        public final float translateY;
        public final float scale;
        public final float rotate;

        public Keyframe(int progress, float translateX, float translateY, float scale, float rotate) {
            this.progress = progress;
            this.translateX = translateX;
            this.translateY = translateY;
            this.scale = scale;
            this.rotate = rotate;
        }
    }
}

