/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.util;

import com.slprime.chromatictooltips.api.TooltipModifier;
import com.slprime.chromatictooltips.config.GeneralConfig;
import cpw.mods.fml.common.eventhandler.Event;
import java.awt.Point;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class TooltipUtils {
    protected static String[] tooltipBlacklistLines;
    protected static Predicate<String> tooltipBlacklistLinesPattern;
    protected static final Pattern COLOR_CODES_PATTERN;
    private static final int ALT_HASH = 0x8000000;
    private static final int SHIFT_HASH = 0x4000000;
    private static final int CTRL_HASH = 0x2000000;
    private static final GuiHook gui;

    public static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        TooltipUtils.mc().func_110434_K().func_110577_a(resourceLocation);
    }

    public static String translate(String key, Object ... params) {
        return StatCollector.func_74837_a((String)("chromatictooltips." + key), (Object[])params);
    }

    public static boolean postEvent(Event event) {
        return MinecraftForge.EVENT_BUS.post(event);
    }

    public static GuiContainer getGuiContainer() {
        GuiContainer gui;
        GuiScreen guiScreen = TooltipUtils.mc().field_71462_r;
        return guiScreen instanceof GuiContainer ? (gui = (GuiContainer)guiScreen) : null;
    }

    public static InventoryPlayer getPlayerInventory() {
        EntityClientPlayerMP thePlayer = TooltipUtils.mc().field_71439_g;
        return thePlayer == null ? null : thePlayer.field_71071_by;
    }

    public static void incZLevel(float delta) {
        gui.incZLevel(delta);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)delta);
    }

    public static RenderItem getItemRenderer() {
        return gui.getItemRenderer();
    }

    public static Point getMousePosition() {
        ScaledResolution res = TooltipUtils.getScaledResolution();
        Minecraft mc = TooltipUtils.mc();
        return new Point(Mouse.getX() * res.func_78326_a() / mc.field_71443_c, res.func_78328_b() - Mouse.getY() * res.func_78328_b() / mc.field_71440_d - 1);
    }

    public static ScaledResolution getScaledResolution() {
        Minecraft mc = TooltipUtils.mc();
        return new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
    }

    public static int getTooltipScale() {
        return Math.max(1, TooltipUtils.getScaledResolution().func_78325_e() + GeneralConfig.scaleFactor);
    }

    public static TooltipModifier getActiveModifier() {
        if (TooltipUtils.isShiftKeyDown()) {
            return TooltipModifier.SHIFT;
        }
        if (TooltipUtils.isCtrlKeyDown()) {
            return TooltipModifier.CTRL;
        }
        if (TooltipUtils.isAltKeyDown()) {
            return TooltipModifier.ALT;
        }
        return TooltipModifier.NONE;
    }

    public static String applyBaseColorIfAbsent(String str, EnumChatFormatting baseColor) {
        if (!COLOR_CODES_PATTERN.matcher(str).find()) {
            return baseColor + str;
        }
        return str;
    }

    public static int getColorCodeIndex(String str) {
        Matcher matcher = COLOR_CODES_PATTERN.matcher(str);
        if (matcher.matches()) {
            return "0123456789abcdef".indexOf(matcher.group(1).toLowerCase());
        }
        return 15;
    }

    public static boolean isBlacklistedLine(String line) {
        if (GeneralConfig.tooltipBlacklistLines.length == 0) {
            return false;
        }
        if (tooltipBlacklistLines != GeneralConfig.tooltipBlacklistLines) {
            tooltipBlacklistLines = GeneralConfig.tooltipBlacklistLines;
            tooltipBlacklistLinesPattern = ln -> false;
            for (int i = 0; i < tooltipBlacklistLines.length; ++i) {
                String rule = tooltipBlacklistLines[i];
                try {
                    Pattern pattern = Pattern.compile(rule, 66);
                    tooltipBlacklistLinesPattern = tooltipBlacklistLinesPattern.or(ln -> pattern.matcher((CharSequence)ln).find());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return tooltipBlacklistLinesPattern.test(EnumChatFormatting.func_110646_a((String)line));
    }

    public static boolean isAltKeyDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static boolean isCtrlKeyDown() {
        if (Minecraft.field_142025_a) {
            return Keyboard.isKeyDown((int)219) || Keyboard.isKeyDown((int)220);
        }
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static int getMetaHash() {
        int hash = 0;
        if (TooltipUtils.isAltKeyDown()) {
            hash |= 0x8000000;
        }
        if (TooltipUtils.isShiftKeyDown()) {
            hash |= 0x4000000;
        }
        if (TooltipUtils.isCtrlKeyDown()) {
            hash |= 0x2000000;
        }
        return hash;
    }

    static {
        COLOR_CODES_PATTERN = Pattern.compile("^\\s*\u00a7([0-9A-F]).*", 2);
        gui = new GuiHook();
    }

    private static class GuiHook
    extends GuiScreen {
        private GuiHook() {
        }

        public void incZLevel(float f) {
            this.field_73735_i += f;
        }

        public RenderItem getItemRenderer() {
            return field_146296_j;
        }
    }
}

