/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltipscompat.event;

import codechicken.nei.util.ItemStackKey;
import com.slprime.chromatictooltips.util.TooltipUtils;
import com.slprime.chromatictooltipscompat.CompatConfig;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class CompatHander {
    private static final List<TooltipLineModifier> TOOLTIPS = new ArrayList<TooltipLineModifier>();
    private static final Map<ItemStackKey, Set<TooltipLineModifier>> MODIFIERS = new HashMap<ItemStackKey, Set<TooltipLineModifier>>();

    public static void registerHandler() {
        CompatHander instance = new CompatHander();
        FMLCommonHandler.instance().bus().register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    public static void reload() {
        String ctrl2;
        String ctrl1;
        String alt2;
        String alt1;
        String shift2;
        String shift1;
        TOOLTIPS.clear();
        if (CompatConfig.gregtechEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("mbdesc.signAndFinalize.todisplay"), "\u00a7!shift"));
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("gt.behaviour.paintspray.infinite.tooltip.more_info"), "\u00a7!shift"));
        }
        if (CompatConfig.appliedEnergisticsEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("gui.appliedenergistics2.HoldShift"), "\u00a7!shift"));
        }
        if (CompatConfig.tinkersConstructEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("tooltip.shiftprompt"), "\u00a7!shift"));
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocalFormatted("tictooltips.hold.key.for.materials", "Ctrl"), "\u00a7!ctrl"));
        }
        if (CompatConfig.ae2fcEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("ae2fc.tooltip.ctrl_for_more"), "\u00a7!ctrl"));
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("ae2fc.tooltip.shift_for_more"), "\u00a7!shift"));
        }
        if (CompatConfig.ae2wctEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("gui.tooltips.ae2wct.PressShift"), "\u00a7!shift"));
        }
        if (CompatConfig.forestryEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("for.gui.tooltip.tmi"), "\u00a7!ctrl"));
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("for.gui.tooltip.tml"), "\u00a7!shift"));
        }
        if (CompatConfig.backpackEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("tooltip.more_information"), "\u00a7!shift"));
        }
        if (CompatConfig.binnieCoreEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("botany.item.tooltip.holdMore"), "\u00a7!shift"));
        }
        if (CompatConfig.logisticsPipesEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("misc.holdshift"), "\u00a7!shift"));
        }
        if (CompatConfig.thaumicenergisticsEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("thaumicenergistics.tooltip.itemstack.details"), "\u00a7!shift"));
        }
        if (CompatConfig.supersolarpanelEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("supsolpans.all.PressShift"), "\u00a7!shift"));
        }
        if (CompatConfig.gendustryEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("gendustry.label.shift"), "\u00a7!shift"));
        }
        if (CompatConfig.emtEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("emt.PressShift"), "\u00a7!shift"));
        }
        if (CompatConfig.AWWayofTimeEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("tooltip.ritualdiviner.moreinfo"), "\u00a7!shift"));
        }
        if (CompatConfig.storageDrawersEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("storageDrawers.drawers.sealed.descriptionShift"), "\u00a7!shift"));
        }
        if (CompatConfig.modularUIEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("modularui.tooltip.shift"), "\u00a7!shift"));
        }
        if (CompatConfig.modularUI2Enabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("modularui2.tooltip.shift"), "\u00a7!shift"));
        }
        if (CompatConfig.sfmEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("gui.sfm.TooltipExtraInfo"), "\u00a7!shift"));
        }
        if (CompatConfig.enderCoreEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("endercore.tooltip.showDetails"), "\u00a7!shift"));
        }
        if (CompatConfig.bloodArsenalEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("tooltip.shiftinfo"), "\u00a7!shift"));
        }
        if (CompatConfig.avaritiaEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("tooltip.matter_cluster.desc2"), "\u00a7!shift"));
        }
        if (CompatConfig.baublesEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("tooltip.shiftprompt"), "\u00a7!shift"));
        }
        if (CompatConfig.holoinventoryEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("hologlasses.tooltip.hold_shift"), "\u00a7!shift"));
        }
        if (CompatConfig.akashictomeEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("akashictome.misc.shiftForInfo"), "\u00a7!shift"));
        }
        if (CompatConfig.botaniaEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("botaniamisc.shiftinfo"), "\u00a7!shift"));
        }
        if (CompatConfig.spiceoflifeEnabled) {
            String moreinfo = CompatHander.translateToLocalFormatted("spiceoflife.tooltip.hold.key.for.details", "Shift");
            TOOLTIPS.add(new TooltipLineModifier(moreinfo, "\u00a7!shift"));
        }
        if (CompatConfig.adventurebackpackEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("adventurebackpack:tooltips.hold.shift"), "\u00a7!shift"));
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("adventurebackpack:tooltips.hold.ctrl"), "\u00a7!ctrl"));
        }
        if (CompatConfig.draconicEvolutionEnabled) {
            String ctrlinfo = CompatHander.translateToLocal("info.de.hold.txt") + " " + CompatHander.translateToLocal("info.de.ctrl.txt") + " " + CompatHander.translateToLocal("info.de.forUpgrades.txt");
            String shiftinfo = CompatHander.translateToLocal("info.de.hold.txt") + " " + CompatHander.translateToLocal("info.de.shift.txt") + " " + CompatHander.translateToLocal("info.de.forDetails.txt");
            TOOLTIPS.add(new TooltipLineModifier(shiftinfo, "\u00a7!shift"));
            TOOLTIPS.add(new TooltipLineModifier(ctrlinfo, "\u00a7!ctrl"));
        }
        if (CompatConfig.galacticraftcoreEnabled) {
            shift1 = CompatHander.translateToLocalFormatted("itemDesc.shift.name", GameSettings.func_74298_c((int)42));
            shift2 = CompatHander.translateToLocalFormatted("itemDesc.shift.name", GameSettings.func_74298_c((int)54));
            alt1 = CompatHander.translateToLocalFormatted("itemDesc.shift.name", GameSettings.func_74298_c((int)56));
            alt2 = CompatHander.translateToLocalFormatted("itemDesc.shift.name", GameSettings.func_74298_c((int)184));
            ctrl1 = CompatHander.translateToLocalFormatted("itemDesc.shift.name", GameSettings.func_74298_c((int)(Minecraft.field_142025_a ? 219 : 29)));
            ctrl2 = CompatHander.translateToLocalFormatted("itemDesc.shift.name", GameSettings.func_74298_c((int)(Minecraft.field_142025_a ? 220 : 157)));
            TOOLTIPS.add(new TooltipLineModifier(shift1, "\u00a7!shift"));
            TOOLTIPS.add(new TooltipLineModifier(shift2, "\u00a7!shift"));
            TOOLTIPS.add(new TooltipLineModifier(alt1, "\u00a7!alt"));
            TOOLTIPS.add(new TooltipLineModifier(alt2, "\u00a7!alt"));
            TOOLTIPS.add(new TooltipLineModifier(ctrl1, "\u00a7!ctrl"));
            TOOLTIPS.add(new TooltipLineModifier(ctrl2, "\u00a7!ctrl"));
        }
        if (CompatConfig.computronicsEnabled) {
            shift1 = CompatHander.translateToLocalFormatted("oc:tooltip.TooLong", GameSettings.func_74298_c((int)42));
            shift2 = CompatHander.translateToLocalFormatted("oc:tooltip.TooLong", GameSettings.func_74298_c((int)54));
            alt1 = CompatHander.translateToLocalFormatted("oc:tooltip.TooLong", GameSettings.func_74298_c((int)56));
            alt2 = CompatHander.translateToLocalFormatted("oc:tooltip.TooLong", GameSettings.func_74298_c((int)184));
            ctrl1 = CompatHander.translateToLocalFormatted("oc:tooltip.TooLong", GameSettings.func_74298_c((int)(Minecraft.field_142025_a ? 219 : 29)));
            ctrl2 = CompatHander.translateToLocalFormatted("oc:tooltip.TooLong", GameSettings.func_74298_c((int)(Minecraft.field_142025_a ? 220 : 157)));
            TOOLTIPS.add(new TooltipLineModifier(shift1, "\u00a7!shift"));
            TOOLTIPS.add(new TooltipLineModifier(shift2, "\u00a7!shift"));
            TOOLTIPS.add(new TooltipLineModifier(alt1, "\u00a7!alt"));
            TOOLTIPS.add(new TooltipLineModifier(alt2, "\u00a7!alt"));
            TOOLTIPS.add(new TooltipLineModifier(ctrl1, "\u00a7!ctrl"));
            TOOLTIPS.add(new TooltipLineModifier(ctrl2, "\u00a7!ctrl"));
        }
        if (CompatConfig.baublesExpandedEnabled) {
            TOOLTIPS.add(new TooltipLineModifier(CompatHander.translateToLocal("tooltip.shiftprompt"), "\u00a7!shift"));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemTooltipEvent(ItemTooltipEvent event) {
        ItemStackKey key = new ItemStackKey(event.itemStack);
        Set<TooltipLineModifier> modifiers = MODIFIERS.get(key);
        if (modifiers != null) {
            for (TooltipLineModifier rule : modifiers) {
                event.toolTip.removeIf(s -> EnumChatFormatting.func_110646_a((String)s).contains(rule.line));
                event.toolTip.add(rule.modifier);
            }
        } else if (TooltipUtils.getMetaHash() == 0) {
            modifiers = new HashSet<TooltipLineModifier>();
            MODIFIERS.put(key, modifiers);
            for (TooltipLineModifier rule : TOOLTIPS) {
                if (!event.toolTip.removeIf(s -> EnumChatFormatting.func_110646_a((String)s).contains(rule.line))) continue;
                modifiers.add(rule);
            }
            for (TooltipLineModifier rule : modifiers) {
                event.toolTip.add(rule.modifier);
            }
        } else {
            for (TooltipLineModifier rule : TOOLTIPS) {
                if (!event.toolTip.removeIf(s -> EnumChatFormatting.func_110646_a((String)s).contains(rule.line))) continue;
                event.toolTip.add(rule.modifier);
            }
        }
    }

    private static String translateToLocal(String key) {
        return EnumChatFormatting.func_110646_a((String)StatCollector.func_74838_a((String)key).replaceAll("&[0-9a-fk-or]", ""));
    }

    private static String translateToLocalFormatted(String key, Object ... format) {
        return EnumChatFormatting.func_110646_a((String)StatCollector.func_74837_a((String)key, (Object[])format).replaceAll("&[0-9a-fk-or]", ""));
    }

    protected static class TooltipLineModifier {
        public final String modifier;
        public final String line;

        public TooltipLineModifier(String line, String modifier) {
            this.line = line;
            this.modifier = modifier;
        }
    }
}

