/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltipscompat.event;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.util.ItemUntranslator;
import com.slprime.chromatictooltips.TooltipRegistry;
import com.slprime.chromatictooltips.api.EnricherPlace;
import com.slprime.chromatictooltips.api.ITooltipComponent;
import com.slprime.chromatictooltips.api.ITooltipEnricher;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.api.TooltipLines;
import com.slprime.chromatictooltips.api.TooltipModifier;
import com.slprime.chromatictooltips.api.TooltipTarget;
import com.slprime.chromatictooltips.event.ContextInfoEnricherEvent;
import com.slprime.chromatictooltips.event.FluidInfoEnricherEvent;
import com.slprime.chromatictooltips.event.HotkeyEnricherEvent;
import com.slprime.chromatictooltips.event.TextLinesConverterEvent;
import com.slprime.chromatictooltips.event.TitleEnricherEvent;
import com.slprime.chromatictooltips.util.TooltipUtils;
import com.slprime.chromatictooltipscompat.CompatConfig;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.util.GTUtility;
import java.awt.Point;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class NEIHandler {
    protected static List<GuiDraw.ITooltipLineHandler> tipLineHandlers = new ArrayList<GuiDraw.ITooltipLineHandler>();

    public static void registerHandler() {
        NEIHandler instance = new NEIHandler();
        FMLCommonHandler.instance().bus().register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)instance);
        TooltipRegistry.addEnricherAfter((String)"title", (ITooltipEnricher)new SecondTitleEnricher());
        try {
            Field field = GuiDraw.class.getDeclaredField("tipLineHandlers");
            field.setAccessible(true);
            tipLineHandlers = (List)field.get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected List<IContainerTooltipHandler> getInstanceTooltipHandlers() {
        GuiContainerManager manager = GuiContainerManager.getManager();
        return Collections.unmodifiableList(manager != null ? manager.instanceTooltipHandlers : new ArrayList());
    }

    protected ItemStack getItemStackFromContext(TooltipTarget target) {
        ItemStack stack = target.getItem();
        if (stack == null && target.isFluid() && CompatConfig.gregtechEnabled && Loader.isModLoaded((String)"gregtech")) {
            stack = GTUtility.getFluidDisplayStack((FluidStack)target.getFluid(), (boolean)true);
        }
        return stack;
    }

    @SubscribeEvent
    public void onTitleEnricherEvent(TitleEnricherEvent event) {
        ItemStack stack = this.getItemStackFromContext(event.target);
        if (stack == null) {
            return;
        }
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        List<String> namelist = new ArrayList<String>();
        namelist.add(event.displayName);
        for (IContainerTooltipHandler handler : this.getInstanceTooltipHandlers()) {
            namelist = handler.handleItemDisplayName(gui, stack, namelist);
        }
        if (!namelist.isEmpty()) {
            event.displayName = (String)namelist.get(0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onContextInfoEnricherEvent(ContextInfoEnricherEvent event) {
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        Point mouse = TooltipUtils.getMousePosition();
        ItemStack stack = this.getItemStackFromContext(event.target);
        List<String> tooltip = new ArrayList<String>();
        tooltip.add("Temporary Name");
        for (IContainerTooltipHandler handler : this.getInstanceTooltipHandlers()) {
            tooltip = handler.handleItemTooltip(gui, stack, mouse.x, mouse.y, tooltip);
        }
        if (!tooltip.isEmpty()) {
            tooltip.remove(0);
        }
        event.tooltip.addAll(tooltip);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onFluidInfoEnricherEvent(FluidInfoEnricherEvent event) {
        if (CompatConfig.gregtechEnabled && Loader.isModLoaded((String)"gregtech")) {
            ItemStack stack = GTUtility.getFluidDisplayStack((Fluid)event.target.getFluid().getFluid());
            if (stack == null) {
                return;
            }
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add("Temporary Name");
            stack.func_77973_b().func_77624_a(stack, (EntityPlayer)TooltipUtils.mc().field_71439_g, tooltip, false);
            if (!tooltip.isEmpty()) {
                tooltip.remove(0);
            }
            event.tooltip.addAll(tooltip);
        }
    }

    @SubscribeEvent
    public void onHotkeyEnricherEvent(HotkeyEnricherEvent event) {
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        Point mouse = TooltipUtils.getMousePosition();
        for (IContainerTooltipHandler handler : this.getInstanceTooltipHandlers()) {
            event.hotkeys = handler.handleHotkeys(gui, mouse.x, mouse.y, event.hotkeys);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onTextLinesConverterEvent(TextLinesConverterEvent event) {
        if (tipLineHandlers.isEmpty()) {
            return;
        }
        for (int i = 0; i < event.list.size(); ++i) {
            GuiDraw.ITooltipLineHandler lineHandler;
            String str;
            Object e = event.list.get(i);
            if (!(e instanceof String) || (str = (String)e).isEmpty() || (lineHandler = GuiDraw.getTipLine((String)EnumChatFormatting.func_110646_a((String)str))) == null) continue;
            event.list.set(i, new TooltipComponentCompat(lineHandler));
        }
    }

    @SubscribeEvent
    public void onScreenPostDraw(GuiScreenEvent.DrawScreenEvent.Post event) {
        tipLineHandlers.clear();
    }

    protected static class SecondTitleEnricher
    implements ITooltipEnricher {
        protected SecondTitleEnricher() {
        }

        public String sectionId() {
            return "untranslator";
        }

        public EnricherPlace place() {
            return EnricherPlace.HEADER;
        }

        public EnumSet<TooltipModifier> mode() {
            return EnumSet.of(TooltipModifier.NONE);
        }

        public TooltipLines build(TooltipContext context) {
            String subtitle;
            ItemStack itemStack = context.getItem();
            if (itemStack == null && context.getTarget().isFluid() && CompatConfig.gregtechEnabled && Loader.isModLoaded((String)"gregtech")) {
                itemStack = GTUtility.getFluidDisplayStack((FluidStack)context.getFluid(), (boolean)true);
            }
            if (itemStack != null && (subtitle = ItemUntranslator.getInstance().getItemStackDisplayName(itemStack)) != null && !subtitle.isEmpty()) {
                return new TooltipLines(new Object[]{EnumChatFormatting.DARK_GRAY + subtitle});
            }
            return null;
        }
    }

    protected static class TooltipComponentCompat
    implements ITooltipComponent {
        protected final GuiDraw.ITooltipLineHandler lineHandler;

        public TooltipComponentCompat(GuiDraw.ITooltipLineHandler lineHandler) {
            this.lineHandler = lineHandler;
        }

        public int getWidth() {
            return this.lineHandler.getSize().width;
        }

        public int getHeight() {
            return this.lineHandler.getSize().height;
        }

        public int getSpacing() {
            return 0;
        }

        public void draw(int x, int y, int availableWidth, TooltipContext context) {
            this.lineHandler.draw(x, y);
        }

        public int hashCode() {
            return this.lineHandler.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof TooltipComponentCompat) {
                TooltipComponentCompat other = (TooltipComponentCompat)obj;
                return this.lineHandler.equals(other.lineHandler);
            }
            return false;
        }
    }
}

