/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltipscompat.filter;

import bartworks.util.BWUtil;
import com.slprime.chromatictooltips.api.TooltipTarget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.ItemList;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.MetaGeneratedItem;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.metatileentity.implementations.MTECable;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.ItemMachines;
import gregtech.common.tileentities.machines.multi.MTEDrillerBase;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class GTTierFilterParser
implements Function<String, Predicate<TooltipTarget>> {
    protected static final List<String> tiers = Arrays.asList("ULV", "LV", "MV", "HV", "EV", "IV", "LUV", "ZPM", "UV", "UHV", "UEV", "UIV", "UMV", "UXV", "MAX", "MAX+");
    protected Method drillerBaseTierMethod;

    public GTTierFilterParser() {
        try {
            this.drillerBaseTierMethod = MTEDrillerBase.class.getDeclaredMethod("getMinTier", new Class[0]);
            this.drillerBaseTierMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            this.drillerBaseTierMethod = null;
        }
    }

    @Override
    public Predicate<TooltipTarget> apply(String tierStr) {
        int tier = tiers.indexOf(tierStr.toUpperCase());
        if (tier == -1) {
            return target -> false;
        }
        return target -> {
            ItemStack stack = target.getItem();
            if (stack == null) {
                return false;
            }
            if (stack.func_77973_b() instanceof ItemMachines) {
                IMetaTileEntity meta = ItemMachines.getMetaTileEntity((ItemStack)stack);
                if (meta instanceof MTECable) {
                    MTECable handCable = (MTECable)meta;
                    return GTUtility.getTier((long)handCable.mVoltage) == tier;
                }
                if (meta instanceof MTEDrillerBase) {
                    MTEDrillerBase drillerBase = (MTEDrillerBase)meta;
                    if (this.drillerBaseTierMethod != null) {
                        int drillerBaseTier = -1;
                        try {
                            drillerBaseTier = (Integer)this.drillerBaseTierMethod.invoke((Object)drillerBase, new Object[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return drillerBaseTier == tier;
                    }
                }
                return this.getItemMachinesTier(stack) == tier;
            }
            Item patt2840$temp = stack.func_77973_b();
            if (patt2840$temp instanceof MetaGeneratedTool) {
                MetaGeneratedTool tool = (MetaGeneratedTool)patt2840$temp;
                Long[] stats = tool.getElectricStats(stack);
                if (stats != null) {
                    return stats[2] == (long)tier;
                }
            } else {
                MetaGeneratedItem mgItem;
                Long[] stats;
                if (BWUtil.getCircuitTierFromItemStack((ItemStack)stack) == tier) {
                    return true;
                }
                Item patt3208$temp = stack.func_77973_b();
                if (patt3208$temp instanceof MetaGeneratedItem && (stats = (mgItem = (MetaGeneratedItem)patt3208$temp).getElectricStats(stack)) != null) {
                    return stats[2] == (long)tier;
                }
                if (GTTierFilterParser.areItemStackEqual(stack, this.getElectricMotor(tier))) {
                    return true;
                }
                if (GTTierFilterParser.areItemStackEqual(stack, this.getFluidRegulator(tier))) {
                    return true;
                }
                if (GTTierFilterParser.areItemStackEqual(stack, this.getElectricPiston(tier))) {
                    return true;
                }
                if (GTTierFilterParser.areItemStackEqual(stack, this.getElectricPump(tier))) {
                    return true;
                }
                if (GTTierFilterParser.areItemStackEqual(stack, this.getRobotArm(tier))) {
                    return true;
                }
                if (GTTierFilterParser.areItemStackEqual(stack, this.getConveyor(tier))) {
                    return true;
                }
                if (GTTierFilterParser.areItemStackEqual(stack, this.getEmitter(tier))) {
                    return true;
                }
                if (GTTierFilterParser.areItemStackEqual(stack, this.getSensor(tier))) {
                    return true;
                }
                if (GTTierFilterParser.areItemStackEqual(stack, this.getFieldGenerator(tier))) {
                    return true;
                }
                if (GTTierFilterParser.areItemStackEqual(stack, this.getEnergyCore(tier))) {
                    return true;
                }
                if (GTTierFilterParser.areItemStackEqual(stack, this.getTieredGTPPMachineCasing(tier))) {
                    return true;
                }
                if (GTTierFilterParser.areItemStackEqual(stack, this.getTransmissionComponent(tier))) {
                    return true;
                }
                if (GTTierFilterParser.areItemStackEqual(stack, this.getTieredMachineHull(tier))) {
                    return true;
                }
                if (GTTierFilterParser.areItemStackEqual(stack, this.getTieredMachineCasing(tier))) {
                    return true;
                }
                if (tier == 1 && GTTierFilterParser.areItemStackEqual(stack, ItemList.Battery_Hull_LV.get(1L, new Object[0]))) {
                    return true;
                }
                if (tier == 2 && GTTierFilterParser.areItemStackEqual(stack, ItemList.Battery_Hull_MV.get(1L, new Object[0]))) {
                    return true;
                }
                if (tier == 3 && GTTierFilterParser.areItemStackEqual(stack, ItemList.Battery_Hull_HV.get(1L, new Object[0]))) {
                    return true;
                }
            }
            return false;
        };
    }

    protected ItemStack getElectricMotor(int tier) {
        ItemStack itemStack;
        switch (tier) {
            case 0: {
                itemStack = ItemList.Hull_ULV.get(1L, new Object[0]);
                break;
            }
            case 1: {
                itemStack = ItemList.Hull_LV.get(1L, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Hull_MV.get(1L, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Hull_HV.get(1L, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Hull_EV.get(1L, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Hull_IV.get(1L, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Hull_LuV.get(1L, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Hull_ZPM.get(1L, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Hull_UV.get(1L, new Object[0]);
                break;
            }
            default: {
                itemStack = ItemList.Hull_MAX.get(1L, new Object[0]);
            }
        }
        return itemStack;
    }

    protected ItemStack getFluidRegulator(int tier) {
        ItemStack itemStack;
        switch (tier) {
            case 0: {
                itemStack = ItemList.FluidRegulator_LV.get(1L, new Object[0]);
                break;
            }
            case 1: {
                itemStack = ItemList.FluidRegulator_LV.get(1L, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.FluidRegulator_MV.get(1L, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.FluidRegulator_HV.get(1L, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.FluidRegulator_EV.get(1L, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.FluidRegulator_IV.get(1L, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.FluidRegulator_LuV.get(1L, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.FluidRegulator_ZPM.get(1L, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.FluidRegulator_UV.get(1L, new Object[0]);
                break;
            }
            default: {
                itemStack = ItemList.FluidRegulator_UV.get(1L, new Object[0]);
            }
        }
        return itemStack;
    }

    protected ItemStack getElectricPiston(int tier) {
        ItemStack itemStack;
        switch (tier) {
            case 1: {
                itemStack = ItemList.Electric_Piston_LV.get(1L, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Electric_Piston_MV.get(1L, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Electric_Piston_HV.get(1L, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Electric_Piston_EV.get(1L, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Electric_Piston_IV.get(1L, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Electric_Piston_LuV.get(1L, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Electric_Piston_ZPM.get(1L, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Electric_Piston_UV.get(1L, new Object[0]);
                break;
            }
            default: {
                itemStack = ItemList.Electric_Piston_UHV.get(1L, new Object[0]);
            }
        }
        return itemStack;
    }

    protected ItemStack getElectricPump(int tier) {
        ItemStack itemStack;
        switch (tier) {
            case 1: {
                itemStack = ItemList.Electric_Pump_LV.get(1L, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Electric_Pump_MV.get(1L, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Electric_Pump_HV.get(1L, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Electric_Pump_EV.get(1L, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Electric_Pump_IV.get(1L, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Electric_Pump_LuV.get(1L, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Electric_Pump_ZPM.get(1L, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Electric_Pump_UV.get(1L, new Object[0]);
                break;
            }
            default: {
                itemStack = ItemList.Electric_Pump_UHV.get(1L, new Object[0]);
            }
        }
        return itemStack;
    }

    protected ItemStack getRobotArm(int tier) {
        ItemStack itemStack;
        switch (tier) {
            case 1: {
                itemStack = ItemList.Robot_Arm_LV.get(1L, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Robot_Arm_MV.get(1L, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Robot_Arm_HV.get(1L, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Robot_Arm_EV.get(1L, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Robot_Arm_IV.get(1L, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Robot_Arm_LuV.get(1L, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Robot_Arm_ZPM.get(1L, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Robot_Arm_UV.get(1L, new Object[0]);
                break;
            }
            default: {
                itemStack = ItemList.Robot_Arm_UHV.get(1L, new Object[0]);
            }
        }
        return itemStack;
    }

    protected ItemStack getConveyor(int tier) {
        ItemStack itemStack;
        switch (tier) {
            case 1: {
                itemStack = ItemList.Conveyor_Module_LV.get(1L, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Conveyor_Module_MV.get(1L, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Conveyor_Module_HV.get(1L, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Conveyor_Module_EV.get(1L, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Conveyor_Module_IV.get(1L, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Conveyor_Module_LuV.get(1L, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Conveyor_Module_ZPM.get(1L, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Conveyor_Module_UV.get(1L, new Object[0]);
                break;
            }
            default: {
                itemStack = ItemList.Conveyor_Module_UHV.get(1L, new Object[0]);
            }
        }
        return itemStack;
    }

    protected ItemStack getEmitter(int tier) {
        ItemStack itemStack;
        switch (tier) {
            case 1: {
                itemStack = ItemList.Emitter_LV.get(1L, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Emitter_MV.get(1L, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Emitter_HV.get(1L, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Emitter_EV.get(1L, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Emitter_IV.get(1L, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Emitter_LuV.get(1L, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Emitter_ZPM.get(1L, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Emitter_UV.get(1L, new Object[0]);
                break;
            }
            default: {
                itemStack = ItemList.Emitter_UHV.get(1L, new Object[0]);
            }
        }
        return itemStack;
    }

    protected ItemStack getSensor(int tier) {
        ItemStack itemStack;
        switch (tier) {
            case 1: {
                itemStack = ItemList.Sensor_LV.get(1L, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Sensor_MV.get(1L, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Sensor_HV.get(1L, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Sensor_EV.get(1L, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Sensor_IV.get(1L, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Sensor_LuV.get(1L, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Sensor_ZPM.get(1L, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Sensor_UV.get(1L, new Object[0]);
                break;
            }
            default: {
                itemStack = ItemList.Sensor_UHV.get(1L, new Object[0]);
            }
        }
        return itemStack;
    }

    protected ItemStack getFieldGenerator(int tier) {
        ItemStack itemStack;
        switch (tier) {
            case 1: {
                itemStack = ItemList.Field_Generator_LV.get(1L, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Field_Generator_MV.get(1L, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Field_Generator_HV.get(1L, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Field_Generator_EV.get(1L, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Field_Generator_IV.get(1L, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Field_Generator_LuV.get(1L, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Field_Generator_ZPM.get(1L, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Field_Generator_UV.get(1L, new Object[0]);
                break;
            }
            default: {
                itemStack = ItemList.Field_Generator_UHV.get(1L, new Object[0]);
            }
        }
        return itemStack;
    }

    protected ItemStack getEnergyCore(int tier) {
        ItemStack itemStack;
        switch (tier) {
            case 0: {
                itemStack = GregtechItemList.Energy_Core_ULV.get(1L, new Object[0]);
                break;
            }
            case 1: {
                itemStack = GregtechItemList.Energy_Core_LV.get(1L, new Object[0]);
                break;
            }
            case 2: {
                itemStack = GregtechItemList.Energy_Core_MV.get(1L, new Object[0]);
                break;
            }
            case 3: {
                itemStack = GregtechItemList.Energy_Core_HV.get(1L, new Object[0]);
                break;
            }
            case 4: {
                itemStack = GregtechItemList.Energy_Core_EV.get(1L, new Object[0]);
                break;
            }
            case 5: {
                itemStack = GregtechItemList.Energy_Core_IV.get(1L, new Object[0]);
                break;
            }
            case 6: {
                itemStack = GregtechItemList.Energy_Core_LuV.get(1L, new Object[0]);
                break;
            }
            case 7: {
                itemStack = GregtechItemList.Energy_Core_ZPM.get(1L, new Object[0]);
                break;
            }
            case 8: {
                itemStack = GregtechItemList.Energy_Core_UV.get(1L, new Object[0]);
                break;
            }
            default: {
                itemStack = GregtechItemList.Energy_Core_UHV.get(1L, new Object[0]);
            }
        }
        return itemStack;
    }

    protected ItemStack getTieredGTPPMachineCasing(int tier) {
        ItemStack itemStack;
        switch (tier) {
            case 0: {
                itemStack = GregtechItemList.GTPP_Casing_ULV.get(1L, new Object[0]);
                break;
            }
            case 1: {
                itemStack = GregtechItemList.GTPP_Casing_LV.get(1L, new Object[0]);
                break;
            }
            case 2: {
                itemStack = GregtechItemList.GTPP_Casing_MV.get(1L, new Object[0]);
                break;
            }
            case 3: {
                itemStack = GregtechItemList.GTPP_Casing_HV.get(1L, new Object[0]);
                break;
            }
            case 4: {
                itemStack = GregtechItemList.GTPP_Casing_EV.get(1L, new Object[0]);
                break;
            }
            case 5: {
                itemStack = GregtechItemList.GTPP_Casing_IV.get(1L, new Object[0]);
                break;
            }
            case 6: {
                itemStack = GregtechItemList.GTPP_Casing_LuV.get(1L, new Object[0]);
                break;
            }
            case 7: {
                itemStack = GregtechItemList.GTPP_Casing_ZPM.get(1L, new Object[0]);
                break;
            }
            case 8: {
                itemStack = GregtechItemList.GTPP_Casing_UV.get(1L, new Object[0]);
                break;
            }
            default: {
                itemStack = GregtechItemList.GTPP_Casing_UHV.get(1L, new Object[0]);
            }
        }
        return itemStack;
    }

    protected ItemStack getTransmissionComponent(int tier) {
        ItemStack itemStack;
        switch (tier) {
            case 1: {
                itemStack = GregtechItemList.TransmissionComponent_LV.get(1L, new Object[0]);
                break;
            }
            case 2: {
                itemStack = GregtechItemList.TransmissionComponent_MV.get(1L, new Object[0]);
                break;
            }
            case 3: {
                itemStack = GregtechItemList.TransmissionComponent_HV.get(1L, new Object[0]);
                break;
            }
            case 4: {
                itemStack = GregtechItemList.TransmissionComponent_EV.get(1L, new Object[0]);
                break;
            }
            case 5: {
                itemStack = GregtechItemList.TransmissionComponent_IV.get(1L, new Object[0]);
                break;
            }
            case 6: {
                itemStack = GregtechItemList.TransmissionComponent_LuV.get(1L, new Object[0]);
                break;
            }
            case 7: {
                itemStack = GregtechItemList.TransmissionComponent_ZPM.get(1L, new Object[0]);
                break;
            }
            case 8: {
                itemStack = GregtechItemList.TransmissionComponent_UV.get(1L, new Object[0]);
                break;
            }
            default: {
                itemStack = GregtechItemList.TransmissionComponent_UHV.get(1L, new Object[0]);
            }
        }
        return itemStack;
    }

    protected ItemStack getTieredMachineHull(int tier) {
        ItemStack itemStack;
        switch (tier) {
            case 0: {
                itemStack = ItemList.Hull_ULV.get(1L, new Object[0]);
                break;
            }
            case 1: {
                itemStack = ItemList.Hull_LV.get(1L, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Hull_MV.get(1L, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Hull_HV.get(1L, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Hull_EV.get(1L, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Hull_IV.get(1L, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Hull_LuV.get(1L, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Hull_ZPM.get(1L, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Hull_UV.get(1L, new Object[0]);
                break;
            }
            default: {
                itemStack = ItemList.Hull_MAX.get(1L, new Object[0]);
            }
        }
        return itemStack;
    }

    protected ItemStack getTieredMachineCasing(int tier) {
        ItemStack itemStack;
        switch (tier) {
            case 0: {
                itemStack = ItemList.Casing_ULV.get(1L, new Object[0]);
                break;
            }
            case 1: {
                itemStack = ItemList.Casing_LV.get(1L, new Object[0]);
                break;
            }
            case 2: {
                itemStack = ItemList.Casing_MV.get(1L, new Object[0]);
                break;
            }
            case 3: {
                itemStack = ItemList.Casing_HV.get(1L, new Object[0]);
                break;
            }
            case 4: {
                itemStack = ItemList.Casing_EV.get(1L, new Object[0]);
                break;
            }
            case 5: {
                itemStack = ItemList.Casing_IV.get(1L, new Object[0]);
                break;
            }
            case 6: {
                itemStack = ItemList.Casing_LuV.get(1L, new Object[0]);
                break;
            }
            case 7: {
                itemStack = ItemList.Casing_ZPM.get(1L, new Object[0]);
                break;
            }
            case 8: {
                itemStack = ItemList.Casing_UV.get(1L, new Object[0]);
                break;
            }
            default: {
                itemStack = ItemList.Casing_MAX.get(1L, new Object[0]);
            }
        }
        return itemStack;
    }

    protected int getItemMachinesTier(ItemStack stack) {
        IGregTechTileEntity tTileEntity;
        int tDamage = stack.func_77960_j();
        if (tDamage <= 0 || tDamage >= GregTechAPI.METATILEENTITIES.length) {
            return -1;
        }
        if (GregTechAPI.METATILEENTITIES[tDamage] != null && (tTileEntity = GregTechAPI.METATILEENTITIES[tDamage].getBaseMetaTileEntity()).getEUCapacity() > 0L) {
            if (tTileEntity.getInputVoltage() > 0L) {
                return GTUtility.getTier((long)tTileEntity.getInputVoltage());
            }
            if (tTileEntity.getOutputVoltage() > 0L) {
                return GTUtility.getTier((long)tTileEntity.getOutputVoltage());
            }
        }
        return -1;
    }

    protected static boolean areItemStackEqual(ItemStack stackA, ItemStack stackB) {
        if (stackA == null && stackB == null) {
            return true;
        }
        if (stackA == null || stackB == null) {
            return false;
        }
        return stackA.func_77969_a(stackB) && ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }
}

