/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltipscompat.mixins.late.neicustomdiagram;

import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.TooltipElement;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.TooltipLine;
import com.github.dcysteine.neicustomdiagram.api.draw.Draw;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.slprime.chromatictooltips.TooltipHandler;
import com.slprime.chromatictooltips.api.ITooltipComponent;
import com.slprime.chromatictooltips.api.TooltipBuilder;
import com.slprime.chromatictooltips.api.TooltipContext;
import com.slprime.chromatictooltips.api.TooltipRequest;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={Draw.class})
public class DrawMixin {
    @Overwrite(remap=false)
    public static void drawTooltip(Tooltip tooltip, Point mousePos) {
        if (tooltip.lines().isEmpty()) {
            return;
        }
        TooltipBuilder builder = TooltipHandler.builder();
        for (TooltipLine line : tooltip.lines()) {
            builder.line(DrawMixin.restoreComponentIfNeeded(line));
        }
        TooltipHandler.drawHoveringText((TooltipRequest)builder.build());
    }

    private static ITooltipComponent restoreComponentIfNeeded(TooltipLine line) {
        for (TooltipElement element : line.elements()) {
            ITooltipComponent component;
            if (element.type() != TooltipElement.ElementType.TEXT || (component = TooltipHandler.getTooltipComponent((String)element.text())) == null) continue;
            return component;
        }
        return new TooltipComponentCompat(line);
    }

    private static class TooltipComponentCompat
    implements ITooltipComponent {
        protected final TooltipLine lineHandler;

        public TooltipComponentCompat(TooltipLine lineHandler) {
            this.lineHandler = lineHandler;
        }

        public int getWidth() {
            return this.lineHandler.width();
        }

        public int getHeight() {
            return 2 + this.lineHandler.height();
        }

        public int getSpacing() {
            return 0;
        }

        public void draw(int x, int y, int availableWidth, TooltipContext context) {
            GL11.glPushAttrib((int)24640);
            this.lineHandler.draw(x, y);
            GL11.glPopAttrib();
        }

        public int hashCode() {
            return this.lineHandler.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof TooltipComponentCompat) {
                TooltipComponentCompat other = (TooltipComponentCompat)obj;
                return this.lineHandler.equals(other.lineHandler);
            }
            return false;
        }
    }
}

