/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.retrofuturabootstrap;

import com.gtnewhorizons.retrofuturabootstrap.Main;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformerHandle;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SharedConfig {
    @NotNull
    public static final String RFB_CLASS_DUMP_PREFIX = "RFB_CLASS_DUMP";
    public static final boolean cfgDumpLoadedClasses = SharedConfig.getBooleanOr("rfb.dumpLoadedClasses", false) || Boolean.parseBoolean(System.getProperty("legacy.debugClassLoadingSave", "false"));
    public static final boolean cfgDumpLoadedClassesPerTransformer = SharedConfig.getBooleanOr("rfb.dumpLoadedClassesPerTransformer", false) || Boolean.parseBoolean(System.getProperty("legacy.debugClassLoadingSave", "false"));
    public static final boolean cfgDumpClassesAsynchronously = SharedConfig.getBooleanOr("rfb.dumpClassesAsynchronously", true);
    public static @NotNull AtomicReference<@Nullable Path> classDumpDirectory = new AtomicReference<Object>(null);
    @NotNull
    static final @NotNull AtomicReference<@NotNull RfbClassTransformerHandle[]> rfbTransformers = new AtomicReference<RfbClassTransformerHandle[]>(new RfbClassTransformerHandle[0]);
    @Nullable
    static ExecutorService classDumpingService;
    @NotNull
    static BiConsumer<String, Throwable> warnLogHandler;
    @NotNull
    static BiConsumer<String, Throwable> debugLogHandler;

    public static void logWarning(String message, @Nullable Throwable throwable) {
        warnLogHandler.accept(message, throwable);
    }

    public static void logDebug(String message, @Nullable Throwable throwable) {
        debugLogHandler.accept(message, throwable);
    }

    @NotNull
    public static @NotNull List<@NotNull RfbClassTransformerHandle> getRfbTransformers() {
        return Collections.unmodifiableList(Arrays.asList(rfbTransformers.get()));
    }

    private static boolean getBooleanOr(String propName, boolean defaultValue) {
        String propValue = System.getProperty(propName);
        if (propValue == null) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(propValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static void dumpClass(String classLoaderName, String className, byte[] classBytes) {
        if (className == null || classBytes == null || className.isEmpty()) {
            return;
        }
        try {
            Path dumpRoot = Main.classDumpDirectory.get();
            if (dumpRoot == null) {
                return;
            }
            Path clRoot = classLoaderName == null || classLoaderName.isEmpty() ? dumpRoot : dumpRoot.resolve(classLoaderName);
            String internalName = className.replace('.', '/').replace('$', '.');
            Path targetPath = clRoot.resolve(internalName + ".class");
            ExecutorService service = classDumpingService;
            if (cfgDumpClassesAsynchronously && service != null) {
                service.submit(() -> {
                    try {
                        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                        Files.write(targetPath, classBytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                    }
                    catch (IOException e) {
                        SharedConfig.logWarning("Could not save transformed class", e);
                    }
                });
            } else {
                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                Files.write(targetPath, classBytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
        catch (IOException | RejectedExecutionException e) {
            SharedConfig.logWarning("Could not save transformed class", e);
        }
    }

    static {
        warnLogHandler = (msg, throwable) -> {
            if (throwable != null) {
                System.err.printf("[WARN] %s: %s\n", msg, throwable.getMessage());
                throwable.printStackTrace(System.err);
            } else {
                System.err.printf("[WARN] %s\n", msg);
            }
        };
        debugLogHandler = (msg, throwable) -> {
            if (throwable != null) {
                System.out.printf("[DEBUG] %s: %s\n", msg, throwable.getMessage());
                throwable.printStackTrace(System.out);
            } else {
                System.out.printf("[DEBUG] %s\n", msg);
            }
        };
    }
}

