/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.retrofuturabootstrap.api;

import com.gtnewhorizons.retrofuturabootstrap.api.RfbPlugin;
import com.gtnewhorizons.retrofuturabootstrap.versioning.ArtifactVersion;
import com.gtnewhorizons.retrofuturabootstrap.versioning.DefaultArtifactVersion;
import com.gtnewhorizons.retrofuturabootstrap.versioning.InvalidVersionSpecificationException;
import com.gtnewhorizons.retrofuturabootstrap.versioning.VersionRange;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class RfbPluginMetadata
implements Comparable<RfbPluginMetadata> {
    @NotNull
    public static final Pattern ID_VALIDATOR = Pattern.compile("[a-z0-9-]+");
    @NotNull
    public static final Comparator<? super RfbPluginMetadata> ID_COMPARATOR = Comparator.nullsFirst(Comparator.comparing(RfbPluginMetadata::id));
    @NotNull
    public static final Comparator<? super RfbPluginMetadata> ID_AND_PIN_COMPARATOR = Comparator.nullsFirst(Comparator.comparing(RfbPluginMetadata::pinLast).thenComparing(RfbPluginMetadata::id));
    @NotNull
    private final URL classpathEntry;
    @NotNull
    private final URI source;
    @NotNull
    private final IdAndVersion idAndVersion;
    @NotNull
    private final String name;
    @NotNull
    private final @NotNull IdAndVersion @NotNull [] additionalVersions;
    @NotNull
    private final @NotNull IdAndVersionRange @NotNull [] versionConstraints;
    @NotNull
    private final @NotNull String @NotNull [] transformerExclusions;
    @NotNull
    private final @NotNull String @NotNull [] loadBefore;
    @NotNull
    private final @NotNull String @NotNull [] loadAfter;
    @NotNull
    private final @NotNull String @NotNull [] loadRequires;
    private final boolean pinLast;
    @NotNull
    private final String className;
    @Nullable
    private RfbPlugin instance;

    public RfbPluginMetadata(@NotNull URL classpathEntry, @NotNull URI source, @NotNull String id, @NotNull String name, @NotNull ArtifactVersion version, IdAndVersion[] additionalVersions, @NotNull String className, IdAndVersionRange[] versionConstraints, String[] transformerExclusions, String[] loadBefore, String[] loadAfter, String[] loadRequires, boolean pinLast) {
        this.classpathEntry = Objects.requireNonNull(classpathEntry);
        this.source = Objects.requireNonNull(source);
        Objects.requireNonNull(id);
        Objects.requireNonNull(version);
        this.idAndVersion = new IdAndVersion(id, version);
        this.name = Objects.requireNonNull(name);
        this.additionalVersions = additionalVersions == null ? new IdAndVersion[]{} : additionalVersions;
        this.className = Objects.requireNonNull(className);
        this.versionConstraints = versionConstraints == null ? new IdAndVersionRange[]{} : versionConstraints;
        this.transformerExclusions = transformerExclusions == null ? new String[]{} : transformerExclusions;
        this.loadBefore = loadBefore == null ? new String[]{} : loadBefore;
        this.loadAfter = loadAfter == null ? new String[]{} : loadAfter;
        this.loadRequires = loadRequires == null ? new String[]{} : loadRequires;
        this.pinLast = pinLast;
    }

    public RfbPluginMetadata(@NotNull URL classpathEntry, @NotNull URI source, @NotNull String id, Properties props) {
        this.classpathEntry = classpathEntry;
        this.source = Objects.requireNonNull(source);
        Objects.requireNonNull(id);
        if (!ID_VALIDATOR.matcher(id).matches()) {
            throw new RuntimeException("Plugin ID does not match the required pattern '[a-z0-9-]+': " + id);
        }
        try {
            this.name = Objects.requireNonNull(props.getProperty("name"), "name is not present");
            String versionString = Objects.requireNonNull(props.getProperty("version"), "version is not present");
            DefaultArtifactVersion mainVersion = new DefaultArtifactVersion(versionString);
            this.idAndVersion = new IdAndVersion(id, mainVersion);
            String additionalVersionsString = props.getProperty("additionalVersions", "").trim();
            if (additionalVersionsString.isEmpty()) {
                this.additionalVersions = new IdAndVersion[0];
            } else {
                String[] pairs = additionalVersionsString.split(";");
                this.additionalVersions = (IdAndVersion[])Arrays.stream(pairs).map(String::trim).filter(s -> !s.isEmpty()).map(pair -> {
                    String[] comps = pair.split("@", 2);
                    String additionalId = comps[0];
                    if (!ID_VALIDATOR.matcher(additionalId).matches()) {
                        throw new RuntimeException("Additional plugin ID does not match the required pattern '[a-z0-9-]+': " + id);
                    }
                    if (additionalId.equals(id)) {
                        throw new RuntimeException("Additional plugin ID is the same as the main plugin ID: " + id);
                    }
                    ArtifactVersion additionalVersion = comps.length > 1 ? new DefaultArtifactVersion(comps[1]) : mainVersion;
                    return new IdAndVersion(additionalId, additionalVersion);
                }).toArray(IdAndVersion[]::new);
                for (int i = 1; i < this.additionalVersions.length; ++i) {
                    for (int j = 0; j < i; ++j) {
                        if (!this.additionalVersions[i].id().equals(this.additionalVersions[j].id())) continue;
                        throw new RuntimeException("Additional plugin ID duplicated: " + this.additionalVersions[i] + " and " + this.additionalVersions[j]);
                    }
                }
            }
            this.className = Objects.requireNonNull(props.getProperty("className"), "className is not present");
            String versionConstraintsString = props.getProperty("versionConstraints", "").trim();
            if (versionConstraintsString.isEmpty()) {
                this.versionConstraints = new IdAndVersionRange[0];
            } else {
                String[] pairs = versionConstraintsString.split(";");
                this.versionConstraints = (IdAndVersionRange[])Arrays.stream(pairs).map(String::trim).filter(s -> !s.isEmpty()).map(pair -> {
                    VersionRange versionRange;
                    String[] comps = pair.split("@", 2);
                    String name = comps[0].trim();
                    if (comps.length < 2) {
                        throw new RuntimeException("Version not specified in versionConstraints for " + name);
                    }
                    try {
                        versionRange = VersionRange.createFromVersionSpec(comps[1].trim());
                    }
                    catch (InvalidVersionSpecificationException e) {
                        throw new RuntimeException(e);
                    }
                    return new IdAndVersionRange(name, versionRange);
                }).toArray(IdAndVersionRange[]::new);
            }
            AtomicBoolean pinLast = new AtomicBoolean(false);
            this.transformerExclusions = (String[])Arrays.stream(props.getProperty("transformerExclusions", "").split(";")).map(String::trim).filter(s -> !s.isEmpty()).toArray(String[]::new);
            this.loadBefore = (String[])Arrays.stream(props.getProperty("loadBefore", "").split(";")).map(String::trim).filter(s -> !s.isEmpty()).toArray(String[]::new);
            this.loadAfter = (String[])Arrays.stream(props.getProperty("loadAfter", "").split(";")).map(String::trim).filter(s -> !s.isEmpty()).filter(s -> {
                if ("*".equals(s)) {
                    pinLast.set(true);
                    return false;
                }
                return true;
            }).toArray(String[]::new);
            this.loadRequires = (String[])Arrays.stream(props.getProperty("loadRequires", "").split(";")).map(String::trim).filter(s -> !s.isEmpty()).toArray(String[]::new);
            this.pinLast = pinLast.get();
        }
        catch (Throwable t) {
            throw new RuntimeException("Error when parsing plugin metadata for plugin " + id, t);
        }
    }

    @NotNull
    public URL classpathEntry() {
        return this.classpathEntry;
    }

    @NotNull
    public URI source() {
        return this.source;
    }

    @NotNull
    public IdAndVersion idAndVersion() {
        return this.idAndVersion;
    }

    @NotNull
    public String id() {
        return this.idAndVersion.id();
    }

    @NotNull
    public String name() {
        return this.name;
    }

    @NotNull
    public ArtifactVersion version() {
        return this.idAndVersion.version();
    }

    @Nullable
    public ArtifactVersion version(String id) {
        if (this.idAndVersion.id().equals(id)) {
            return this.idAndVersion.version();
        }
        for (IdAndVersion iav : this.additionalVersions) {
            if (!iav.id.equals(id)) continue;
            return iav.version();
        }
        return null;
    }

    @NotNull
    public @NotNull IdAndVersion @NotNull [] additionalVersions() {
        return this.additionalVersions;
    }

    @NotNull
    public String className() {
        return this.className;
    }

    public RfbPlugin instance() {
        return this.instance;
    }

    public void instance(RfbPlugin value) {
        if (this.instance != null) {
            throw new IllegalStateException(this.idAndVersion + " already initialized");
        }
        this.instance = value;
    }

    @NotNull
    public @NotNull IdAndVersionRange @NotNull [] versionConstraints() {
        return this.versionConstraints;
    }

    @NotNull
    public @NotNull String @NotNull [] transformerExclusions() {
        return this.transformerExclusions;
    }

    @NotNull
    public @NotNull String @NotNull [] loadBefore() {
        return this.loadBefore;
    }

    @NotNull
    public @NotNull String @NotNull [] loadAfter() {
        return this.loadAfter;
    }

    @NotNull
    public @NotNull String @NotNull [] loadRequires() {
        return this.loadRequires;
    }

    public boolean pinLast() {
        return this.pinLast;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RfbPluginMetadata that = (RfbPluginMetadata)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.idAndVersion, that.idAndVersion) && Arrays.equals(this.additionalVersions, that.additionalVersions) && Objects.equals(this.className, that.className) && Objects.equals(this.instance, that.instance) && Arrays.equals(this.versionConstraints, that.versionConstraints) && Arrays.equals(this.transformerExclusions, that.transformerExclusions) && Arrays.equals(this.loadBefore, that.loadBefore) && Arrays.equals(this.loadAfter, that.loadAfter) && Arrays.equals(this.loadRequires, that.loadRequires);
    }

    public int hashCode() {
        return Objects.hash(this.idAndVersion, this.name, Arrays.hashCode(this.additionalVersions), this.className, Arrays.hashCode(this.versionConstraints), Arrays.hashCode(this.transformerExclusions), Arrays.hashCode(this.loadBefore), Arrays.hashCode(this.loadAfter), Arrays.hashCode(this.loadRequires));
    }

    @NotNull
    public String toString() {
        return "RfbPluginMetadata[classpathEntry=" + this.classpathEntry + ", source=" + this.source + ", idAndVersion=" + this.idAndVersion + ", name=" + this.name + ", additionalVersions=" + Arrays.toString(this.additionalVersions) + ", className=" + this.className + ", versionConstraints=" + Arrays.toString(this.versionConstraints) + ", transformerExclusions=" + Arrays.toString(this.transformerExclusions) + ", loadBefore=" + Arrays.toString(this.loadBefore) + ", loadAfter=" + Arrays.toString(this.loadAfter) + ", loadRequires=" + Arrays.toString(this.loadRequires) + ']';
    }

    @Override
    public int compareTo(@NotNull RfbPluginMetadata o) {
        return ID_COMPARATOR.compare(this, o);
    }

    public static final class IdAndVersion {
        private final String id;
        private final ArtifactVersion version;

        public IdAndVersion(String id, ArtifactVersion version) {
            this.id = id;
            this.version = version;
        }

        public String id() {
            return this.id;
        }

        public ArtifactVersion version() {
            return this.version;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            IdAndVersion that = (IdAndVersion)obj;
            return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.version);
        }

        public String toString() {
            return this.id + '@' + this.version;
        }
    }

    public static final class IdAndVersionRange {
        private final String id;
        private final VersionRange version;

        public IdAndVersionRange(String id, VersionRange version) {
            this.id = id;
            this.version = version;
        }

        public String id() {
            return this.id;
        }

        public VersionRange version() {
            return this.version;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            IdAndVersionRange that = (IdAndVersionRange)obj;
            return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.version);
        }

        public String toString() {
            return this.id + '@' + this.version;
        }
    }

    @VisibleForTesting
    public static class Builder {
        @NotNull
        final URL classpathEntry;
        @NotNull
        final URI source;
        @NotNull
        final String id;
        @NotNull
        final String name;
        @NotNull
        final ArtifactVersion version;
        IdAndVersion[] additionalVersions = new IdAndVersion[0];
        @NotNull
        final String className;
        IdAndVersionRange[] versionConstraints = new IdAndVersionRange[0];
        String[] transformerExclusions = new String[0];
        String[] loadBefore = new String[0];
        String[] loadAfter = new String[0];
        String[] loadRequires = new String[0];
        boolean pinLast;

        public Builder(@NotNull URL classpathEntry, @NotNull URI source, @NotNull String id, @NotNull String name, @NotNull String version, @NotNull String className) {
            this.classpathEntry = classpathEntry;
            this.source = source;
            this.id = id;
            this.name = name;
            this.version = new DefaultArtifactVersion(version);
            this.className = className;
        }

        public Builder(@NotNull URL classpathEntry, @NotNull URI source, @NotNull String id, @NotNull String name, @NotNull String version, @NotNull Class<?> klass) {
            this(classpathEntry, source, id, name, version, klass.getName());
        }

        private static <T> T[] append(T[] array, T element) {
            T[] more = Arrays.copyOf(array, array.length + 1);
            more[array.length] = element;
            return more;
        }

        public Builder additionalVersion(String id, String version) {
            this.additionalVersions = Builder.append(this.additionalVersions, new IdAndVersion(id, new DefaultArtifactVersion(version)));
            return this;
        }

        public Builder versionConstraint(String id, String versionConstraint) {
            try {
                this.versionConstraints = Builder.append(this.versionConstraints, new IdAndVersionRange(id, VersionRange.createFromVersionSpec(versionConstraint)));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder transformerExclusion(String id) {
            this.transformerExclusions = Builder.append(this.transformerExclusions, id);
            return this;
        }

        public Builder loadBefore(String id) {
            this.loadBefore = Builder.append(this.loadBefore, id);
            return this;
        }

        public Builder loadAfter(String id) {
            if (id.equals("*")) {
                this.pinLast = true;
            } else {
                this.loadAfter = Builder.append(this.loadAfter, id);
            }
            return this;
        }

        public Builder loadRequires(String id) {
            this.loadRequires = Builder.append(this.loadRequires, id);
            return this;
        }

        public RfbPluginMetadata build() {
            return new RfbPluginMetadata(this.classpathEntry, this.source, this.id, this.name, this.version, this.additionalVersions, this.className, this.versionConstraints, this.transformerExclusions, this.loadBefore, this.loadAfter, this.loadRequires, this.pinLast);
        }
    }
}

