/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.retrofuturabootstrap.plugin;

import com.gtnewhorizons.retrofuturabootstrap.Main;
import com.gtnewhorizons.retrofuturabootstrap.algorithm.StableTopologicalSort;
import com.gtnewhorizons.retrofuturabootstrap.api.PluginContext;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformerHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbPlugin;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbPluginHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbPluginMetadata;
import com.gtnewhorizons.retrofuturabootstrap.plugin.PluginSorter;
import com.gtnewhorizons.retrofuturabootstrap.versioning.DefaultArtifactVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class PluginLoader {
    public static final String META_INF = "META-INF";
    public static final String RFB_PLUGINS_DIR = "rfb-plugin";
    private static final ArrayList<FileSystem> jarFilesystems = new ArrayList();
    public static final ArrayList<RfbPluginMetadata> loadedPluginMetadata = new ArrayList();
    public static final Map<String, RfbPluginMetadata> loadedPluginMetadataById = new HashMap<String, RfbPluginMetadata>();
    public static final ArrayList<RfbPluginHandle> loadedPlugins = new ArrayList();
    public static final Map<String, RfbPluginHandle> loadedPluginsById = new HashMap<String, RfbPluginHandle>();
    private static final URI myURI;
    private static final URL myJar;

    public static void initializePlugins() throws Throwable {
        List<RfbPluginMetadata> pluginMetadata = PluginLoader.findPluginManifests();
        pluginMetadata.add(PluginLoader.makeRfbMetadata());
        pluginMetadata.add(PluginLoader.makeJavaMetadata());
        Optional<List<RfbPluginMetadata>> sortedMetadata = new PluginSorter(pluginMetadata).resolve();
        if (!sortedMetadata.isPresent()) {
            throw new RuntimeException("There was a critical error during RFB plugin dependency resolution, check the log above for details.");
        }
        List<RfbPluginMetadata> sorted = sortedMetadata.get();
        loadedPluginMetadata.clear();
        loadedPluginMetadata.addAll(sorted);
        loadedPluginMetadataById.clear();
        for (RfbPluginMetadata rfbPluginMetadata : sorted) {
            loadedPluginMetadataById.put(rfbPluginMetadata.id(), rfbPluginMetadata);
            for (RfbPluginMetadata.IdAndVersion extraId : rfbPluginMetadata.additionalVersions()) {
                loadedPluginMetadataById.put(extraId.id(), rfbPluginMetadata);
            }
            Main.addSilentClasspathUrl(rfbPluginMetadata.classpathEntry());
        }
        loadedPlugins.clear();
        loadedPluginsById.clear();
        PluginContext loadingContext = new PluginContext(loadedPluginMetadata, loadedPlugins, loadedPluginMetadataById, loadedPluginsById);
        for (RfbPluginMetadata pluginMeta : sorted) {
            String className = pluginMeta.className();
            try {
                Class<?> klass = Class.forName(className, true, Main.compatLoader);
                if (!RfbPlugin.class.isAssignableFrom(klass)) {
                    throw new RuntimeException("Plugin class " + className + " does not implement the required RfbPlugin interface, source: " + pluginMeta.source());
                }
                RfbPlugin plugin = (RfbPlugin)klass.getConstructor(new Class[0]).newInstance(new Object[0]);
                RfbPluginHandle handle = new RfbPluginHandle(pluginMeta, plugin);
                Main.logger.info("Constructed RFB plugin {} ({}): {} ({})", new Object[]{pluginMeta.idAndVersion(), pluginMeta.name(), className, pluginMeta.source()});
                loadedPlugins.add(handle);
                loadedPluginsById.put(pluginMeta.id(), handle);
                for (RfbPluginMetadata.IdAndVersion extraId : pluginMeta.additionalVersions()) {
                    loadedPluginsById.put(extraId.id(), handle);
                }
                plugin.onConstruction(loadingContext);
                RfbClassTransformer[] earlyTransformers = plugin.makeEarlyTransformers();
                if (earlyTransformers == null || earlyTransformers.length <= 0) continue;
                if (Arrays.stream(earlyTransformers).anyMatch(Objects::isNull)) {
                    Main.logger.fatal("RFB plugin {} ({}) provided a null early class transformer.", new Object[]{pluginMeta.idAndVersion(), pluginMeta.name()});
                    throw new NullPointerException("Null early class transformer returned from RFB plugin " + pluginMeta.idAndVersion());
                }
                List toAdd = Arrays.stream(earlyTransformers).map(xformer -> new RfbClassTransformerHandle(pluginMeta, plugin, (RfbClassTransformer)xformer)).collect(Collectors.toList());
                Main.mutateRfbTransformers(list -> list.addAll(toAdd));
                for (RfbClassTransformerHandle newlyRegistered : toAdd) {
                    handle.registerAdditionalTransformer(newlyRegistered);
                    newlyRegistered.transformer().onRegistration(Objects.requireNonNull(Main.compatLoader));
                    newlyRegistered.transformer().onRegistration(Objects.requireNonNull(Main.launchLoader));
                }
            }
            catch (ReflectiveOperationException e) {
                Throwable cause = e;
                if (e instanceof InvocationTargetException) {
                    cause = e.getCause();
                }
                throw new RuntimeException("Error constructing plugin " + className + ", source: " + pluginMeta.source(), cause);
            }
        }
        if (loadedPlugins.size() != loadedPluginMetadata.size()) {
            Object[] objectArray = (String[])loadedPluginMetadata.stream().map(RfbPluginMetadata::className).toArray(String[]::new);
            Object[] loadClasses = (String[])loadedPlugins.stream().map(p -> p.getClass().getName()).toArray(String[]::new);
            Main.logger.fatal("RFB loaded plugin and metadata array size mismatch.\nMetadata: {}\n  Loaded: {}", new Object[]{Arrays.toString(objectArray), Arrays.toString(loadClasses)});
            throw new IllegalStateException("Loaded plugin and metadata array size mismatch.");
        }
        PluginLoader.closeJarFilesystems();
        IdentityHashMap identityHashMap = new IdentityHashMap(loadedPlugins.size());
        Main.mutateRfbTransformers(newTransformers -> {
            int i;
            ArrayList<RfbClassTransformerHandle> toRegister = new ArrayList<RfbClassTransformerHandle>();
            for (RfbPluginHandle handle : loadedPlugins) {
                RfbClassTransformer[] xformers = madeTransformersCache.computeIfAbsent(handle, h -> h.plugin().makeTransformers());
                if (xformers == null || xformers.length < 1) continue;
                for (RfbClassTransformer xformer : xformers) {
                    if (xformer == null) {
                        throw new NullPointerException("Null transformer produced by RFB plugin " + handle.metadata().id());
                    }
                    RfbClassTransformerHandle xhandle = new RfbClassTransformerHandle(handle.metadata(), handle.plugin(), xformer);
                    newTransformers.add(xhandle);
                    toRegister.add(xhandle);
                    handle.registerAdditionalTransformer(xhandle);
                }
            }
            String[] emptyStrA = new String[]{};
            IdentityHashMap<RfbClassTransformerHandle, String[]> sortAfterLut = new IdentityHashMap<RfbClassTransformerHandle, String[]>();
            IdentityHashMap<RfbClassTransformerHandle, String[]> sortBeforeLut = new IdentityHashMap<RfbClassTransformerHandle, String[]>();
            IdentityHashMap<RfbClassTransformerHandle, Boolean> sortLastLut = new IdentityHashMap<RfbClassTransformerHandle, Boolean>();
            for (RfbClassTransformerHandle xhandle : newTransformers) {
                String[] sortAfter;
                RfbClassTransformer xformer;
                xformer = xhandle.transformer();
                String[] sortBefore = xformer.sortBefore();
                if (sortBefore == null) {
                    sortBefore = emptyStrA;
                }
                if ((sortAfter = xformer.sortAfter()) == null) {
                    sortAfter = emptyStrA;
                }
                boolean sortLast = Arrays.asList(sortAfter).contains("*");
                sortBeforeLut.put(xhandle, sortBefore);
                sortAfterLut.put(xhandle, sortAfter);
                sortLastLut.put(xhandle, sortLast);
            }
            Comparator<RfbClassTransformerHandle> initialSorter = Comparator.comparing(sortLastLut::get).thenComparing(RfbClassTransformerHandle::id);
            newTransformers.sort(initialSorter);
            ArrayList<List<Integer>> edges = new ArrayList<List<Integer>>(newTransformers.size());
            HashMap<String, Integer> idLookup = new HashMap<String, Integer>();
            for (i = 0; i < newTransformers.size(); ++i) {
                edges.add(new ArrayList(0));
                RfbClassTransformerHandle newTransformer = (RfbClassTransformerHandle)newTransformers.get(i);
                idLookup.put(newTransformer.id(), i);
                for (String additionalId : newTransformer.additionalIds()) {
                    idLookup.put(additionalId, i);
                }
            }
            for (i = 0; i < newTransformers.size(); ++i) {
                Integer depIdx;
                RfbClassTransformerHandle handle = (RfbClassTransformerHandle)newTransformers.get(i);
                String[] before = (String[])sortBeforeLut.get(handle);
                String[] after = (String[])sortAfterLut.get(handle);
                for (String dep : before) {
                    depIdx = (Integer)idLookup.get(dep);
                    if (depIdx == null) continue;
                    ((List)edges.get(i)).add(depIdx);
                }
                for (String dep : after) {
                    depIdx = (Integer)idLookup.get(dep);
                    if (depIdx == null) continue;
                    ((List)edges.get(depIdx)).add(i);
                }
            }
            try {
                List toposorted = StableTopologicalSort.sort(newTransformers, edges);
                newTransformers.clear();
                newTransformers.addAll(toposorted);
            }
            catch (StableTopologicalSort.CycleException err) {
                Set<RfbClassTransformerHandle> cycle = err.cyclicElements(RfbClassTransformerHandle.class);
                Main.logger.error("Cycle found among the following RFB class transformers, aborting launch:");
                for (RfbClassTransformerHandle xformer : cycle) {
                    Main.logger.error("{} ({})", new Object[]{xformer.id(), xformer.pluginMetadata().idAndVersion()});
                }
                throw new RuntimeException("Cycle among RFB transformer sorting constraints.");
            }
            for (RfbClassTransformerHandle newlyRegistered : toRegister) {
                newlyRegistered.transformer().onRegistration(Objects.requireNonNull(Main.compatLoader));
                newlyRegistered.transformer().onRegistration(Objects.requireNonNull(Main.launchLoader));
            }
        });
    }

    private static RfbPluginMetadata makeJavaMetadata() {
        return new RfbPluginMetadata(myJar, myURI, "java", "Java", new DefaultArtifactVersion(Main.JAVA_VERSION), new RfbPluginMetadata.IdAndVersion[0], "com.gtnewhorizons.rfbplugins.compat.DummyJavaPlugin", new RfbPluginMetadata.IdAndVersionRange[0], new String[0], new String[0], new String[0], new String[0], false);
    }

    private static RfbPluginMetadata makeRfbMetadata() {
        return new RfbPluginMetadata(myJar, myURI, "rfb", "RetroFuturaBootstrap", new DefaultArtifactVersion("1.0.11.dirty"), new RfbPluginMetadata.IdAndVersion[0], "com.gtnewhorizons.rfbplugins.compat.DummyRfbPlugin", new RfbPluginMetadata.IdAndVersionRange[0], new String[0], new String[0], new String[0], new String[0], false);
    }

    private static List<RfbPluginMetadata> findPluginManifests() {
        URL[] earlyCp = Main.compatLoader.getURLs();
        final HashSet<URI> urisToSearch = new HashSet<URI>(earlyCp.length);
        for (URL entry : earlyCp) {
            try {
                urisToSearch.add(entry.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        File initialGameDir = Main.initialGameDir;
        Path gamePath = initialGameDir != null ? initialGameDir.toPath() : Paths.get(".", new String[0]).toAbsolutePath();
        Path modsDir = gamePath.resolve("mods");
        if (Files.isDirectory(modsDir, new LinkOption[0])) {
            try {
                Files.walkFileTree(modsDir, new HashSet<FileVisitOption>(Collections.singletonList(FileVisitOption.FOLLOW_LINKS)), 256, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Objects.requireNonNull(file);
                        Objects.requireNonNull(attrs);
                        if (file.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".jar")) {
                            urisToSearch.add(file.toUri());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        int count = 0;
        final ArrayList<RfbPluginMetadata> pluginMetadata = new ArrayList<RfbPluginMetadata>();
        String zipPrefix = "META-INF/rfb-plugin/";
        for (final URI uriToSearch : urisToSearch) {
            try {
                boolean isJar = uriToSearch.getPath().toLowerCase(Locale.ROOT).endsWith(".jar");
                ++count;
                Path root = Paths.get(uriToSearch);
                if (!isJar && !Files.isDirectory(root, new LinkOption[0])) {
                    Main.logger.warn("Skipping {} in RFB plugin search.", new Object[]{root});
                    continue;
                }
                if (isJar) {
                    try (ZipFile zip = new ZipFile(root.toFile(), 1, StandardCharsets.UTF_8);){
                        Enumeration<? extends ZipEntry> enm = zip.entries();
                        while (enm.hasMoreElements()) {
                            ZipEntry ze = enm.nextElement();
                            if (ze.isDirectory() || !ze.getName().startsWith("META-INF/rfb-plugin/")) continue;
                            URI uri = new URI("jar:" + root.toUri() + "!" + ze.getName());
                            String filename = ze.getName().replace("META-INF/rfb-plugin/", "");
                            if (filename.contains("/")) continue;
                            try {
                                InputStream is = zip.getInputStream(ze);
                                try (InputStreamReader rdr = new InputStreamReader(is, StandardCharsets.UTF_8);
                                     BufferedReader bufReader = new BufferedReader(rdr);){
                                    pluginMetadata.add(PluginLoader.parseMetadata(uriToSearch.toURL(), uri, filename, bufReader));
                                }
                                finally {
                                    if (is == null) continue;
                                    is.close();
                                }
                            }
                            catch (Exception e) {
                                Main.logger.error("Skipping invalid plugin manifest {}", new Object[]{uri, e});
                            }
                        }
                    }
                    catch (Exception e) {
                        Main.logger.error("Error while parsing plugin manifests from jar file: " + root, (Throwable)e);
                    }
                    continue;
                }
                Path pluginsDir = root.resolve(META_INF).resolve(RFB_PLUGINS_DIR);
                if (!Files.isDirectory(pluginsDir, new LinkOption[0])) continue;
                Files.walkFileTree(pluginsDir, new HashSet<FileVisitOption>(Collections.singletonList(FileVisitOption.FOLLOW_LINKS)), 2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Objects.requireNonNull(file);
                        Objects.requireNonNull(attrs);
                        if (file.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".properties")) {
                            try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                                pluginMetadata.add(PluginLoader.parseMetadata(uriToSearch.toURL(), file.toUri(), file.getFileName().toString(), reader));
                            }
                            catch (Exception e) {
                                Main.logger.error("Skipping invalid plugin manifest {}", new Object[]{file, e});
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (Exception e) {
                Main.logger.warn("Could not scan path for RFB plugins: {}", new Object[]{uriToSearch, e});
            }
        }
        Main.logger.info("Successfully scanned {} paths for RFB plugins.", new Object[]{count});
        return pluginMetadata;
    }

    private static RfbPluginMetadata parseMetadata(URL classpathEntry, URI source, String filename, BufferedReader contents) throws IOException {
        int dot = filename.lastIndexOf(46);
        String id = filename.substring(0, dot);
        Properties props = new Properties();
        props.load(contents);
        return new RfbPluginMetadata(classpathEntry, source, id, props);
    }

    private static void closeJarFilesystems() {
        for (FileSystem fs : jarFilesystems) {
            try {
                fs.close();
            }
            catch (Exception exception) {}
        }
        jarFilesystems.clear();
        jarFilesystems.trimToSize();
    }

    static {
        try {
            myURI = Objects.requireNonNull(PluginLoader.class.getResource("PluginLoader.class")).toURI();
            myJar = PluginLoader.class.getProtectionDomain().getCodeSource().getLocation();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

