/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.rfbplugins.compat.transformers;

import com.gtnewhorizons.retrofuturabootstrap.api.ClassHeaderMetadata;
import com.gtnewhorizons.retrofuturabootstrap.api.ClassNodeHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import com.gtnewhorizons.retrofuturabootstrap.asm.SafeAsmClassWriter;
import java.nio.charset.StandardCharsets;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class SafeClassWriterTransformer
implements RfbClassTransformer {
    public static final Attributes.Name MANIFEST_SAFE_ATTRIBUTE = new Attributes.Name("Has-Safe-ClassWriters");
    final String CLASS_WRITER_NAME = ClassWriter.class.getName().replace('.', '/');
    final byte[] CLASS_WRITER_BYTES = this.CLASS_WRITER_NAME.getBytes(StandardCharsets.UTF_8);
    final String SAFE_WRITER_NAME = SafeAsmClassWriter.class.getName().replace('.', '/');

    @Override
    @Pattern(value="[a-z0-9-]+")
    @NotNull
    public String id() {
        return "safe-class-writer";
    }

    @Override
    public boolean shouldTransformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        if (!classNode.isPresent()) {
            return false;
        }
        if (manifest != null && "true".equals(manifest.getMainAttributes().getValue(MANIFEST_SAFE_ATTRIBUTE))) {
            return false;
        }
        return ClassHeaderMetadata.hasSubstring(classNode.getOriginalBytes(), this.CLASS_WRITER_BYTES);
    }

    @Override
    public void transformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode node = classNode.getNode();
        if (node == null) {
            return;
        }
        if (node.superName.equals(this.CLASS_WRITER_NAME)) {
            node.superName = this.SAFE_WRITER_NAME;
        }
        if (node.methods == null) {
            return;
        }
        for (MethodNode method : node.methods) {
            if (method.instructions == null) continue;
            for (AbstractInsnNode rawInsn : method.instructions) {
                AbstractInsnNode insn;
                if (rawInsn.getType() == 3 && rawInsn.getOpcode() == 187) {
                    insn = (TypeInsnNode)rawInsn;
                    if (!insn.desc.equals(this.CLASS_WRITER_NAME)) continue;
                    insn.desc = this.SAFE_WRITER_NAME;
                    continue;
                }
                if (rawInsn.getType() != 5) continue;
                insn = (MethodInsnNode)rawInsn;
                if (!((MethodInsnNode)insn).owner.equals(this.CLASS_WRITER_NAME) || !((MethodInsnNode)insn).name.equals("<init>")) continue;
                ((MethodInsnNode)insn).owner = this.SAFE_WRITER_NAME;
            }
        }
    }
}

