/*
 * Decompiled with CFR 0.152.
 */
package advsolar.network;

import advsolar.network.ASPChannelHandler;
import advsolar.network.IPacket;
import advsolar.network.PacketChangeState;
import advsolar.network.PacketGUIPressButton;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelHandler;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public class ASPPacketHandler {
    public static List<Class<? extends IPacket>> packetTypes = Lists.newArrayList();
    private static EnumMap<Side, FMLEmbeddedChannel> channels;

    public static void load() {
        ASPPacketHandler.registerPacketType(PacketGUIPressButton.class);
        ASPPacketHandler.registerPacketType(PacketChangeState.class);
        channels = NetworkRegistry.INSTANCE.newChannel("AdvSolarPanels", new ChannelHandler[]{new ASPChannelHandler()});
    }

    public static void registerPacketType(Class<? extends IPacket> ptype) {
        packetTypes.add(ptype);
    }

    public static void sendToAllPlayers(IPacket packet) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        channels.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }

    public static void sendToServer(IPacket packet) {
        channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        channels.get(Side.CLIENT).writeOutbound(new Object[]{packet});
    }

    public static void sendToPlayer(EntityPlayer ep, IPacket packet) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)ep);
        channels.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }
}

