/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.client.gui.elements;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.client.gui.screen.SmallFontRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class StringSelectBox
extends GuiButton {
    protected static final ResourceLocation textures = new ResourceLocation("amunra", "textures/gui/gui-extra.png");
    protected List<String> strings = new ArrayList<String>();
    protected int selectedStringIndex = -1;
    protected final int textSize = 8;
    protected int scrollOffset = 0;
    protected int maxLines = 0;
    protected final ISelectBoxCallback parent;
    public SmallFontRenderer font;

    public StringSelectBox(ISelectBoxCallback parent, int id, int xPos, int yPos, int width, int height) {
        super(id, xPos, yPos, width, height, "");
        this.parent = parent;
        Minecraft mc = FMLClientHandler.instance().getClient();
        this.font = new SmallFontRenderer(mc.field_71474_y, new ResourceLocation("textures/font/ascii.png"), mc.field_71446_o, false);
        this.maxLines = height / this.textSize;
    }

    public void clear() {
        this.strings.clear();
        this.clearSelection();
    }

    public void addString(String str) {
        this.strings.add(str);
    }

    public void setSelection(int selection) {
        if (selection >= 0 && selection < this.strings.size() && this.selectedStringIndex != selection) {
            this.selectedStringIndex = selection;
            this.parent.onSelectionChanged(this, this.selectedStringIndex);
        }
    }

    public void clearSelection() {
        if (this.selectedStringIndex != -1) {
            this.selectedStringIndex = -1;
            this.parent.onSelectionChanged(this, this.selectedStringIndex);
        }
    }

    public boolean hasSelection() {
        return this.selectedStringIndex != -1;
    }

    public int getSelectedStringIndex() {
        return this.selectedStringIndex;
    }

    public String getSelectedString() {
        if (this.selectedStringIndex >= 0) {
            return this.strings.get(this.selectedStringIndex);
        }
        return null;
    }

    public void deleteStringAt(int index) {
        this.strings.remove(index);
        this.clearSelection();
    }

    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            int color = -5855578;
            this.func_73733_a(this.field_146128_h, this.field_146129_i, this.field_146128_h + this.field_146120_f, this.field_146129_i + this.field_146121_g, -5855578, -5855578);
            int colorBlack = -16777216;
            this.func_73733_a(this.field_146128_h + 1, this.field_146129_i + 1, this.field_146128_h + this.field_146120_f - 1, this.field_146129_i + this.field_146121_g - 1, -16777216, -16777216);
            int colorGreen = -16711936;
            int colorSelection = -1728017665;
            int displayLines = Math.min(this.strings.size(), this.maxLines);
            for (int i = 0; i < displayLines; ++i) {
                int curYoffset = i * this.textSize;
                int actualIndex = i + this.scrollOffset;
                int colorText = -16711936;
                if (actualIndex == this.selectedStringIndex) {
                    this.func_73733_a(this.field_146128_h + 1, curYoffset + this.field_146129_i + 1, this.field_146128_h + this.field_146120_f - 1, curYoffset + this.field_146129_i + 1 + this.textSize, -1728017665, -1728017665);
                }
                this.font.drawStringWithShadow(this.strings.get(actualIndex), this.field_146128_h + 2, curYoffset + this.field_146129_i, -16711936);
            }
            if (this.maxLines < this.strings.size()) {
                mc.func_110434_K().func_110577_a(textures);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (this.scrollOffset == 0) {
                    this.func_73729_b(this.field_146128_h + this.field_146120_f - 1 - 8, this.field_146129_i + 1, 8, 92, 8, 8);
                } else {
                    this.func_73729_b(this.field_146128_h + this.field_146120_f - 1 - 8, this.field_146129_i + 1, 8, 84, 8, 8);
                }
                if (this.scrollOffset >= this.strings.size() - this.maxLines) {
                    this.func_73729_b(this.field_146128_h + this.field_146120_f - 1 - 8, this.field_146129_i + this.field_146121_g - 1 - 8, 0, 92, 8, 8);
                } else {
                    this.func_73729_b(this.field_146128_h + this.field_146120_f - 1 - 8, this.field_146129_i + this.field_146121_g - 1 - 8, 0, 84, 8, 8);
                }
            }
        }
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        int relativeY;
        int lineClicked;
        if (!super.func_146116_c(mc, mouseX, mouseY)) {
            return false;
        }
        if (this.maxLines < this.strings.size()) {
            int btnMaxX = this.field_146128_h + this.field_146120_f - 1;
            int btnMinX = this.field_146128_h + this.field_146120_f - 1 - 8;
            if (btnMinX <= mouseX && mouseX <= btnMaxX) {
                int btnTopMinY = this.field_146129_i + 1;
                int btnTopMaxY = this.field_146129_i + 8 + 1;
                if (btnTopMinY <= mouseY && mouseY <= btnTopMaxY) {
                    if (this.scrollOffset > 0) {
                        --this.scrollOffset;
                    }
                    return true;
                }
                btnTopMinY = this.field_146129_i + this.field_146121_g - 1 - 8;
                btnTopMaxY = this.field_146129_i + this.field_146121_g - 1;
                if (btnTopMinY <= mouseY && mouseY <= btnTopMaxY) {
                    if (this.scrollOffset < this.strings.size() - this.maxLines) {
                        ++this.scrollOffset;
                    }
                    return true;
                }
            }
        }
        if ((lineClicked = (relativeY = mouseY - this.field_146129_i) / this.textSize) < this.strings.size()) {
            int newIndex = lineClicked + this.scrollOffset;
            this.setSelection(newIndex);
        }
        return true;
    }

    public static interface ISelectBoxCallback {
        public void onSelectionChanged(StringSelectBox var1, int var2);
    }
}

