/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.entity;

import cpw.mods.fml.common.registry.IThrowableEntity;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.mob.DamageSourceAR;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IAntiGrav;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;

public abstract class EntityBaseLaserArrow
extends Entity
implements IProjectile,
IThrowableEntity,
IAntiGrav {
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    protected Block inTile;
    protected int inData;
    public int canBePickedUp;
    protected Entity shootingEntity;
    protected int ticksInGround;
    protected int ticksInAir;
    protected boolean inGround;
    private final int expirationTime = 200;
    private final int knockbackStrength = 0;

    public float getEntityBrightness(float f) {
        return 1.0f;
    }

    public EntityBaseLaserArrow(World world) {
        super(world);
        this.field_70155_l = 10.0;
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityBaseLaserArrow(World world, double x, double y, double z) {
        super(world);
        this.field_70155_l = 10.0;
        this.func_70105_a(0.5f, 0.5f);
        this.func_70107_b(x, y, z);
        this.field_70129_M = 0.0f;
    }

    public EntityBaseLaserArrow(World world, EntityLivingBase shooter, double startX, double startY, double startZ) {
        super(world);
        this.shootingEntity = shooter;
        this.func_70105_a(1.0f, 1.0f);
        this.func_70012_b(startX, startY, startZ, shooter.field_70177_z, shooter.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
    }

    public EntityBaseLaserArrow(World world, EntityLivingBase shootingEntity, EntityLivingBase target, float randMod) {
        super(world);
        this.field_70155_l = 10.0;
        this.shootingEntity = shootingEntity;
        if (shootingEntity instanceof EntityPlayer) {
            this.canBePickedUp = 1;
        }
        this.field_70163_u = shootingEntity.field_70163_u + (double)shootingEntity.func_70047_e() - (double)0.1f;
        double xNew = target.field_70165_t - shootingEntity.field_70165_t;
        double yNew = target.field_70121_D.field_72338_b + (double)(target.field_70131_O / 3.0f) - this.field_70163_u;
        double zNew = target.field_70161_v - shootingEntity.field_70161_v;
        double planarDistance = MathHelper.func_76133_a((double)(xNew * xNew + zNew * zNew));
        if (planarDistance >= 1.0E-7) {
            float xzAngle = (float)(Math.atan2(zNew, xNew) * 180.0 / Math.PI) - 90.0f;
            float yAngle = (float)(-(Math.atan2(yNew, planarDistance) * 180.0 / Math.PI));
            double scaledX = xNew / planarDistance;
            double scaledY = zNew / planarDistance;
            this.func_70012_b(shootingEntity.field_70165_t + scaledX, this.field_70163_u, shootingEntity.field_70161_v + scaledY, xzAngle, yAngle);
            this.field_70129_M = 0.0f;
            float wtf = (float)planarDistance * 0.2f;
            this.func_70186_c(xNew, yNew + (double)wtf, zNew, this.getSpeed(), randMod);
        }
    }

    public EntityBaseLaserArrow(World world, EntityLivingBase shooter, Vector3 startVec, EntityLivingBase target) {
        super(world);
        this.field_70165_t = startVec.x;
        this.field_70163_u = startVec.y;
        this.field_70161_v = startVec.z;
        this.shootingEntity = shooter;
        AxisAlignedBB aabb = target.field_70121_D;
        Vector3 targetPos = new Vector3((Entity)target);
        if (aabb != null) {
            targetPos.y += aabb.field_72337_e - aabb.field_72338_b;
        }
        Vector3 thisToTarget = targetPos.difference(startVec);
        this.field_70129_M = 0.0f;
        this.func_70186_c(thisToTarget.x, thisToTarget.y, thisToTarget.z, this.getSpeed(), 0.0f);
        this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
    }

    public EntityBaseLaserArrow(World par1World, EntityLivingBase par2EntityLivingBase) {
        super(par1World);
        this.field_70155_l = 10.0;
        this.shootingEntity = par2EntityLivingBase;
        if (par2EntityLivingBase instanceof EntityPlayer) {
            this.canBePickedUp = 1;
        }
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(par2EntityLivingBase.field_70165_t, par2EntityLivingBase.field_70163_u + (double)par2EntityLivingBase.func_70047_e(), par2EntityLivingBase.field_70161_v, par2EntityLivingBase.field_70177_z, par2EntityLivingBase.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.getSpeed() * 1.5f, 1.0f);
    }

    protected abstract float getSpeed();

    protected abstract float getDamage();

    protected abstract boolean doesFireDamage();

    public abstract ResourceLocation getTexture();

    protected void onImpactEntity(MovingObjectPosition mop) {
        if (this.doesFireDamage() && !(mop.field_72308_g instanceof EntityEnderman)) {
            if (OxygenUtil.noAtmosphericCombustion((WorldProvider)mop.field_72308_g.field_70170_p.field_73011_w) && !OxygenUtil.isAABBInBreathableAirBlock((World)mop.field_72308_g.field_70170_p, (AxisAlignedBB)mop.field_72308_g.field_70121_D, (boolean)false)) {
                return;
            }
            mop.field_72308_g.func_70015_d(2);
        }
    }

    public void func_70186_c(double p_70186_1_, double p_70186_3_, double p_70186_5_, float p_70186_7_, float p_70186_8_) {
        float f2 = MathHelper.func_76133_a((double)(p_70186_1_ * p_70186_1_ + p_70186_3_ * p_70186_3_ + p_70186_5_ * p_70186_5_));
        p_70186_1_ /= (double)f2;
        p_70186_3_ /= (double)f2;
        p_70186_5_ /= (double)f2;
        p_70186_1_ += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * 0.0075 * (double)p_70186_8_;
        p_70186_3_ += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * 0.0075 * (double)p_70186_8_;
        p_70186_5_ += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * 0.0075 * (double)p_70186_8_;
        this.field_70159_w = p_70186_1_ *= (double)p_70186_7_;
        this.field_70181_x = p_70186_3_ *= (double)p_70186_7_;
        this.field_70179_y = p_70186_5_ *= (double)p_70186_7_;
        float f3 = MathHelper.func_76133_a((double)(p_70186_1_ * p_70186_1_ + p_70186_5_ * p_70186_5_));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(p_70186_1_, p_70186_5_) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(p_70186_3_, f3) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float distXZ = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, distXZ) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    protected DamageSource getDamageSource() {
        if (this.shootingEntity == null) {
            return DamageSourceAR.causeLaserDamage("ar_laser", this, this);
        }
        return DamageSourceAR.causeLaserDamage("ar_laser", this, this.shootingEntity);
    }

    protected void onPassThrough(int x, int y, int z) {
    }

    protected int getEntityDependentDamage(Entity ent, int regularDamage) {
        return regularDamage;
    }

    public void func_70071_h_() {
        Block block;
        super.func_70071_h_();
        if (this.ticksInAir >= this.expirationTime) {
            this.func_70106_y();
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.onPassThrough((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
        }
        if (!(block = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile)).isAir((IBlockAccess)this.field_70170_p, this.xTile, this.yTile, this.zTile)) {
            block.func_149719_a((IBlockAccess)this.field_70170_p, this.xTile, this.yTile, this.zTile);
            AxisAlignedBB axisalignedbb = block.func_149668_a(this.field_70170_p, this.xTile, this.yTile, this.zTile);
            if (axisalignedbb != null && axisalignedbb.func_72318_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v))) {
                this.inGround = true;
            }
        }
        if (this.inGround) {
            this.func_70106_y();
        } else {
            float f1;
            Entity entity1;
            ++this.ticksInAir;
            Vec3 vec3 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 vec31 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            MovingObjectPosition movingobjectposition = this.field_70170_p.func_147447_a(vec3, vec31, false, true, false);
            vec3 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            vec31 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            if (movingobjectposition != null) {
                vec31 = Vec3.func_72443_a((double)movingobjectposition.field_72307_f.field_72450_a, (double)movingobjectposition.field_72307_f.field_72448_b, (double)movingobjectposition.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d0 = 0.0;
            for (int l = 0; l < list.size(); ++l) {
                double d1;
                AxisAlignedBB axisalignedbb1;
                MovingObjectPosition movingobjectposition1;
                entity1 = (Entity)list.get(l);
                if (!entity1.func_70067_L() || entity1 == this.shootingEntity && this.ticksInAir < 5 || (movingobjectposition1 = (axisalignedbb1 = entity1.field_70121_D.func_72314_b((double)(f1 = 0.3f), (double)f1, (double)f1)).func_72327_a(vec3, vec31)) == null || !((d1 = vec3.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity);
            }
            if (movingobjectposition != null && movingobjectposition.field_72308_g != null && (entity1 = movingobjectposition.field_72308_g) instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity1;
                if (entityplayer.field_71075_bZ.field_75102_a || this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).func_96122_a(entityplayer)) {
                    movingobjectposition = null;
                }
            }
            double damage = this.getDamage();
            if (movingobjectposition != null) {
                if (movingobjectposition.field_72308_g != null) {
                    float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                    int dmgValue = this.getEntityDependentDamage(movingobjectposition.field_72308_g, MathHelper.func_76143_f((double)((double)f2 * damage)));
                    DamageSource damagesource = this.getDamageSource();
                    if (!this.field_70170_p.field_72995_K) {
                        this.onImpactEntity(movingobjectposition);
                    }
                    if (movingobjectposition.field_72308_g.func_70097_a(damagesource, (float)dmgValue)) {
                        Entity entity2 = movingobjectposition.field_72308_g;
                        if (entity2 instanceof EntityLivingBase) {
                            Entity entity3;
                            float f3;
                            EntityLivingBase entitylivingbase = (EntityLivingBase)entity2;
                            if (this.knockbackStrength > 0 && (f3 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                                movingobjectposition.field_72308_g.func_70024_g(this.field_70159_w * (double)this.knockbackStrength * (double)0.6f / (double)f3, 0.1, this.field_70179_y * (double)this.knockbackStrength * (double)0.6f / (double)f3);
                            }
                            if (this.shootingEntity != null) {
                                EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)this.shootingEntity);
                                EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.shootingEntity), (Entity)entitylivingbase);
                            }
                            if (this.shootingEntity != null && movingobjectposition.field_72308_g != this.shootingEntity && movingobjectposition.field_72308_g instanceof EntityPlayer && (entity3 = this.shootingEntity) instanceof EntityPlayerMP) {
                                EntityPlayerMP entityPlayer = (EntityPlayerMP)entity3;
                                entityPlayer.field_71135_a.func_147359_a((Packet)new S2BPacketChangeGameState(6, 0.0f));
                            }
                        }
                        if (!(movingobjectposition.field_72308_g instanceof EntityEnderman)) {
                            this.func_70106_y();
                        }
                    } else {
                        this.func_70106_y();
                    }
                } else {
                    this.xTile = movingobjectposition.field_72311_b;
                    this.yTile = movingobjectposition.field_72312_c;
                    this.zTile = movingobjectposition.field_72309_d;
                    this.inTile = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
                    this.inData = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
                    this.field_70159_w = (float)(movingobjectposition.field_72307_f.field_72450_a - this.field_70165_t);
                    this.field_70181_x = (float)(movingobjectposition.field_72307_f.field_72448_b - this.field_70163_u);
                    this.field_70179_y = (float)(movingobjectposition.field_72307_f.field_72449_c - this.field_70161_v);
                    float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                    this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
                    this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
                    this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
                    this.inGround = true;
                    if (!this.inTile.isAir((IBlockAccess)this.field_70170_p, this.xTile, this.yTile, this.zTile)) {
                        if (!this.field_70170_p.field_72995_K) {
                            this.onImpactBlock(this.field_70170_p, this.xTile, this.yTile, this.zTile);
                        }
                        this.inTile.func_149670_a(this.field_70170_p, this.xTile, this.yTile, this.zTile, (Entity)this);
                    }
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            float f4 = 0.99f;
            f1 = 0.05f;
            this.field_70159_w *= (double)0.99f;
            this.field_70181_x *= (double)0.99f;
            this.field_70179_y *= (double)0.99f;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    protected void onPassWater() {
    }

    protected void onImpactBlock(World worldObj, int xTile2, int yTile2, int zTile2) {
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    protected void func_70037_a(NBTTagCompound tagCompund) {
        this.xTile = tagCompund.func_74765_d("xTile");
        this.yTile = tagCompund.func_74765_d("yTile");
        this.zTile = tagCompund.func_74765_d("zTile");
        this.ticksInAir = tagCompund.func_74765_d("life");
        this.inTile = Block.func_149729_e((int)(tagCompund.func_74771_c("inTile") & 0xFF));
        this.inData = tagCompund.func_74771_c("inData") & 0xFF;
        this.inGround = tagCompund.func_74771_c("inGround") == 1;
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74777_a("xTile", (short)this.xTile);
        tagCompound.func_74777_a("yTile", (short)this.yTile);
        tagCompound.func_74777_a("zTile", (short)this.zTile);
        tagCompound.func_74777_a("life", (short)this.ticksInAir);
        tagCompound.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.inTile));
        tagCompound.func_74774_a("inData", (byte)this.inData);
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (!this.field_70170_p.field_72995_K && this.inGround) {
            this.func_70106_y();
        }
    }

    public boolean func_70075_an() {
        return false;
    }

    public Entity getThrower() {
        return this.shootingEntity;
    }

    public void setThrower(Entity entity) {
        this.shootingEntity = entity;
    }
}

