/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world.mapgen.volcano;

import de.katzenpapst.amunra.world.mapgen.BaseStructureStart;
import de.katzenpapst.amunra.world.mapgen.StructureGenerator;
import de.katzenpapst.amunra.world.mapgen.volcano.Volcano;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import net.minecraft.util.MathHelper;

public class VolcanoGenerator
extends StructureGenerator {
    protected final BlockMetaPair fluid;
    protected final BlockMetaPair mountainMaterial;
    protected final BlockMetaPair shaftMaterial;
    protected final int maxDepth;
    protected final boolean createMagmaChamber;

    public VolcanoGenerator(BlockMetaPair fluid, BlockMetaPair mountainMaterial, BlockMetaPair shaftMaterial, int maxDepth, boolean magmaChamber) {
        this.fluid = fluid;
        this.mountainMaterial = mountainMaterial;
        this.shaftMaterial = shaftMaterial;
        this.maxDepth = maxDepth;
        this.createMagmaChamber = magmaChamber;
    }

    @Override
    protected long getSalt() {
        return 84375932847598L;
    }

    @Override
    protected boolean canGenerateHere(int chunkX, int chunkZ, Random rand) {
        int rangeShift = 4;
        int range = 16;
        int superchunkX = chunkX >> 4;
        int superchunkZ = chunkZ >> 4;
        int chunkStartX = superchunkX << 4;
        int chunkStartZ = superchunkZ << 4;
        int chunkEndX = chunkStartX + 16 - 1;
        int chunkEndZ = chunkStartZ + 16 - 1;
        this.rand.setSeed(this.worldObj.func_72905_C() ^ this.getSalt() ^ (long)superchunkX ^ (long)superchunkZ);
        int actualVillageX = MathHelper.func_76136_a((Random)this.rand, (int)chunkStartX, (int)chunkEndX);
        int actualVillageZ = MathHelper.func_76136_a((Random)this.rand, (int)chunkStartZ, (int)chunkEndZ);
        return chunkX == actualVillageX && chunkZ == actualVillageZ;
    }

    @Override
    protected BaseStructureStart createNewStructure(int xChunkCoord, int zChunkCoord) {
        Random rand = new Random(this.worldObj.func_72905_C() ^ (long)xChunkCoord ^ (long)zChunkCoord ^ this.getSalt());
        Volcano v = new Volcano(this.worldObj, xChunkCoord, zChunkCoord, rand);
        v.setFluid(this.fluid);
        v.setMaxDepth(this.maxDepth);
        v.setMountainMaterial(this.mountainMaterial);
        v.setShaftMaterial(this.shaftMaterial);
        v.setHasMagmaChamber(this.createMagmaChamber);
        return v;
    }

    @Override
    public String getName() {
        return "Volcano";
    }
}

